/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity;

import com.b100.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.core.entity.SkinVariantList;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ClientSkinVariantList
extends SkinVariantList {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MAX_VARIANT_ID = 255;
    private final Minecraft mc;
    private final Map<String, @Nullable EntityVariants> variantProcessorMap = new HashMap<String, EntityVariants>();

    public ClientSkinVariantList(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void refresh(List<Throwable> errors) {
        this.variantProcessorMap.clear();
    }

    @Override
    @NotNull
    public String getSkinReference(@Nullable String variantJsonPath, @NotNull String defaultKey, int skinIndex) {
        EntityVariants variants = this.getEntityVariants(variantJsonPath);
        if (variants == null) {
            return defaultKey;
        }
        return variants.getKeyFromIndex(skinIndex);
    }

    @Nullable
    protected EntityVariants getEntityVariants(@Nullable String variantJsonPath) {
        try {
            if (!((Boolean)GameSettings.MOB_VARIANTS.value).booleanValue()) {
                return null;
            }
            if (variantJsonPath == null) {
                return null;
            }
            if (this.variantProcessorMap.containsKey(variantJsonPath)) {
                return this.variantProcessorMap.get(variantJsonPath);
            }
            EntityVariants variants = this.loadJson(variantJsonPath);
            this.variantProcessorMap.put(variantJsonPath, variants);
            return variants;
        }
        catch (Exception e) {
            LOGGER.error("Failed to load json at '{}'!", (Object)variantJsonPath, (Object)e);
            this.variantProcessorMap.put(variantJsonPath, null);
            return null;
        }
    }

    @Override
    public int nextSkinVariant(@Nullable String variantJsonPath, int skinIndex) {
        EntityVariants variants = this.getEntityVariants(variantJsonPath);
        if (variants == null) {
            return skinIndex;
        }
        return variants.getNextVariant(skinIndex);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected EntityVariants loadJson(String variantJsonPath) {
        try {
            InputStream stream;
            block19: {
                block21: {
                    JsonElement skins;
                    block20: {
                        String jsonString;
                        block18: {
                            stream = this.mc.texturePackList.getResourceAsStream(variantJsonPath);
                            if (stream != null) break block18;
                            EntityVariants entityVariants3 = null;
                            if (stream == null) return entityVariants3;
                            stream.close();
                            return entityVariants3;
                        }
                        try {
                            jsonString = StringUtils.readInputString(stream);
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to parse '{}' as a Json String!", (Object)variantJsonPath, (Object)e);
                            if (stream == null) return null;
                            stream.close();
                            return null;
                        }
                        JsonObject variantObject = JsonParser.parseString(jsonString).getAsJsonObject();
                        if (!variantObject.has("skins")) break block19;
                        skins = variantObject.get("skins");
                        if (!skins.isJsonPrimitive()) break block20;
                        EntityVariants entityVariants2 = new EntityVariants(skins.getAsInt());
                        if (stream == null) return entityVariants2;
                        stream.close();
                        return entityVariants2;
                    }
                    if (!skins.isJsonArray()) break block21;
                    ArrayList<EntityVariants.VariantEntry> variants = new ArrayList<EntityVariants.VariantEntry>();
                    JsonArray arr = skins.getAsJsonArray();
                    for (JsonElement e : arr) {
                        JsonObject entryObj = e.getAsJsonObject();
                        String textureReference = entryObj.get("texture").getAsString();
                        double weight = 1.0;
                        if (entryObj.has("weight")) {
                            weight = entryObj.get("weight").getAsDouble();
                        }
                        variants.add(new EntityVariants.VariantEntry(textureReference, weight));
                    }
                    EntityVariants entityVariants = new EntityVariants(variants);
                    if (stream == null) return entityVariants;
                    stream.close();
                    return entityVariants;
                }
                LOGGER.error("Error at {}: value 'skins' must either be a integer or an array!", (Object)variantJsonPath);
                if (stream == null) return null;
                stream.close();
                return null;
            }
            try {
                return null;
                catch (JsonParseException e) {
                    LOGGER.error("Failed to parse Json at {}", (Object)variantJsonPath, (Object)e);
                    return null;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("IO Exception while trying to read '{}'!", (Object)variantJsonPath, (Object)e);
            return null;
        }
    }

    protected static class EntityVariants {
        private final String @Nullable [] indexedSkins;
        private final VariantEntry @Nullable [] variantEntries;

        public EntityVariants(int skins) {
            if (skins <= 0) {
                throw new IllegalArgumentException("Skins number attribute must be at-least 1!");
            }
            this.indexedSkins = new String[skins];
            for (int i = 0; i < this.indexedSkins.length; ++i) {
                this.indexedSkins[i] = Integer.toString(i);
            }
            this.variantEntries = null;
        }

        public EntityVariants(List<VariantEntry> entries) {
            block7: {
                this.variantEntries = new VariantEntry[256];
                this.indexedSkins = null;
                double accWeight = 0.0;
                entries.sort(Comparator.comparingDouble(o -> -o.weight));
                for (VariantEntry variantEntry : entries) {
                    accWeight += variantEntry.weight;
                }
                int pointer = 0;
                for (VariantEntry e : entries) {
                    int amount = MathHelper.floor(e.weight / accWeight * 255.0);
                    if (amount < 1) {
                        amount = 1;
                    }
                    for (int i = 0; i < amount; ++i) {
                        this.variantEntries[pointer] = e;
                        if (++pointer <= this.variantEntries.length - 1) {
                            continue;
                        }
                        break block7;
                    }
                }
                VariantEntry variantEntry = entries.get(0);
                while (pointer < this.variantEntries.length) {
                    this.variantEntries[pointer] = variantEntry;
                    ++pointer;
                }
            }
            Object2IntOpenHashMap<String> counts = new Object2IntOpenHashMap<String>();
            for (VariantEntry e : this.variantEntries) {
                counts.putIfAbsent(e.textureKey, 0);
                counts.put(e.textureKey, counts.getInt(e.textureKey) + 1);
            }
        }

        @NotNull
        public String getKeyFromIndex(int index) {
            if (this.variantEntries != null) {
                return this.variantEntries[index].textureKey;
            }
            assert (this.indexedSkins != null);
            return this.indexedSkins[index % this.indexedSkins.length];
        }

        public int getNextVariant(int index) {
            if (this.variantEntries != null) {
                VariantEntry currentEntry = this.variantEntries[index];
                for (int i = 1; i < this.variantEntries.length; ++i) {
                    if (currentEntry == this.variantEntries[(index + i) % this.variantEntries.length]) continue;
                    return (index + i) % this.variantEntries.length;
                }
                return index;
            }
            assert (this.indexedSkins != null);
            return (index + 1) % this.indexedSkins.length;
        }

        protected static class VariantEntry {
            public final String textureKey;
            public final double weight;

            public VariantEntry(String key, double weight) {
                this.textureKey = key;
                this.weight = weight;
            }
        }
    }
}

