/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.container;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuActivator;
import net.minecraft.core.sound.SoundCategory;

public class ScreenActivator
extends ScreenContainerAbstract {
    protected final TileEntityActivator tileEntityActivator;
    protected final List<ButtonElement> slotButtons = new ArrayList<ButtonElement>();

    public ScreenActivator(ContainerInventory inventory, TileEntityActivator activatorBlock) {
        super(new MenuActivator(inventory, activatorBlock));
        this.tileEntityActivator = activatorBlock;
    }

    @Override
    public void init() {
        super.init();
        int xLeft = (this.width - this.xSize) / 2;
        int yTop = (this.height - this.ySize) / 2;
        int startX = xLeft + 7;
        int startY = yTop + 34;
        this.buttons.clear();
        this.slotButtons.clear();
        for (int i = 0; i < this.tileEntityActivator.getContainerSize(); ++i) {
            ButtonElement button = new ButtonElement(i, startX + 18 * i, startY, 18, 18, "");
            button.visible = false;
            this.slotButtons.add(button);
        }
    }

    @Override
    public void clickInventory(int x, int y, int mouseButton) {
        if (mouseButton == 1 && this.mc.thePlayer.inventory.getHeldItemStack() == null) {
            for (ButtonElement button : this.slotButtons) {
                if (this.tileEntityActivator.getItem(button.id) != null || !button.mouseClicked(this.mc, x, y)) continue;
                this.mc.playerController.handleInventoryMouseClick(this.inventorySlots.containerId, InventoryAction.LOCK, new int[]{button.id, 0}, this.mc.thePlayer);
                if (!button.playSound) break;
                this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                break;
            }
        }
        super.clickInventory(x, y, mouseButton);
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        this.drawStringNoShadow(this.fontRenderer, I18n.getInstance().translateKey("gui.activator.label.activator"), 60, 6, 0x404040);
        this.drawStringNoShadow(this.fontRenderer, I18n.getInstance().translateKey("gui.activator.label.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTick) {
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/container/activator.png").bind();
        int xLeft = (this.width - this.xSize) / 2;
        int yTop = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(xLeft, yTop, 0, 0, this.xSize, this.ySize);
        if (!this.tileEntityActivator.locked(this.tileEntityActivator.stackSelector)) {
            int startX = xLeft + 7;
            int startY = yTop + 26;
            this.drawTexturedModalRect(startX + 18 * this.tileEntityActivator.stackSelector, startY, 176, 0, 18, 34);
        }
    }
}

