/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.option.OptionInteger;
import net.minecraft.client.render.window.CursorShape;
import org.jetbrains.annotations.Nullable;

public class IntegerOptionComponent
extends ButtonComponent {
    private final OptionInteger option;
    private final ButtonElement button;

    public IntegerOptionComponent(OptionInteger option) {
        this(option, null);
    }

    public IntegerOptionComponent(OptionInteger option, @Nullable String tooltipTranslationKey) {
        super("options." + option.id, tooltipTranslationKey);
        this.option = option;
        this.option.addOnChangeCallback((mc, __) -> this.onChanged());
        this.button = new ButtonElement(0, 0, 0, 150, 20, this.option.getDisplayString());
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.option.set((Integer)this.option.value + 1);
        this.option.onUpdate();
        this.onChanged();
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.button.xPosition = x + relativeButtonX;
        this.button.yPosition = y + relativeButtonY;
        this.button.width = buttonWidth;
        this.button.height = buttonHeight;
        this.button.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        if (relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            IntegerOptionComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
    }

    @Override
    public void resetValue() {
        this.option.set((Integer)this.option.getDefaultValue());
        this.onChanged();
        this.option.onUpdate();
    }

    protected void onChanged() {
        this.button.displayString = this.option.getDisplayStringValue();
    }

    @Override
    public void init(Minecraft mc) {
        this.onChanged();
    }

    @Override
    public boolean isDefault() {
        return ((Integer)this.option.value).equals(this.option.getDefaultValue());
    }
}

