/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.handler;

import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.server.ServerEntry;
import net.minecraft.client.gui.server.ServerListenerThread;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.ServerAddress;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketDisconnect;
import net.minecraft.core.net.packet.PacketServerIcon;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class PingPacketHandler
extends PacketHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public boolean disconnected = false;
    private final ServerListenerThread listener;
    private final NetworkManager netManager;
    private final ServerEntry server;
    private final long startTime;

    public PingPacketHandler(ServerListenerThread listener, ServerEntry server) throws IOException {
        this.listener = listener;
        this.server = server;
        ServerAddress address = server.getServerAddress();
        Socket socket = new Socket(InetAddress.getByName(address.getIP()), address.getPort());
        this.netManager = new NetworkManager(socket, "Ping", this, 100, true);
        this.startTime = System.currentTimeMillis();
        server.isUp = false;
    }

    public void processReadPackets() {
        if (!this.disconnected) {
            this.netManager.processReadPackets();
        }
        this.netManager.wakeThreads();
    }

    public void addToSendQueue(Packet packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(packet);
        }
    }

    @Override
    public boolean isServerHandler() {
        return false;
    }

    @Override
    public void handleDisconnect(@NotNull PacketDisconnect packetDisconnect) {
        if (packetDisconnect.reason.startsWith("\u00a71")) {
            String[] serverInfo = packetDisconnect.reason.split("\u0000");
            this.server.isUp = true;
            this.server.protocolVersion = this.parseIntWithDefault(serverInfo[1], -1);
            this.server.version = serverInfo[2];
            this.server.motd = serverInfo[3];
            this.server.playerCount = this.parseIntWithDefault(serverInfo[4], -1);
            this.server.playerCap = this.parseIntWithDefault(serverInfo[5], -1);
            this.server.ping = System.currentTimeMillis() - this.startTime;
            if (serverInfo.length >= 7) {
                this.server.baseName = serverInfo[6];
            }
            this.server.players.clear();
            if (serverInfo.length >= 8) {
                String playersString = serverInfo[7];
                String[] players = playersString.split(",");
                this.server.players.addAll(Arrays.asList(players));
            }
            this.listener.handleIncomingServerInfo(this.server);
            this.netManager.networkShutdown("disconnect.kicked", new Object[0]);
            this.disconnected = true;
        }
    }

    @Override
    public void handleServerIcon(@NotNull PacketServerIcon packetServerIcon) {
        try {
            this.server.queuedIcon = ImageIO.read(new ByteArrayInputStream(packetServerIcon.image));
        }
        catch (IOException e) {
            LOGGER.error("", e);
        }
    }

    private int parseIntWithDefault(String s, int i) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (Exception exception) {
            return i;
        }
    }

    @Override
    public void handleErrorMessage(String message, Object[] objects) {
        if (!this.disconnected) {
            this.disconnected = true;
        }
    }
}

