/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.MouseFilter;
import net.minecraft.client.input.PlayerInput;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.ParticlesQuality;
import net.minecraft.client.render.FogManager;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.camera.EntityCameraFirstPerson;
import net.minecraft.client.render.camera.EntityCameraIsometric;
import net.minecraft.client.render.camera.EntityCameraSleeping;
import net.minecraft.client.render.camera.EntityCameraThirdPersonFront;
import net.minecraft.client.render.camera.EntityCameraThirdPersonRear;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.client.render.particle.ParticleSmoke;
import net.minecraft.client.render.particle.ParticleWaterDrop;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.CompareFunc;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.client.render.worldtype.WorldTypeFXDispatcher;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobPig;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.debug.Debug;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Time;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.weather.IPrecipitation;
import net.minecraft.core.world.weather.Weather;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class WorldRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final long nsPerSecond = 1000000000L;
    public final LightmapHelper lightmapHelper;
    public Minecraft mc;
    public float farPlaneDistance;
    public ItemRenderer itemRenderer;
    public FogManager fogManager;
    private int rendererUpdateCount;
    private Entity pointedEntity;
    private final MouseFilter mouseFilterXAxis;
    private final MouseFilter mouseFilterYAxis;
    private final float fovModifier;
    private float fovModifierLast;
    private long systemTime;
    private final Random random;
    private int rainSoundCounter;
    public boolean zooming = false;
    private float zoomProgress;
    private float fovMod = 1.0f;
    private float fovModOld = 1.0f;

    public WorldRenderer(Minecraft minecraft) {
        this.mc = minecraft;
        this.lightmapHelper = new LightmapHelper(minecraft, this);
        this.farPlaneDistance = 0.0f;
        this.pointedEntity = null;
        this.mouseFilterXAxis = new MouseFilter();
        this.mouseFilterYAxis = new MouseFilter();
        this.fovModifier = 0.0f;
        this.fovModifierLast = 0.0f;
        this.systemTime = 0L;
        this.random = new Random();
        this.rainSoundCounter = 0;
        this.itemRenderer = new ItemRenderer(minecraft);
        this.fogManager = new FogManager(this.mc);
    }

    public void updateRenderer() {
        this.updateSpeedFov();
        this.fovModifierLast = this.fovModifier;
        if (this.mc.activeCamera == null) {
            this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, this.mc.thePlayer);
        }
        this.mc.activeCamera.tick();
        this.fogManager.updateBrightness();
        ++this.rendererUpdateCount;
        this.itemRenderer.updateEquippedItem();
        this.addRainParticles();
        this.lightmapHelper.tick();
    }

    private void updateSpeedFov() {
        PlayerLocal player = this.mc.thePlayer;
        float currentFovModifier = (Boolean)GameSettings.FOV_MODIFICATION.value != false ? player.getFovModifier() : 1.0f;
        this.fovModOld = this.fovMod;
        this.fovMod += (currentFovModifier - this.fovMod) * 0.5f;
    }

    public void getMouseOver(float partialTicks) {
        if (this.mc.activeCamera == null) {
            return;
        }
        if (this.mc.currentWorld == null) {
            return;
        }
        double blockReach = this.mc.thePlayer.getGamemode().getBlockReachDistance();
        double entityReach = this.mc.thePlayer.getGamemode().getEntityReachDistance();
        Vector3dc pos1 = this.mc.thePlayer.getPosition(partialTicks, true);
        Vector3dc look = this.mc.thePlayer.getViewVector(partialTicks);
        assert (look != null);
        Vector3d pos2 = pos1.add(look.x() * blockReach, look.y() * blockReach, look.z() * blockReach, new Vector3d());
        this.mc.objectMouseOver = this.mc.thePlayer.rayCast(blockReach, partialTicks, false, false, true);
        double hitBlockDistance = 1000.0;
        if (this.mc.objectMouseOver != null) {
            hitBlockDistance = pos1.distance(this.mc.objectMouseOver.location);
        }
        this.pointedEntity = null;
        float expand = 1.0f;
        AABBd entitySearchBox = MathHelper.aabbExpand(this.mc.thePlayer.bb, look.x() * entityReach, look.y() * entityReach, look.z() * entityReach, new AABBd());
        MathHelper.aabbGrow(entitySearchBox, expand, expand, expand, entitySearchBox);
        List<Entity> entities = this.mc.currentWorld.getEntitiesWithinAABBExcludingEntity(this.mc.thePlayer, entitySearchBox);
        double pointedEntityDistance = 0.0;
        for (int i = 0; i < entities.size(); ++i) {
            Entity entity = entities.get(i);
            if (!entity.isSelectable()) continue;
            float hitRadius = entity == this.mc.thePlayer.vehicle ? 0.0f : entity.getPickRadius();
            AABBd hitBox = MathHelper.aabbGrow(entity.bb, hitRadius, hitRadius, hitRadius, new AABBd());
            if (hitBox.containsPoint(pos1)) {
                this.pointedEntity = entity;
                pointedEntityDistance = 0.0;
                continue;
            }
            HitResult.Clip hitResult = MathHelper.aabbClip(hitBox, pos1, pos2);
            if (hitResult == null) continue;
            double entityDistance = pos1.distance(hitResult.location);
            if (this.pointedEntity != null && !(entityDistance < pointedEntityDistance)) continue;
            this.pointedEntity = entity;
            pointedEntityDistance = entityDistance;
        }
        if (pointedEntityDistance > hitBlockDistance || pointedEntityDistance > entityReach) {
            this.pointedEntity = null;
        }
        if (this.pointedEntity != null) {
            this.mc.objectMouseOver = new HitResult.Entity(this.pointedEntity);
        }
    }

    private float getFOVModifier(float partialTick, boolean isModifiedByFOV) {
        Mob entityliving = null;
        ICamera iCamera = this.mc.activeCamera;
        if (iCamera instanceof EntityCamera) {
            EntityCamera entityCamera = (EntityCamera)iCamera;
            entityliving = entityCamera.mob;
        }
        float fov = 70.0f;
        if (isModifiedByFOV) {
            fov = (int)(this.mc.activeCamera.getFov() * 100.0 + 30.0);
            fov *= org.joml.Math.lerp(this.fovModOld, this.fovMod, partialTick);
        }
        if (((Boolean)GameSettings.FOV_MODIFICATION.value).booleanValue() && CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.currentWorld, Materials.WATER, partialTick)) {
            fov -= 10.0f;
        }
        if (entityliving != null && entityliving.getHealth() <= 0) {
            float f2 = (float)entityliving.deathTime + partialTick;
            fov /= (1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f;
        }
        return fov + this.fovModifierLast + (this.fovModifier - this.fovModifierLast) * partialTick;
    }

    @NotNull
    private Matrix4f hurtCameraEffect(@NotNull Matrix4f matrix, float partialTick) {
        ICamera iCamera = this.mc.activeCamera;
        if (!(iCamera instanceof EntityCamera)) {
            return matrix;
        }
        EntityCamera entityCamera = (EntityCamera)iCamera;
        Mob mob = entityCamera.mob;
        float hurtInterp = (float)mob.hurtTime - partialTick;
        if (mob.getHealth() <= 0) {
            float f2 = (float)mob.deathTime + partialTick;
            matrix.rotateZ(org.joml.Math.toRadians(40.0f - 8000.0f / (f2 + 200.0f)));
        }
        if (hurtInterp >= 0.0f) {
            hurtInterp /= (float)mob.maxHurtTime;
            hurtInterp = MathHelper.sin(hurtInterp * hurtInterp * hurtInterp * hurtInterp * (float)Math.PI);
            float f3 = mob.attackedAtYaw;
            matrix.rotateY(org.joml.Math.toRadians(-f3));
            matrix.rotateZ(org.joml.Math.toRadians(-hurtInterp * 14.0f));
            matrix.rotateY(org.joml.Math.toRadians(f3));
        }
        return matrix;
    }

    @NotNull
    private Matrix4f setupViewBobbing(@NotNull Matrix4f matrix, float partialTick, boolean isHand) {
        Object object = this.mc.activeCamera;
        if (object instanceof EntityCamera) {
            EntityCamera entityCamera = (EntityCamera)object;
            object = entityCamera.mob;
            if (object instanceof Player) {
                Player player = (Player)object;
                float walkDist = -MathHelper.lerp(player.walkDistO, player.walkDist, partialTick);
                float cameraVel = MathHelper.lerp(player.cameraVelocityOld, player.cameraVelocity, partialTick);
                float cameraPitch = MathHelper.lerp(player.prevCameraPitch, player.cameraPitch, partialTick);
                if (isHand && player.vehicle instanceof MobPig) {
                    cameraVel /= 4.0f;
                    walkDist /= 2.0f;
                }
                if (player.isSkating) {
                    walkDist *= 0.25f;
                    cameraPitch *= 0.25f;
                }
                matrix.translate(MathHelper.sin(walkDist * (float)Math.PI) * cameraVel * 0.5f, -Math.abs(MathHelper.cos(walkDist * (float)Math.PI) * cameraVel), 0.0f);
                matrix.rotateZ(org.joml.Math.toRadians(MathHelper.sin(walkDist * (float)Math.PI) * cameraVel * 3.0f));
                matrix.rotateX(org.joml.Math.toRadians(org.joml.Math.abs(MathHelper.cos(walkDist * (float)Math.PI - 0.2f) * cameraVel) * 5.0f));
                matrix.rotateX(org.joml.Math.toRadians(cameraPitch));
            }
        }
        return matrix;
    }

    private void setupCamera(float partialTick) {
        ICamera iCamera = this.mc.activeCamera;
        if (iCamera instanceof EntityCamera) {
            EntityCamera entityCamera = (EntityCamera)iCamera;
            Mob mob = entityCamera.mob;
            if (this.mc.currentScreen instanceof ScreenPhotoMode) {
                this.mc.activeCamera = new EntityCameraIsometric(this.mc, mob);
            } else if (mob.isPlayerSleeping()) {
                if (!(this.mc.activeCamera instanceof EntityCameraSleeping)) {
                    this.mc.activeCamera = new EntityCameraSleeping(this.mc, mob, MathHelper.floor(mob.x), MathHelper.floor(mob.y), MathHelper.floor(mob.z), this.mc.activeCamera.getX(partialTick), this.mc.activeCamera.getY(partialTick), this.mc.activeCamera.getZ(partialTick), this.mc.activeCamera.getYRot(partialTick), this.mc.activeCamera.getXRot(partialTick));
                }
            } else if ((Integer)GameSettings.THIRD_PERSON_VIEW.value == 0 && !(this.mc.activeCamera instanceof EntityCameraFirstPerson)) {
                this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, mob);
            } else if ((Integer)GameSettings.THIRD_PERSON_VIEW.value == 1 && !(this.mc.activeCamera instanceof EntityCameraThirdPersonRear)) {
                this.mc.activeCamera = new EntityCameraThirdPersonRear(this.mc, mob);
            } else if ((Integer)GameSettings.THIRD_PERSON_VIEW.value == 2 && !(this.mc.activeCamera instanceof EntityCameraThirdPersonFront)) {
                this.mc.activeCamera = new EntityCameraThirdPersonFront(this.mc, mob);
            }
        }
    }

    @NotNull
    public Matrix4f orientCamera(@NotNull Matrix4f matrix, float partialTick) {
        Screen screen;
        this.setupCamera(partialTick);
        if (!(this.mc.currentScreen instanceof ScreenPhotoMode) && !((Boolean)GameSettings.LOCK_CAMERA.value).booleanValue()) {
            matrix.rotateX(org.joml.Math.toRadians((float)this.mc.activeCamera.getXRot(partialTick)));
            matrix.rotateY(org.joml.Math.toRadians((float)(this.mc.activeCamera.getYRot(partialTick) + 180.0)));
        }
        if ((screen = this.mc.currentScreen) instanceof ScreenPhotoMode) {
            ScreenPhotoMode screenPhotoMode = (ScreenPhotoMode)screen;
            matrix.rotateX(org.joml.Math.toRadians(screenPhotoMode.getTilt(partialTick)));
            matrix.rotateY(org.joml.Math.toRadians(45.0f + 45.0f * screenPhotoMode.getRotation(partialTick)));
        }
        return matrix;
    }

    @NotNull
    public Matrix4f getProjectionMatrix(@NotNull Matrix4f matrix, float partialTick) {
        matrix.identity();
        this.farPlaneDistance = (Integer)GameSettings.RENDER_DISTANCE.value * 16;
        float fov = this.getFOVModifier(partialTick, true);
        if (this.zooming) {
            fov = this.getZoomedFOV(fov, partialTick);
        } else {
            this.zoomProgress = 0.0f;
        }
        Screen screen = this.mc.currentScreen;
        if (screen instanceof ScreenPhotoMode) {
            ScreenPhotoMode screenPhotoMode = (ScreenPhotoMode)screen;
            double div = Math.pow(2.0, screenPhotoMode.getZoom(partialTick));
            matrix.translate(1.0f, 1.0f, 0.0f);
            matrix.ortho(0.0f, (float)((double)this.mc.gameWindow.getWidthPixels() / div), 0.0f, (float)((double)this.mc.gameWindow.getHeightPixels() / div), this.farPlaneDistance * -2.0f, this.farPlaneDistance * 2.0f);
            matrix.translate(screenPhotoMode.getPanX(partialTick), -screenPhotoMode.getPanY(partialTick), 0.0f);
        } else {
            matrix.identity().perspective(org.joml.Math.toRadians(fov), (float)this.mc.gameWindow.getWidthPixels() / (float)this.mc.gameWindow.getHeightPixels(), 0.05f, this.farPlaneDistance * 2.0f);
        }
        return matrix;
    }

    @NotNull
    public Matrix4f getViewMatrix(@NotNull Matrix4f matrix, float partialTick) {
        float portalIntensity;
        matrix.identity();
        this.hurtCameraEffect(matrix, partialTick);
        if (((Boolean)GameSettings.VIEW_BOBBING.value).booleanValue() && !(this.mc.currentScreen instanceof ScreenPhotoMode)) {
            this.setupViewBobbing(matrix, partialTick, false);
        }
        float f = portalIntensity = (Boolean)GameSettings.SCREEN_MOTION_EFFECTS.value != false ? MathHelper.lerp(this.mc.thePlayer.prevTimeInPortal, this.mc.thePlayer.timeInPortal, partialTick) : 0.0f;
        if (portalIntensity > 0.0f) {
            float f3 = 5.0f / (portalIntensity * portalIntensity + 5.0f) - portalIntensity * 0.04f;
            f3 *= f3;
            float rotation = org.joml.Math.toRadians(((float)this.rendererUpdateCount + partialTick) * 20.0f);
            matrix.rotate(rotation, 0.0f, 0.7071f, 0.7071f);
            matrix.scale(1.0f / f3, 1.0f, 1.0f);
            matrix.rotate(-rotation, 0.0f, 0.7071f, 0.7071f);
        }
        this.orientCamera(matrix, partialTick);
        return matrix;
    }

    private void renderHand(float partialTick) {
        Matrix4f projMat = GLRenderer.projectionM4f();
        projMat.identity();
        this.farPlaneDistance = (Integer)GameSettings.RENDER_DISTANCE.value * 16;
        float fov = this.getFOVModifier(partialTick, false);
        if (this.zooming) {
            fov = this.getZoomedFOV(fov, partialTick);
        } else {
            this.zoomProgress = 0.0f;
        }
        projMat.translate(0.0f, 0.0f, -1.0f);
        projMat.scale(1.0f, 1.0f, 0.1f);
        projMat.perspective(org.joml.Math.toRadians(fov), (float)this.mc.gameWindow.getWidthPixels() / (float)this.mc.gameWindow.getHeightPixels(), 0.05f, this.farPlaneDistance * 2.0f);
        Matrix4f viewMat = GLRenderer.viewM4f();
        viewMat.identity();
        GLRenderer.modelM4f().identity();
        GLRenderer.pushFrame();
        this.hurtCameraEffect(viewMat, partialTick);
        if (((Boolean)GameSettings.VIEW_BOBBING.value).booleanValue()) {
            this.setupViewBobbing(viewMat, partialTick, true);
        }
        if ((Integer)GameSettings.THIRD_PERSON_VIEW.value == 0 && !(this.mc.currentScreen instanceof ScreenPhotoMode) && this.mc.activeCamera instanceof EntityCamera && !((EntityCamera)this.mc.activeCamera).mob.isPlayerSleeping() && GameSettings.IMMERSIVE_MODE.drawHand()) {
            this.lightmapHelper.enableLightmapRendering();
            if (!this.zooming) {
                this.itemRenderer.renderItemInFirstPerson(partialTick);
            }
            this.lightmapHelper.disableLightmapRendering();
        }
        GLRenderer.popFrame();
        Debug.change("post");
        this.mc.renderer.endRenderWorld(partialTick);
        if ((Integer)GameSettings.THIRD_PERSON_VIEW.value == 0 && this.mc.activeCamera instanceof EntityCamera && !((EntityCamera)this.mc.activeCamera).mob.isPlayerSleeping()) {
            this.itemRenderer.renderOverlays(partialTick);
            this.hurtCameraEffect(viewMat, partialTick);
        }
        if (((Boolean)GameSettings.VIEW_BOBBING.value).booleanValue()) {
            this.setupViewBobbing(viewMat, partialTick, false);
        }
    }

    private float getZoomedFOV(float currentFov, float partialTick) {
        currentFov *= 0.45f;
        float prevZoomProgress = this.zoomProgress;
        this.zoomProgress -= (float)Mouse.getDWheel() / 4.0f;
        this.zoomProgress = MathHelper.clamp(this.zoomProgress, -7.5f, 7.5f);
        float maxFOV = 160.0f;
        float minFOV = 5.0f;
        float _zoom = prevZoomProgress + (this.zoomProgress - prevZoomProgress) * partialTick;
        if (this.zoomProgress > 0.0f) {
            return currentFov + 2.0f * (160.0f - currentFov) * (this.logisticFunc(_zoom) - 0.5f);
        }
        return 5.0f + 2.0f * (currentFov - 5.0f) * this.logisticFunc(_zoom);
    }

    private float logisticFunc(float val) {
        float L = 1.0f;
        float k = 1.1f;
        float xo = 0.0f;
        return (float)(1.0 / (1.0 + Math.pow(Math.E, -1.1f * (val - 0.0f))));
    }

    public void updateCameraAndRender(float partialTick) {
        this.lightmapHelper.update(partialTick);
        if (this.mc.inGameHasFocus) {
            if (Mouse.isGrabbed()) {
                float sensitivity = ((Float)GameSettings.MOUSE_SENSITIVITY.value).floatValue() * 0.6f + 0.2f;
                sensitivity = sensitivity * sensitivity * sensitivity * 8.0f;
                if (this.zooming) {
                    sensitivity *= 0.25f;
                }
                float deltaX = (float)this.mc.mouseInput.deltaX * sensitivity;
                float deltaY = (float)this.mc.mouseInput.deltaY * sensitivity;
                int l = 1;
                if (((Boolean)GameSettings.INVERT_MOUSE.value).booleanValue()) {
                    l = -1;
                }
                if (((Boolean)GameSettings.SMOOTH_CAMERA.value).booleanValue()) {
                    deltaX = this.mouseFilterXAxis.getSmoothedDelta(deltaX, 0.05f * sensitivity);
                    deltaY = this.mouseFilterYAxis.getSmoothedDelta(deltaY, 0.05f * sensitivity);
                } else {
                    this.mouseFilterXAxis.reset();
                    this.mouseFilterYAxis.reset();
                }
                this.mc.thePlayer.interpolateTurn(deltaX, deltaY * (float)l);
            }
            if (this.mc.controllerInput != null) {
                double speed = Time.delta * 2000.0 * (double)(((Float)GameSettings.CONTROLLER_SENSITIVITY.value).floatValue() + 0.5f);
                if (this.zooming) {
                    speed *= 0.25;
                }
                double x = (double)this.mc.controllerInput.joyRight.getX() * speed;
                double y = (double)(-this.mc.controllerInput.joyRight.getY()) * speed;
                this.mc.thePlayer.interpolateTurn((float)x, (float)y);
            }
            if (!((Boolean)GameSettings.SHOW_FRAME_TIMES.value).booleanValue()) {
                PlayerInput playerInput = this.mc.thePlayer.input;
                float x = 0.0f;
                float y = 0.0f;
                playerInput.pressedLookUp = GameSettings.KEY_LOOK_UP.isPressed();
                playerInput.pressedLookDown = GameSettings.KEY_LOOK_DOWN.isPressed();
                playerInput.pressedLookLeft = GameSettings.KEY_LOOK_LEFT.isPressed();
                playerInput.pressedLookRight = GameSettings.KEY_LOOK_RIGHT.isPressed();
                if (playerInput.pressedLookUp) {
                    y += 1.0f;
                }
                if (playerInput.pressedLookDown) {
                    y -= 1.0f;
                }
                if (playerInput.pressedLookLeft) {
                    x -= 1.0f;
                }
                if (playerInput.pressedLookRight) {
                    x += 1.0f;
                }
                float sensitivity = (float)(Time.delta * 1000.0 * (double)(((Float)GameSettings.MOUSE_SENSITIVITY.value).floatValue() + 0.5f));
                if (this.mc.thePlayer.isSneaking()) {
                    sensitivity *= 0.5f;
                }
                if (this.zooming) {
                    sensitivity *= 0.25f;
                }
                this.mc.thePlayer.interpolateTurn(x *= sensitivity, y *= sensitivity);
            }
        }
        if (this.mc.skipRenderWorld) {
            return;
        }
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        int mouseX = Mouse.getX() * width / this.mc.resolution.getWidthScreenCoords();
        int mouseY = height - Mouse.getY() * height / this.mc.resolution.getHeightScreenCoords() - 1;
        int c = 200;
        c = (Boolean)GameSettings.ENABLE_VSYNC.value != false ? 999 : (Integer)GameSettings.CUSTOM_FPS_LIMIT.value;
        if (c <= 0) {
            c = 1;
        }
        GL41.glViewport(0, 0, this.mc.gameWindow.getWidthPixels(), this.mc.gameWindow.getHeightPixels());
        if (this.mc.currentWorld != null) {
            Debug.change("world");
            if (!((Boolean)GameSettings.ENABLE_VSYNC.value).booleanValue() && (Integer)GameSettings.CUSTOM_FPS_LIMIT.value == 0) {
                this.renderWorld(partialTick, 0L);
            } else {
                this.renderWorld(partialTick, this.systemTime + 1000000000L / (long)c);
            }
            Debug.change("misc");
            if (((Boolean)GameSettings.ENABLE_VSYNC.value).booleanValue() || (Integer)GameSettings.CUSTOM_FPS_LIMIT.value > 0) {
                Debug.change("sleep");
                long timeToSleep = this.systemTime + 1000000000L / (long)c - System.nanoTime();
                long millis = timeToSleep / 1000000L;
                int nanos = (int)(timeToSleep - millis * 1000000L);
                if (millis > 0L && millis < 500L) {
                    try {
                        Thread.sleep(millis, nanos);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("", e);
                    }
                }
                Debug.change("misc");
            }
            this.systemTime = System.nanoTime();
            Debug.change("hud");
            this.mc.hudIngame.renderGameOverlay(partialTick, this.mc.currentScreen != null, mouseX, mouseY);
            Debug.change("misc");
        } else {
            GLRenderer.projectionM4f().identity();
            GLRenderer.viewM4f().identity();
            GLRenderer.modelM4f().identity();
            this.setupScaledResolution();
            if (((Boolean)GameSettings.ENABLE_VSYNC.value).booleanValue() || (Integer)GameSettings.CUSTOM_FPS_LIMIT.value > 0) {
                Debug.change("sleep");
                long l2 = (this.systemTime + 1000000000L / (long)c - System.nanoTime()) / 1000000L;
                if (l2 < 0L) {
                    l2 += 10L;
                }
                if (l2 > 0L && l2 < 500L) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("", e);
                    }
                }
                Debug.change("misc");
            }
            this.systemTime = System.nanoTime();
        }
        this.mc.guiToasts.render(partialTick);
        if (this.mc.currentScreen != null) {
            GLRenderer.pushFrame();
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
            GLRenderer.enableState(State.DEPTH_TEST);
            GLRenderer.setDepthFunc(CompareFunc.LESS_EQUAL);
            Debug.change("gui");
            GL41.glClear(256);
            if (this.mc.inputType == InputType.CONTROLLER) {
                mouseX = (int)this.mc.controllerInput.cursorX;
                mouseY = (int)this.mc.controllerInput.cursorY;
            }
            this.mc.currentScreen.setDesiredCursor(CursorShape.ARROW);
            this.mc.currentScreen.render(mouseX, mouseY, partialTick);
            if (this.mc.currentScreen != null) {
                CursorShape newCursor = this.mc.currentScreen.getDesiredCursor();
                if (!((Boolean)GameSettings.DYNAMIC_CURSOR.value).booleanValue()) {
                    newCursor = CursorShape.ARROW;
                }
                if (this.mc.gameWindow.getCursorShape() != newCursor) {
                    this.mc.gameWindow.setCursorShape(newCursor);
                }
            }
            if (this.mc.inputType == InputType.CONTROLLER && this.mc.currentScreen != null) {
                this.mc.currentScreen.drawControllerCursor();
            }
            Debug.change("misc");
            GLRenderer.popFrame();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void renderWorld(float partialTicks, long updateRenderersUntil) {
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.WORLD);
        Debug.push("misc");
        Colorizers.update(false);
        renderGlobal = this.mc.renderGlobal;
        particleEngine = this.mc.particleEngine;
        GLRenderer.enableState(State.CULL_FACE);
        GLRenderer.enableState(State.DEPTH_TEST);
        if (this.mc.activeCamera == null) {
            this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, this.mc.thePlayer);
        }
        this.getMouseOver(partialTicks);
        var7_5 = this.mc.activeCamera;
        if (var7_5 instanceof EntityCamera) {
            camera = (EntityCamera)var7_5;
            activeEntity = camera.mob;
            viewEntityX = activeEntity.xo + (activeEntity.x - activeEntity.xo) * (double)partialTicks;
            viewEntityZ = activeEntity.zo + (activeEntity.z - activeEntity.zo) * (double)partialTicks;
            chunkProvider = this.mc.currentWorld.getChunkProvider();
            chunkX = MathHelper.floor_float((int)viewEntityX) >> 4;
            chunkZ = MathHelper.floor_float((int)viewEntityZ) >> 4;
            chunkProvider.setCurrentChunkOver(chunkX, chunkZ);
        }
        this.fogManager.updateFogColor(partialTicks);
        Debug.change("post");
        this.mc.renderer.beginRenderWorld(partialTicks);
        GL41.glClear(16640);
        GLRenderer.enableState(State.CULL_FACE);
        viewEntityX = this.mc.activeCamera;
        if (!(viewEntityX instanceof EntityCamera)) ** GOTO lbl-1000
        entityCamera = (EntityCamera)viewEntityX;
        if (entityCamera.mob.isRemoved()) {
            v0 = 1.0f;
        } else lbl-1000:
        // 2 sources

        {
            v0 = partialTicks;
        }
        pt = v0;
        this.getProjectionMatrix(GLRenderer.projectionM4f(), pt);
        this.getViewMatrix(GLRenderer.viewM4f(), pt);
        CameraFrustum.recalcFrustrum();
        Debug.change("sky");
        if ((Integer)GameSettings.RENDER_DISTANCE.value > 4 && !(this.mc.currentScreen instanceof ScreenModelViewer)) {
            renderGlobal.renderSky(partialTicks);
        }
        Debug.change("misc");
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTicks, GLRenderer.getFogState());
        this.mc.renderGlobal.cull(this.mc.activeCamera.getFrustum(), partialTicks);
        Debug.change("aurora");
        if (((Boolean)GameSettings.AURORA.value).booleanValue() && ((WorldTypeFX)WorldTypeFXDispatcher.getInstance().getDispatch(this.mc.currentWorld.getWorldType())).hasAurora()) {
            renderGlobal.renderAurora(this.mc.activeCamera, partialTicks);
        }
        Debug.change("update");
        loops = 1;
        if (GameSettings.KEY_LOAD_CHUNKS_QUICKLY.isPressed()) {
            loops = 40;
        }
        for (i = 0; i < loops; ++i) {
            while (!this.mc.renderGlobal.updateDirtyChunks(this.mc.activeCamera) && updateRenderersUntil != 0L && (timeRemaining = updateRenderersUntil - System.nanoTime()) >= 0L && timeRemaining <= 1000000000L) {
            }
        }
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTicks, GLRenderer.getFogState());
        TextureRegistry.worldAtlas.bind();
        Debug.change("terrain");
        GLRenderer.pushFrame();
        GLRenderer.setDepthFunc(CompareFunc.LESS_EQUAL);
        GL41.glActiveTexture(33986);
        TextureRegistry.worldAtlas.layerTextureMap.get("emissive").bind();
        GL41.glActiveTexture(33987);
        TextureRegistry.worldAtlas.layerTextureMap.get("maskColor").bind();
        GL41.glActiveTexture(33984);
        Lighting.enableLight();
        GLRenderer.setShader(Shaders.TERRAIN);
        GLRenderer.globalSetUniforms(Shaders.TERRAIN);
        this.lightmapHelper.enableLightmapRendering();
        this.mc.terrainRenderer.renderSolidTerrain(partialTicks);
        GLRenderer.popFrame();
        Debug.change("entities");
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        renderGlobal.renderEntities(this.mc.activeCamera, partialTicks);
        Debug.change("particles");
        GLRenderer.disableState(State.BLEND);
        particleEngine.renderLitParticles(this.mc.activeCamera, partialTicks);
        Lighting.disable();
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTicks, GLRenderer.getFogState());
        this.mc.renderer.beginRenderParticles(partialTicks);
        particleEngine.renderParticles(this.mc.activeCamera, partialTicks);
        this.mc.renderer.endRenderParticles(partialTicks);
        this.lightmapHelper.disableLightmapRendering();
        Debug.change("outline");
        if (this.mc.objectMouseOver != null) {
            var9_19 = this.mc.objectMouseOver;
            if (var9_19 instanceof HitResult.Tile) {
                hitTile = (HitResult.Tile)var9_19;
                renderGlobal.drawBlockBreaking(this.mc.activeCamera, hitTile, partialTicks);
            }
            renderGlobal.drawSelectionBox(this.mc.activeCamera, this.mc.objectMouseOver, partialTicks);
        }
        Debug.change("debugoverlays");
        if (((Boolean)GameSettings.SHOW_COLLISION_BOXES.value).booleanValue()) {
            renderGlobal.drawDebugEntityOutlines(this.mc.activeCamera, partialTicks);
        }
        if (((Boolean)GameSettings.SHOW_CHUNK_BORDERS.value).booleanValue()) {
            renderGlobal.drawDebugChunkBorders(this.mc.activeCamera, partialTicks);
        }
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTicks, GLRenderer.getFogState());
        GLRenderer.enableState(State.BLEND);
        GLRenderer.enableState(State.CULL_FACE);
        TextureRegistry.worldAtlas.bind();
        Lighting.enableLight();
        Debug.change("water");
        this.lightmapHelper.enableLightmapRendering();
        GLRenderer.pushFrame();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.disableState(State.CULL_FACE);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.setShader(Shaders.WORLD);
        GLRenderer.globalSetUniforms(Shaders.WORLD);
        this.mc.terrainRenderer.renderTranslucentTerrain(partialTicks);
        GLRenderer.popFrame();
        this.lightmapHelper.disableLightmapRendering();
        Lighting.disable();
        Debug.change("weather");
        GLRenderer.setDepthMask(true);
        GLRenderer.enableState(State.CULL_FACE);
        GLRenderer.disableState(State.BLEND);
        this.renderRainSnow(partialTicks);
        if (((Boolean)GameSettings.CLOUDS.value).booleanValue()) {
            Debug.change("clouds");
            this.fogManager.setupFog(-1, this.farPlaneDistance, partialTicks, GLRenderer.getFogState());
            renderGlobal.renderClouds(partialTicks);
        }
        Debug.change("misc");
        this.fogManager.setupFog(1, this.farPlaneDistance, partialTicks, GLRenderer.getFogState());
        var9_20 = this.mc.activeCamera;
        if (!(var9_20 instanceof EntityCamera)) ** GOTO lbl-1000
        camera = (EntityCamera)var9_20;
        if (camera.mob.isRemoved()) {
            v1 = 1.0f;
        } else lbl-1000:
        // 2 sources

        {
            v1 = partialTicks;
        }
        this.renderHand(v1);
        Debug.pop();
        GLRenderer.popFrame();
    }

    private void addRainParticles() {
        IPrecipitation precipitation;
        if (GameSettings.PARTICLES_QUALITY.value == ParticlesQuality.NONE) {
            return;
        }
        Weather weather = this.mc.currentWorld.getCurrentWeather();
        if (!(weather instanceof IPrecipitation) || !(precipitation = (IPrecipitation)((Object)weather)).spawnRainParticles()) {
            return;
        }
        float f = this.mc.currentWorld.weatherManager.getWeatherIntensity() * this.mc.currentWorld.weatherManager.getWeatherPower();
        if (GameSettings.PARTICLES_QUALITY.value == ParticlesQuality.REDUCED) {
            f /= 2.0f;
        }
        if (f == 0.0f) {
            return;
        }
        this.random.setSeed((long)this.rendererUpdateCount * 312987231L);
        WorldClient world = this.mc.currentWorld;
        int cameraX = MathHelper.floor(this.mc.activeCamera.getX());
        int cameraY = MathHelper.floor(this.mc.activeCamera.getY());
        int cameraZ = MathHelper.floor(this.mc.activeCamera.getZ());
        int byte0 = 10;
        double d = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        int l = 0;
        block0: for (int i1 = 0; i1 < (int)(100.0f * f * f); ++i1) {
            int randX = cameraX + this.random.nextInt(byte0) - this.random.nextInt(byte0);
            int randZ = cameraZ + this.random.nextInt(byte0) - this.random.nextInt(byte0);
            int y = world.findTopSolidBlock(randX, randZ);
            int i2 = world.getBlockId(randX, y - 1, randZ);
            Biome biome = world.getBlockBiome(randX, y, randZ);
            for (int q = 0; q < biome.blockedWeathers.length; ++q) {
                if (biome.blockedWeathers[q] == weather) continue block0;
            }
            if (y > cameraY + byte0 || y < cameraY - byte0) continue;
            float f1 = this.random.nextFloat();
            float f2 = this.random.nextFloat();
            if (i2 <= 0) continue;
            if (Blocks.blocksList[i2].getMaterial() == Materials.LAVA) {
                this.mc.particleEngine.add(new ParticleSmoke(world, (float)randX + f1, (double)((float)y + 0.1f) - Blocks.blocksList[i2].getBounds().minY(), (float)randZ + f2, 0.0, 0.0, 0.0, 1.0f, 0));
                continue;
            }
            if (this.random.nextInt(++l) == 0) {
                d = (float)randX + f1;
                d1 = (double)((float)y + 0.1f) - Blocks.blocksList[i2].getBounds().minY();
                d2 = (float)randZ + f2;
            }
            this.mc.particleEngine.add(new ParticleWaterDrop(world, (float)randX + f1, (double)((float)y + 0.1f) - Blocks.blocksList[i2].getBounds().minY(), (float)randZ + f2));
        }
        if (l > 0 && this.random.nextInt(3) < this.rainSoundCounter++) {
            this.rainSoundCounter = 0;
            if (d1 > this.mc.activeCamera.getY() + 1.0 && world.getHeightValue(MathHelper.floor(this.mc.activeCamera.getX()), MathHelper.floor(this.mc.activeCamera.getZ())) > MathHelper.floor(this.mc.activeCamera.getY())) {
                this.mc.currentWorld.playSoundEffect(null, SoundCategory.WEATHER_SOUNDS, d, d1, d2, "ambient.weather.rain", 0.1f * this.mc.currentWorld.weatherManager.getWeatherIntensity() * this.mc.currentWorld.weatherManager.getWeatherPower() * 0.5f, 0.5f);
            } else {
                this.mc.currentWorld.playSoundEffect(null, SoundCategory.WEATHER_SOUNDS, d, d1, d2, "ambient.weather.rain", 0.2f * this.mc.currentWorld.weatherManager.getWeatherIntensity() * this.mc.currentWorld.weatherManager.getWeatherPower() * 0.5f, 1.0f);
            }
        }
    }

    protected void renderRainSnow(float partialTick) {
        Weather weather = this.mc.currentWorld.getCurrentWeather();
        if (!(weather instanceof IPrecipitation)) {
            return;
        }
        @NotNull IPrecipitation precipitation = (IPrecipitation)((Object)weather);
        WorldClient world = this.mc.currentWorld;
        int posX = MathHelper.floor(this.mc.activeCamera.getX());
        int posY = MathHelper.floor(this.mc.activeCamera.getY());
        int posZ = MathHelper.floor(this.mc.activeCamera.getZ());
        TessellatorShader tessellator = GLRenderer.getTessellator();
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.WORLD);
        GLRenderer.setLightmapCoord2i(15, 15);
        GLRenderer.disableState(State.CULL_FACE);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        this.mc.textureManager.loadTexture(precipitation.getPrecipitationTexturePath(world.weatherManager.getWeatherPower(), world.weatherManager.getWeatherIntensity())).bind();
        double nextPosX = this.mc.activeCamera.getX(partialTick);
        double nextPosY = this.mc.activeCamera.getY(partialTick);
        double nextPosZ = this.mc.activeCamera.getZ(partialTick);
        int floorPosY = MathHelper.floor(nextPosY);
        int radiusEffect = 10;
        TilePos queryPos = new TilePos();
        if (precipitation.getPrecipitationType() == IPrecipitation.Type.SNOW_LIKE) {
            tessellator.startDrawingQuads();
            for (int x = posX - radiusEffect; x <= posX + radiusEffect; ++x) {
                block1: for (int z = posZ - radiusEffect; z <= posZ + radiusEffect; ++z) {
                    int i3;
                    int y = world.findTopSolidBlock(x, z);
                    Biome biomegenbase = world.getBlockBiome(x, y, z);
                    for (int q = 0; q < biomegenbase.blockedWeathers.length; ++q) {
                        if (biomegenbase.blockedWeathers[q] == weather) continue block1;
                    }
                    if (y < 0) {
                        y = 0;
                    }
                    if ((i3 = y) < floorPosY) {
                        i3 = floorPosY;
                    }
                    int k3 = posY - radiusEffect;
                    int i4 = posY + radiusEffect;
                    if (k3 < y) {
                        k3 = y;
                    }
                    if (i4 < y) {
                        i4 = y;
                    }
                    float f3 = 1.0f;
                    if (k3 == i4) continue;
                    this.random.setSeed((long)x * (long)x * 3121L + (long)x * 45238971L + (long)z * (long)z * 418711L + (long)z * 13761L);
                    float f5 = (float)this.rendererUpdateCount + partialTick;
                    float f6 = ((float)(this.rendererUpdateCount & 0x1FF) + partialTick) / 512.0f;
                    float f7 = this.random.nextFloat() + f5 * 0.01f * (float)this.random.nextGaussian();
                    float f8 = this.random.nextFloat() + f5 * (float)this.random.nextGaussian() * 0.001f;
                    double d5 = (double)((float)x + 0.5f) - this.mc.activeCamera.getX();
                    double d6 = (double)((float)z + 0.5f) - this.mc.activeCamera.getZ();
                    float f11 = MathHelper.sqrt(d5 * d5 + d6 * d6) / (float)radiusEffect;
                    float brightness = this.mc.fullbright ? 1.0f : world.getLightBrightness(queryPos.set(x, i3, z));
                    tessellator.setColor4f(brightness, brightness, brightness, ((1.0f - f11 * f11) * 0.3f + 0.5f) * world.weatherManager.getWeatherIntensity() * world.weatherManager.getWeatherPower());
                    tessellator.setTranslation(-nextPosX, -nextPosY, -nextPosZ);
                    tessellator.addVertexWithUV(x, k3, (double)z + 0.5, 0.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(x + 1, k3, (double)z + 0.5, f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(x + 1, i4, (double)z + 0.5, f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(x, i4, (double)z + 0.5, 0.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, k3, z, 0.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, k3, z + 1, f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, i4, z + 1, f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, i4, z, 0.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                }
            }
            tessellator.draw();
        } else if (precipitation.getPrecipitationType() == IPrecipitation.Type.RAIN_LIKE) {
            tessellator.startDrawingQuads();
            for (int x = posX - radiusEffect; x <= posX + radiusEffect; ++x) {
                block4: for (int z = posZ - radiusEffect; z <= posZ + radiusEffect; ++z) {
                    int y = world.findTopSolidBlock(x, z);
                    Biome biome = world.getBlockBiome(x, y, z);
                    for (int q = 0; q < biome.blockedWeathers.length; ++q) {
                        if (biome.blockedWeathers[q] == weather) continue block4;
                    }
                    int j3 = posY - radiusEffect;
                    int l3 = posY + radiusEffect;
                    if (j3 < y) {
                        j3 = y;
                    }
                    if (l3 < y) {
                        l3 = y;
                    }
                    float f2 = 1.0f;
                    if (j3 == l3) continue;
                    this.random.setSeed((long)x * (long)x * 3121L + (long)x * 45238971L + (long)z * (long)z * 418711L + (long)z * 13761L);
                    float f4 = ((float)(this.rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + partialTick) / 32.0f * (3.0f + this.random.nextFloat());
                    double d3 = (double)((float)x + 0.5f) - this.mc.activeCamera.getX();
                    double d4 = (double)((float)z + 0.5f) - this.mc.activeCamera.getZ();
                    float f9 = MathHelper.sqrt(d3 * d3 + d4 * d4) / (float)radiusEffect;
                    float brightness = this.mc.fullbright ? 1.0f : world.getLightBrightness(queryPos.set(x, world.getHeightBlocks(), z)) * 0.85f + 0.15f;
                    tessellator.setTranslation(-nextPosX, -nextPosY, -nextPosZ);
                    tessellator.setColor4f(brightness, brightness, brightness, ((1.0f - f9 * f9) * 0.5f + 0.5f) * (world.weatherManager.getWeatherIntensity() - 0.1f) * world.weatherManager.getWeatherPower());
                    tessellator.addVertexWithUV(x, j3, (double)z + 0.5, 0.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(x + 1, j3, (double)z + 0.5, f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(x + 1, l3, (double)z + 0.5, f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(x, l3, (double)z + 0.5, 0.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z, 0.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 1, f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 1, f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z, 0.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                }
            }
            tessellator.draw();
        } else if (precipitation.getPrecipitationType() == IPrecipitation.Type.INVERTED_RAIN_LIKE) {
            tessellator.startDrawingQuads();
            for (int x = posX - radiusEffect; x <= posX + radiusEffect; ++x) {
                block7: for (int z = posZ - radiusEffect; z <= posZ + radiusEffect; ++z) {
                    int topSolidY = world.findTopSolidBlock(x, z);
                    Biome biome = world.getBlockBiome(x, topSolidY, z);
                    for (int i = 0; i < biome.blockedWeathers.length; ++i) {
                        if (biome.blockedWeathers[i] == weather) continue block7;
                    }
                    int j3 = posY - radiusEffect;
                    int l3 = posY + radiusEffect;
                    if (j3 < topSolidY) {
                        j3 = topSolidY;
                    }
                    if (l3 < topSolidY) {
                        l3 = topSolidY;
                    }
                    float f2 = 1.0f;
                    if (j3 == l3) continue;
                    this.random.setSeed((long)x * (long)x * 3121L + (long)x * 45238971L + (long)z * (long)z * 418711L + (long)z * 13761L);
                    float vOffset = ((float)(this.rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + partialTick) / 32.0f * (3.0f + this.random.nextFloat());
                    double d3 = (double)((float)x + 0.5f) - this.mc.activeCamera.getX();
                    double d4 = (double)((float)z + 0.5f) - this.mc.activeCamera.getZ();
                    float f9 = MathHelper.sqrt(d3 * d3 + d4 * d4) / (float)radiusEffect;
                    float brightness = this.mc.fullbright ? 1.0f : world.getLightBrightness(queryPos.set(x, world.getHeightBlocks(), z)) * 0.85f + 0.15f;
                    tessellator.setColor4f(brightness, brightness, brightness, ((1.0f - f9 * f9) * 0.5f + 0.5f) * (world.weatherManager.getWeatherIntensity() - 0.1f) * world.weatherManager.getWeatherPower());
                    tessellator.setTranslation(-nextPosX, -nextPosY, -nextPosZ);
                    tessellator.addVertexWithUV(x, j3, (double)z + 0.5, 0.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV(x + 1, j3, (double)z + 0.5, f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV(x + 1, l3, (double)z + 0.5, f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV(x, l3, (double)z + 0.5, 0.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z, 0.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 1, f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 1, f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z, 0.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                }
            }
            tessellator.draw();
        }
        GLRenderer.popFrame();
    }

    public void setupScaledResolution() {
        GL41.glClear(256);
        this.mc.getGuiProjectionMatrix(GLRenderer.projectionM4f());
        this.mc.getGuiViewMatrix(GLRenderer.viewM4f());
    }
}

