/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFence;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;
import org.useless.dragonfly.DisplayPos;

public class BlockModelFence<T extends BlockLogicFence>
extends BlockModelStandard<T> {
    protected static final DisplayPos FENCE_GUI = new DisplayPos(0.0f, 0.0f, 0.0f, 30.0f, 135.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    protected static final DisplayPos FENCE_HEAD = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, 90.0f, 0.0f, 1.0f, 1.0f, 1.0f);

    public BlockModelFence(Block<T> block) {
        super(block);
        this.setDisplayPos("gui", FENCE_GUI);
        this.setDisplayPos("head", FENCE_HEAD);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        float f7;
        float f = 0.375f;
        float f1 = 0.625f;
        AABBd bounds = new AABBd(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        boolean connectedWestEast = false;
        boolean connectedNorthSouth = false;
        BlockLogicFence fence = (BlockLogicFence)this.block.getLogic();
        if (fence.canConnectTo(worldSource, tilePos, Side.WEST) || fence.canConnectTo(worldSource, tilePos, Side.EAST)) {
            connectedWestEast = true;
        }
        if (fence.canConnectTo(worldSource, tilePos, Side.NORTH) || fence.canConnectTo(worldSource, tilePos, Side.SOUTH)) {
            connectedNorthSouth = true;
        }
        boolean flag3 = fence.canConnectTo(worldSource, tilePos, Side.WEST);
        boolean flag4 = fence.canConnectTo(worldSource, tilePos, Side.EAST);
        boolean flag5 = fence.canConnectTo(worldSource, tilePos, Side.NORTH);
        boolean flag6 = fence.canConnectTo(worldSource, tilePos, Side.SOUTH);
        if (!connectedWestEast && !connectedNorthSouth) {
            connectedWestEast = true;
        }
        float f8 = 0.4375f;
        float f9 = 0.5625f;
        float f2 = 0.75f;
        float f3 = 0.9375f;
        float f4 = flag3 ? 0.0f : 0.4375f;
        float f5 = flag4 ? 1.0f : 0.5625f;
        float f6 = flag5 ? 0.0f : 0.4375f;
        float f10 = f7 = flag6 ? 1.0f : 0.5625f;
        if (connectedWestEast) {
            bounds.setMin(f4, 0.75, 0.4375).setMax(f5, 0.9375, 0.5625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        if (connectedNorthSouth) {
            bounds.setMin(0.4375, 0.75, f6).setMax(0.5625, 0.9375, f7);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        float f102 = 0.375f;
        float f11 = 0.5625f;
        if (connectedWestEast) {
            bounds.setMin(f4, 0.375, 0.4375).setMax(f5, 0.5625, 0.5625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        if (connectedNorthSouth) {
            bounds.setMin(0.4375, 0.375, f6).setMax(0.5625, 0.5625, f7);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        return true;
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, byte lightIndex) {
        tessellator.offsetTranslation(-0.5, -0.5, -0.5);
        tessellator.startDrawingQuads();
        tessellator.setColor1i(this.getStandaloneTintColor(metadata));
        for (int cube = 0; cube < 4; ++cube) {
            float radius = 0.125f;
            float f5 = 0.0625f;
            AABBd bounds = switch (cube) {
                case 0 -> new AABBd(0.375, 0.0, 0.0, 0.625, 1.0, 0.25);
                case 1 -> new AABBd(0.375, 0.0, 0.75, 0.625, 1.0, 1.0);
                case 2 -> new AABBd(0.4375, 0.8125, -0.125, 0.5625, 0.9375, 1.125);
                default -> new AABBd(0.4375, 0.3125, -0.125, 0.5625, 0.4375, 1.125);
            };
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
        }
        tessellator.draw();
        tessellator.offsetTranslation(0.5, 0.5, 0.5);
    }
}

