/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.TessellatorParticle;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class ParticleLeaf
extends Particle {
    public ParticleLeaf(World world, double x, double y, double z, double xa, double ya, double za) {
        super(world, x, y, z, xa, ya, za);
        this.tex = TextureRegistry.getTexture("minecraft:block/leaves/oak_fancy");
        this.gravity = 0.125f;
        this.size /= 2.0f;
        this.lifetime *= 16;
        this.yd = 0.0;
        this.xd = 0.0;
        this.zd = 0.0;
    }

    @Override
    public boolean collidesWithBlock(@NotNull Block<?> block, int data) {
        return !Block.hasLogicClass(block, BlockLogicLeavesBase.class);
    }

    public ParticleLeaf init(@NotNull TilePos tilePos) {
        Block<?> block = this.world.getBlockType(tilePos);
        if (!Block.hasLogicClass(block, BlockLogicLeavesBase.class)) {
            this.remove();
        }
        int col = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(block)).getWorldColor(this.world, tilePos.x, tilePos.y, tilePos.z, 0);
        this.rCol *= (float)(col >> 16 & 0xFF) / 255.0f;
        this.gCol *= (float)(col >> 8 & 0xFF) / 255.0f;
        this.bCol *= (float)(col & 0xFF) / 255.0f;
        return this;
    }

    @Override
    public void tick() {
        this.cachedLightmapCoord = this.calcLightIndex(1.0f);
        float windDirection = this.world.getWorldType().getWindManager().getWindDirection(this.world, (float)this.x, (float)this.y, (float)this.z);
        float windIntensity = this.world.getWorldType().getWindManager().getWindIntensity(this.world, (float)this.x, (float)this.y, (float)this.z) * 0.01f;
        float dx = (float)(Math.cos((double)windDirection * Math.PI * 2.0) * (double)windIntensity);
        float dz = (float)(Math.sin((double)windDirection * Math.PI * 2.0) * (double)windIntensity);
        this.xd += (double)dx;
        this.zd += (double)dz;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.yd -= 0.04 * (double)this.gravity;
        if (this.onGround) {
            this.xd *= 0.0;
            this.zd *= 0.0;
        }
        this.move(this.xd, this.yd, this.zd);
    }

    @Override
    public void render(@NotNull TessellatorParticle t, float partialTick) {
        if (this.tex == null) {
            return;
        }
        t.setLightmapCoord1i(this.getLightIndex(partialTick));
        t.setColorOpaque3f(this.rCol, this.gCol, this.bCol);
        t.addParticle(MathHelper.lerp(this.xo, this.x, (double)partialTick), MathHelper.lerp(this.yo, this.y, (double)partialTick), MathHelper.lerp(this.zo, this.z, (double)partialTick), this.size * 0.1f, this.tex.getIconUMin() + this.tex.getIconUSize() * (double)this.uo / 4.0, this.tex.getIconVMin() + this.tex.getIconVSize() * (double)this.uo / 4.0, this.tex.getIconUSize() * 0.25, this.tex.getIconVSize() * 0.25);
    }
}

