/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.worldtype;

import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WorldTypeFXDrift
extends WorldTypeFX {
    public WorldTypeFXDrift(WorldType worldType) {
        super(worldType);
    }

    @Override
    public float @Nullable [] getSunriseColor(float timeOfDay, float partialTick) {
        float f4;
        float[] sunriseCol = new float[4];
        float f2 = 0.4f;
        float f3 = MathHelper.cos(timeOfDay * (float)Math.PI * 2.0f) - 0.0f;
        if (f3 >= (f4 = -0.0f) - f2 && f3 <= f4 + f2) {
            float c = (f3 - f4) / f2 * 0.5f + 0.5f;
            float a = 1.0f - (1.0f - MathHelper.sin(c * (float)Math.PI)) * 0.99f;
            a *= a;
            sunriseCol[0] = c * 0.3f + 0.7f;
            sunriseCol[1] = c * c * 0.7f + 0.2f;
            sunriseCol[2] = c * c * 0.0f + 0.2f;
            sunriseCol[3] = a;
            return sunriseCol;
        }
        return null;
    }

    @Override
    @NotNull
    public Vector3fc getFogColor(@NotNull World world, double x, double y, double z, float celestialAngle, float partialTick) {
        float f2 = MathHelper.cos(celestialAngle * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        f2 = MathHelper.clamp(f2, 0.0f, 1.0f);
        if (Colorizers.fog.isEnabled()) {
            int color = Colorizers.fog.getColor(world, new TilePos(x, y, z));
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        } else {
            int i = 0x8080A0;
            r = (float)(i >> 16 & 0xFF) / 255.0f;
            g = (float)(i >> 8 & 0xFF) / 255.0f;
            b = (float)(i & 0xFF) / 255.0f;
        }
        return new Vector3f(r *= f2 * 0.94f + 0.06f, g *= f2 * 0.94f + 0.06f, b *= f2 * 0.91f + 0.09f);
    }
}

