/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.MutableWorldSource;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.season.SeasonManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlocksContainer
implements MutableWorldSource {
    @NotNull
    public final World world;
    @NotNull
    private final @NotNull Map<@NotNull TilePos, @NotNull BlockEntry> blockEntryMap = new Object2ObjectOpenHashMap<TilePos, BlockEntry>();
    @Nullable
    private Entity lightRefEntity = null;
    public float partialTick = 1.0f;

    public BlocksContainer(@NotNull World world) {
        this.world = world;
    }

    @Override
    public int getHeightBlocks() {
        return this.world.getHeightBlocks();
    }

    public void setLightReferenceEntity(@Nullable Entity entity) {
        this.lightRefEntity = entity;
    }

    @Override
    public boolean setBlockType(@NotNull TilePosc tilePos, @NotNull Block<?> block) {
        this.blockEntryMap.put(new TilePos(tilePos), new BlockEntry(block, 0, null));
        return true;
    }

    @Deprecated
    public void setBlock(int x, int y, int z, int id, int data, @Nullable TileEntity tileEntity) {
        @NotNull TilePos tilePos = new TilePos(x, y, z);
        this.setBlockTypeData(tilePos, Objects.requireNonNull(Blocks.getBlock(id)), data);
        if (tileEntity != null) {
            this.setTileEntity(tilePos, tileEntity);
        }
    }

    @Override
    public boolean setBlockData(@NotNull TilePosc tilePos, int data) {
        @Nullable BlockEntry entry = this.getEntry(tilePos);
        if (entry != null) {
            entry.data = data;
        } else {
            this.blockEntryMap.put(new TilePos(tilePos), new BlockEntry(this.world.getBlockType(tilePos), data, this.world.getTileEntity(tilePos)));
        }
        return true;
    }

    @Override
    public boolean setBlockTypeData(@NotNull TilePosc tilePos, @NotNull Block<?> block, int data) {
        this.blockEntryMap.put(new TilePos(tilePos), new BlockEntry(block, data, null));
        return true;
    }

    @Override
    public void setLightValue(@NotNull LightLayer lightLayer, @NotNull TilePosc tilePos, int value) {
    }

    @Override
    public void setTileEntity(@NotNull TilePosc tilePos, @NotNull TileEntity tileEntity) {
        @Nullable BlockEntry entry = this.getEntry(tilePos);
        if (entry != null) {
            entry.tileEntity = tileEntity;
        } else {
            this.blockEntryMap.put(new TilePos(tilePos), new BlockEntry(this.world.getBlockType(tilePos), this.world.getBlockData(tilePos), tileEntity));
        }
    }

    @Override
    public void removeTileEntity(@NotNull TilePosc tilePos) {
        @Nullable BlockEntry entry = this.getEntry(tilePos);
        if (entry != null) {
            entry.tileEntity = null;
        } else {
            this.blockEntryMap.put(new TilePos(tilePos), new BlockEntry(this.world.getBlockType(tilePos), this.world.getBlockData(tilePos), null));
        }
    }

    @Nullable
    public BlockEntry getEntry(@NotNull TilePosc tilePos) {
        return this.blockEntryMap.get(tilePos);
    }

    @Deprecated
    @Nullable
    public BlockEntry getEntry(int x, int y, int z) {
        return this.getEntry(new TilePos(x, y, z));
    }

    @NotNull
    public @NotNull Collection<@NotNull BlockEntry> getEntries() {
        return this.blockEntryMap.values();
    }

    public void clear() {
        this.blockEntryMap.clear();
    }

    @Override
    @NotNull
    public Block<?> getBlockType(@NotNull TilePosc tilePos) {
        @Nullable BlockEntry entry = this.getEntry(tilePos);
        if (entry != null) {
            return entry.block;
        }
        return Blocks.AIR;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(@NotNull TilePosc tilePos) {
        @Nullable BlockEntry entry = this.getEntry(tilePos);
        if (entry != null) {
            return entry.tileEntity;
        }
        return null;
    }

    @Override
    public float getBrightness(@NotNull TilePosc tilePos, int lightEmission) {
        if (this.lightRefEntity != null) {
            return this.lightRefEntity.getBrightness(this.partialTick);
        }
        return this.world.getBrightness(tilePos, lightEmission);
    }

    @Override
    public byte getLightIndex(@NotNull TilePosc tilePos, int lightEmission) {
        if (this.lightRefEntity != null) {
            return this.lightRefEntity.getLightIndex(this.partialTick);
        }
        return this.world.getLightIndex(tilePos, lightEmission);
    }

    @Override
    public float getLightBrightness(@NotNull TilePosc tilePos) {
        return this.world.getLightBrightness(tilePos);
    }

    @Override
    public int getBlockData(@NotNull TilePosc tilePos) {
        @Nullable BlockEntry entry = this.getEntry(tilePos);
        if (entry != null) {
            return entry.data;
        }
        return 0;
    }

    @Override
    @NotNull
    public Material getBlockMaterial(@NotNull TilePosc tilePos) {
        @NotNull Block<?> block = Objects.requireNonNull(this.getBlockType(tilePos));
        return block.getMaterial();
    }

    @Override
    public boolean isBlockOpaqueCube(@NotNull TilePosc tilePos) {
        return this.getBlockType(tilePos).isSolidRender();
    }

    @Override
    public boolean isBlockNormalCube(@NotNull TilePosc tilePos) {
        @Nullable Block<?> block = this.getBlockType(tilePos);
        return block.getMaterial().isSolidBlocking() && block.renderAsNormalBlockOnCondition(this, tilePos);
    }

    @Override
    public double getBlockTemperature(@NotNull TilePosc tilePos) {
        return this.world.getBlockTemperature(tilePos);
    }

    @Override
    public double getBlockHumidity(@NotNull TilePosc tilePos) {
        return this.world.getBlockHumidity(tilePos);
    }

    @Override
    public double getBlockVariety(@NotNull TilePosc tilePos) {
        return this.world.getBlockVariety(tilePos);
    }

    @Override
    @NotNull
    public SeasonManager getSeasonManager() {
        return this.world.getSeasonManager();
    }

    @Override
    @NotNull
    public Biome getBlockBiome(@NotNull TilePosc tilePos) {
        return this.world.getBlockBiome(tilePos);
    }

    @Override
    public int getSavedLightValue(@NotNull LightLayer lightLayer, @NotNull TilePosc tilePos) {
        return this.world.getSavedLightValue(lightLayer, tilePos);
    }

    @Override
    public byte getSavedLightIndex(@NotNull TilePosc tilePos) {
        return this.world.getSavedLightIndex(tilePos);
    }

    @Override
    public boolean isRetro() {
        return this.world.isRetro();
    }

    public static class BlockEntry {
        @NotNull
        public Block<?> block;
        public int data;
        @Nullable
        public TileEntity tileEntity;

        public BlockEntry(@NotNull Block<?> block, int data, @Nullable TileEntity tileEntity) {
            this.block = block;
            this.data = data;
            this.tileEntity = tileEntity;
        }
    }
}

