/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.SpawnListEntry;
import net.minecraft.core.entity.animal.MobButterfly;
import net.minecraft.core.entity.animal.MobChicken;
import net.minecraft.core.entity.animal.MobCow;
import net.minecraft.core.entity.animal.MobDeer;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.entity.animal.MobPig;
import net.minecraft.core.entity.animal.MobSheep;
import net.minecraft.core.entity.animal.MobSquid;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.monster.MobSlime;
import net.minecraft.core.entity.monster.MobSnowman;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.entity.monster.MobZombieArmored;
import net.minecraft.core.enums.MobCategory;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTree;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeFancy;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.weather.Weather;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Biome {
    public final String translationKey;
    public int color = 0xFF00FF;
    public short topBlock;
    public short fillerBlock;
    public Weather[] blockedWeathers = new Weather[0];
    @NotNull
    protected @NotNull List<@NotNull SpawnListEntry> spawnableMonsterList = new ArrayList<SpawnListEntry>();
    @NotNull
    protected @NotNull List<@NotNull SpawnListEntry> spawnableCreatureList = new ArrayList<SpawnListEntry>();
    @NotNull
    protected @NotNull List<@NotNull SpawnListEntry> spawnableWaterCreatureList = new ArrayList<SpawnListEntry>();
    @NotNull
    protected @NotNull List<@NotNull SpawnListEntry> spawnableAmbientCreatureList = new ArrayList<SpawnListEntry>();
    private boolean hasSurfaceSnow = false;
    private boolean hasSurfaceIce = false;

    public Biome(String key) {
        this.translationKey = "biome." + key;
        this.topBlock = (short)Blocks.GRASS.id();
        this.fillerBlock = (short)Blocks.DIRT.id();
        this.spawnableMonsterList.add(new SpawnListEntry(MobSpider.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(MobZombie.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(MobZombieArmored.class, 2));
        this.spawnableMonsterList.add(new SpawnListEntry(MobSkeleton.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(MobCreeper.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(MobSlime.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(MobSnowman.class, 2));
        this.spawnableCreatureList.add(new SpawnListEntry(MobSheep.class, 102));
        this.spawnableCreatureList.add(new SpawnListEntry(MobPig.class, 102));
        this.spawnableCreatureList.add(new SpawnListEntry(MobChicken.class, 102));
        this.spawnableCreatureList.add(new SpawnListEntry(MobCow.class, 102));
        this.spawnableCreatureList.add(new SpawnListEntry(MobDeer.class, 10));
        this.spawnableWaterCreatureList.add(new SpawnListEntry(MobSquid.class, 10));
        this.spawnableAmbientCreatureList.add(new SpawnListEntry(MobFireflyCluster.class, 10));
        this.spawnableAmbientCreatureList.add(new SpawnListEntry(MobButterfly.class, 65));
    }

    public WorldFeature getRandomWorldGenForTrees(Random random) {
        if (random.nextInt(10) == 0) {
            return new WorldFeatureTreeFancy(Blocks.LEAVES_OAK.id(), Blocks.LOG_OAK.id());
        }
        return new WorldFeatureTree(Blocks.LEAVES_OAK.id(), Blocks.LOG_OAK.id(), 4);
    }

    public Biome setColor(int color) {
        this.color = color;
        return this;
    }

    public int getSkyColor(float temperature) {
        if ((temperature /= 3.0f) < -1.0f) {
            temperature = -1.0f;
        }
        if (temperature > 1.0f) {
            temperature = 1.0f;
        }
        return Color.getHSBColor(0.6222222f - temperature * 0.125f, 0.5f + temperature * 0.1f, 1.0f).getRGB();
    }

    @NotNull
    public @NotNull List<@NotNull SpawnListEntry> getSpawnableList(@NotNull MobCategory creatureType) {
        return switch (creatureType) {
            default -> throw new IncompatibleClassChangeError();
            case MobCategory.MONSTER -> this.spawnableMonsterList;
            case MobCategory.CREATURE -> this.spawnableCreatureList;
            case MobCategory.WATER_CREATURE -> this.spawnableWaterCreatureList;
            case MobCategory.AMBIENT -> this.spawnableAmbientCreatureList;
        };
    }

    public boolean hasSurfaceSnow() {
        return this.hasSurfaceSnow;
    }

    public boolean hasSurfaceIce() {
        return this.hasSurfaceIce;
    }

    public Biome setSurfaceSnow() {
        this.hasSurfaceSnow = true;
        return this;
    }

    public Biome setSurfaceIce() {
        this.hasSurfaceIce = true;
        return this;
    }

    public Biome setBlockedWeathers(Weather ... blocked) {
        this.blockedWeathers = blocked;
        return this;
    }

    public Biome setTopBlock(int id) {
        this.topBlock = (short)id;
        return this;
    }

    public Biome setFillerBlock(int id) {
        this.fillerBlock = (short)id;
        return this;
    }

    @Nullable
    public static TilePosc getBiomeCoords(@NotNull Biome biome, @NotNull World world) {
        int[] xPattern = new int[]{0, 1, 0, -1};
        int[] zPattern = new int[]{1, 0, -1, 0};
        TilePos sourcePos = new TilePos();
        int runLength = 2;
        int chunkX = (int)((double)sourcePos.x() / 16.0);
        int chunkZ = (int)((double)sourcePos.z() / 16.0);
        int passes = 1024;
        if (world.getBiomeProvider().getBiome(sourcePos.x(), sourcePos.y(), sourcePos.z()) == biome) {
            return sourcePos;
        }
        --chunkX;
        --chunkZ;
        for (int pass = 0; pass < passes; ++pass) {
            for (int i = 0; i < 4; ++i) {
                for (int j = runLength - 1; j >= 0; --j) {
                    if (world.getBiomeProvider().getBiome((chunkX += xPattern[i]) * 16, sourcePos.y(), (chunkZ += zPattern[i]) * 16) != biome) continue;
                    return new TilePos(chunkX * 16, sourcePos.y(), chunkZ * 16);
                }
            }
            ++runLength;
        }
        return null;
    }
}

