/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pos;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.pos.ChunkTilePosc;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector3ic;

public class ChunkTilePos
implements Externalizable,
Cloneable,
ChunkTilePosc {
    public int x;
    public int y;
    public int z;

    public ChunkTilePos() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public ChunkTilePos(int x, int y, int z) {
        this.x = Integer.remainderUnsigned(x, 16);
        this.y = y;
        this.z = Integer.remainderUnsigned(z, 16);
    }

    public ChunkTilePos(float x, float y, float z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public ChunkTilePos(double x, double y, double z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public ChunkTilePos(@NotNull TilePosc tilePos) {
        this(tilePos.x(), tilePos.y(), tilePos.z());
    }

    public ChunkTilePos(@NotNull ChunkTilePosc tilePos) {
        this(tilePos.x(), tilePos.y(), tilePos.z());
    }

    public ChunkTilePos(@NotNull Entity entity) {
        this(entity.x, entity.y, entity.z);
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int z() {
        return this.z;
    }

    @NotNull
    public ChunkTilePos set(int x, int y, int z) {
        this.x = Integer.remainderUnsigned(x, 16);
        this.y = y;
        this.z = Integer.remainderUnsigned(z, 16);
        return this;
    }

    @NotNull
    public ChunkTilePos set(@NotNull ChunkTilePosc pos) {
        return this.set(pos.x(), pos.y(), pos.z());
    }

    @NotNull
    public ChunkTilePos set(@NotNull TilePosc pos) {
        return this.set(pos.x(), pos.y(), pos.z());
    }

    @Override
    @NotNull
    public ChunkTilePos add(int x, int y, int z, @NotNull ChunkTilePos dest) {
        return dest.set(this.x + x, this.y + y, this.z + z);
    }

    @Override
    @NotNull
    public ChunkTilePos add(@NotNull Vector3ic v, @NotNull ChunkTilePos dest) {
        return this.add(v.x(), v.y(), v.z(), dest);
    }

    @Override
    @NotNull
    public ChunkTilePos add(@NotNull Direction dir, @NotNull ChunkTilePos dest) {
        return this.add(dir.getOffsetX(), dir.getOffsetY(), dir.getOffsetZ(), dest);
    }

    @NotNull
    public ChunkTilePos add(int x, int y, int z) {
        return this.add(x, y, z, this);
    }

    @NotNull
    public ChunkTilePos add(@NotNull Vector3ic v) {
        return this.add(v.x(), v.y(), v.z(), this);
    }

    @NotNull
    public ChunkTilePos add(@NotNull Direction dir) {
        return this.add(dir.getOffsetX(), dir.getOffsetY(), dir.getOffsetZ(), this);
    }

    @Override
    @NotNull
    public ChunkTilePos sub(int x, int y, int z, @NotNull ChunkTilePos dest) {
        return dest.set(this.x - x, this.y - y, this.z - z);
    }

    @Override
    @NotNull
    public ChunkTilePos sub(@NotNull Vector3ic v, @NotNull ChunkTilePos dest) {
        return this.sub(v.x(), v.y(), v.z(), dest);
    }

    @Override
    @NotNull
    public ChunkTilePos sub(@NotNull Direction dir, @NotNull ChunkTilePos dest) {
        return this.sub(dir.getOffsetX(), dir.getOffsetY(), dir.getOffsetZ(), dest);
    }

    @NotNull
    public ChunkTilePos sub(int x, int y, int z) {
        return this.sub(x, y, z, this);
    }

    @NotNull
    public ChunkTilePos sub(@NotNull Vector3ic v) {
        return this.sub(v.x(), v.y(), v.z(), this);
    }

    @NotNull
    public ChunkTilePos sub(@NotNull Direction dir) {
        return this.sub(dir.getOffsetX(), dir.getOffsetY(), dir.getOffsetZ(), this);
    }

    @Override
    public double distance(@NotNull ChunkTilePosc pos) {
        int dx = pos.x() - this.x;
        int dy = pos.y() - this.y;
        int dz = pos.z() - this.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public double distanceSquared(@NotNull ChunkTilePosc pos) {
        int dx = pos.x() - this.x;
        int dy = pos.y() - this.y;
        int dz = pos.z() - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    @Override
    public boolean inBounds() {
        return this.x >= 0 && this.x < 16 && this.y >= 0 && this.y < 256 && this.z >= 0 && this.z < 16;
    }

    @Override
    public boolean equals(int x, int y, int z) {
        return false;
    }

    @Override
    @NotNull
    public ChunkTilePos up(@NotNull ChunkTilePos dest) {
        return this.add(Direction.UP, dest);
    }

    @Override
    @NotNull
    public ChunkTilePos down(@NotNull ChunkTilePos dest) {
        return this.add(Direction.DOWN, dest);
    }

    @Override
    @NotNull
    public ChunkTilePos north(@NotNull ChunkTilePos dest) {
        return this.add(Direction.NORTH, dest);
    }

    @Override
    @NotNull
    public ChunkTilePos south(@NotNull ChunkTilePos dest) {
        return this.add(Direction.SOUTH, dest);
    }

    @Override
    @NotNull
    public ChunkTilePos west(@NotNull ChunkTilePos dest) {
        return this.add(Direction.WEST, dest);
    }

    @Override
    @NotNull
    public ChunkTilePos east(@NotNull ChunkTilePos dest) {
        return this.add(Direction.EAST, dest);
    }

    @Override
    public int getSectionIndex() {
        return this.y / 16;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof ChunkTilePos) {
            @NotNull ChunkTilePos other = (ChunkTilePos)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }

    public int hashCode() {
        return MathHelper.cantor(MathHelper.cantor(this.x, this.y), this.z);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.z);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.set(in.readInt(), in.readInt(), in.readInt());
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

