/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.CompoundTag;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import net.minecraft.core.data.gamerule.GameRuleCollection;
import net.minecraft.core.enums.Difficulty;
import net.minecraft.core.world.config.spawning.SpawnerConfig;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LevelData {
    @NotNull
    private static final Logger LOGGER = LogUtils.getLogger();
    private final long randomSeed;
    @NotNull
    private final String levelName;
    @NotNull
    private final TilePos spawnPos = new TilePos();
    @NotNull
    private final GameRuleCollection gameRules;
    @NotNull
    private final SpawnerConfig spawnerConfig;
    private long worldTime;
    private long lastTimePlayed;
    private long sizeOnDisk;
    @Nullable
    private UUID lastPlayerUUID;
    private int saveVersion;
    private boolean cheatsEnabled;
    @NotNull
    private Difficulty difficulty = Difficulty.NORMAL;
    private boolean difficultyLocked;
    @Deprecated
    @Nullable
    private CompoundTag playerTag;

    @NotNull
    public static LevelData fromCompoundTag(@NotNull CompoundTag tag) {
        SpawnerConfig spawnerConfig;
        GameRuleCollection gameRules;
        long randomSeed = tag.getLong("RandomSeed");
        @NotNull String levelName = tag.getString("LevelName");
        if (tag.containsKey("GameRules")) {
            CompoundTag gameRulesTag = tag.getCompound("GameRules");
            gameRules = GameRuleCollection.readFromNBT(gameRulesTag);
        } else {
            gameRules = new GameRuleCollection();
        }
        if (tag.containsKey("SpawnConfig")) {
            CompoundTag spawnConfigTag = tag.getCompound("SpawnConfig");
            spawnerConfig = SpawnerConfig.createFromTag(spawnConfigTag);
        } else {
            spawnerConfig = new SpawnerConfig();
        }
        @NotNull LevelData data = new LevelData(randomSeed, levelName, gameRules, spawnerConfig);
        data.spawnPos.set(tag.getInteger("SpawnX"), tag.getInteger("SpawnY"), tag.getInteger("SpawnZ"));
        data.worldTime = tag.getLong("Time");
        data.lastTimePlayed = tag.getLong("LastPlayed");
        data.sizeOnDisk = tag.getLong("SizeOnDisk");
        data.saveVersion = tag.getInteger("version");
        data.cheatsEnabled = tag.getBoolean("CheatsEnabled");
        data.setDifficulty(tag.getIntegerOrDefault("Difficulty", Difficulty.NORMAL.id()), true);
        data.difficultyLocked = tag.getBooleanOrDefault("DifficultyLock", false);
        if (tag.containsKey("Player")) {
            data.playerTag = tag.getCompound("Player");
        }
        if (tag.containsKey("LastPlayerUUID")) {
            data.lastPlayerUUID = UUID.fromString(tag.getString("LastPlayerUUID"));
        }
        return data;
    }

    @NotNull
    public static CompoundTag toCompoundTag(@NotNull LevelData levelData, @NotNull CompoundTag out) {
        out.putLong("RandomSeed", levelData.randomSeed);
        out.putInt("SpawnX", levelData.spawnPos.x);
        out.putInt("SpawnY", levelData.spawnPos.y);
        out.putInt("SpawnZ", levelData.spawnPos.z);
        out.putLong("Time", levelData.worldTime);
        out.putLong("SizeOnDisk", levelData.sizeOnDisk);
        out.putLong("LastPlayed", System.currentTimeMillis());
        out.putString("LevelName", levelData.levelName);
        out.putInt("version", levelData.saveVersion);
        out.putBoolean("CheatsEnabled", levelData.cheatsEnabled);
        out.putInt("Difficulty", levelData.difficulty.id());
        out.putBoolean("DifficultyLock", levelData.difficultyLocked);
        CompoundTag gameRulesTag = new CompoundTag();
        GameRuleCollection.writeToNBT(gameRulesTag, levelData.gameRules);
        out.put("GameRules", gameRulesTag);
        if (levelData.lastPlayerUUID != null) {
            out.putString("LastPlayerUUID", levelData.lastPlayerUUID.toString());
        }
        CompoundTag spawnerConfigTag = new CompoundTag();
        levelData.spawnerConfig.writeToTag(spawnerConfigTag);
        out.put("SpawnConfig", spawnerConfigTag);
        return out;
    }

    @NotNull
    public static LevelData fromWorldDir(@NotNull File worldDir) throws IOException {
        @Nullable CompoundTag nbtRootData = null;
        if (!worldDir.exists()) {
            throw new IOException();
        }
        @NotNull File worldLevelDat = new File(worldDir, "level.dat");
        if (worldLevelDat.exists()) {
            @NotNull CompoundTag nbtRoot = NbtIo.readCompressed(Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
            nbtRootData = nbtRoot.getCompound("Data");
        } else {
            worldLevelDat = new File(worldDir, "level.dat_old");
            if (worldLevelDat.exists()) {
                @NotNull CompoundTag oldNbtRoot = NbtIo.readCompressed(Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
                nbtRootData = oldNbtRoot.getCompound("Data");
            }
        }
        if (nbtRootData != null) {
            return LevelData.fromCompoundTag(nbtRootData);
        }
        throw new IOException();
    }

    private LevelData(long randomSeed, @NotNull String levelName, @NotNull GameRuleCollection gameRules, @NotNull SpawnerConfig spawnerConfig) {
        this.randomSeed = randomSeed;
        this.levelName = levelName;
        this.gameRules = gameRules;
        this.spawnerConfig = spawnerConfig;
    }

    public LevelData(long randomSeed, @NotNull String name) {
        this(randomSeed, name, new GameRuleCollection(), new SpawnerConfig());
    }

    public LevelData(long randomSeed, @NotNull String name, @NotNull GameRuleCollection gameRules) {
        this(randomSeed, name, gameRules, new SpawnerConfig());
    }

    public LevelData(@NotNull LevelData levelData) {
        this(levelData.randomSeed, levelData.levelName, levelData.gameRules, levelData.spawnerConfig);
        this.spawnPos.set(levelData.spawnPos);
        this.worldTime = levelData.worldTime;
        this.lastTimePlayed = levelData.lastTimePlayed;
        this.sizeOnDisk = levelData.sizeOnDisk;
        this.playerTag = levelData.playerTag;
        this.saveVersion = levelData.saveVersion;
        this.cheatsEnabled = levelData.cheatsEnabled;
        this.difficulty = levelData.difficulty;
        this.difficultyLocked = levelData.difficultyLocked;
        this.lastPlayerUUID = levelData.lastPlayerUUID;
    }

    @Deprecated
    @Nullable
    public CompoundTag getPlayerTag() {
        return this.playerTag;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    @NotNull
    public TilePos getSpawnPos() {
        return this.spawnPos;
    }

    public long getWorldTime() {
        return this.worldTime;
    }

    public void setWorldTime(long time) {
        this.worldTime = time;
    }

    public long getSizeOnDisk() {
        return this.sizeOnDisk;
    }

    public void setSizeOnDisk(long size) {
        this.sizeOnDisk = size;
    }

    @NotNull
    public GameRuleCollection getGameRules() {
        return this.gameRules;
    }

    @NotNull
    public SpawnerConfig getSpawnerConfig() {
        return this.spawnerConfig;
    }

    @Nullable
    public UUID getLastPlayerUUID() {
        return this.lastPlayerUUID;
    }

    public void setLastPlayerUUID(@Nullable UUID lastPlayerUUID) {
        this.lastPlayerUUID = lastPlayerUUID;
    }

    @NotNull
    public String getWorldName() {
        return this.levelName;
    }

    public int getSaveVersion() {
        return this.saveVersion;
    }

    public void setSaveVersion(int i) {
        this.saveVersion = i;
    }

    public long getLastTimePlayed() {
        return this.lastTimePlayed;
    }

    public boolean getCheatsEnabled() {
        return this.cheatsEnabled;
    }

    public void setCheatsEnabled(boolean enabled) {
        this.cheatsEnabled = enabled;
    }

    public void setDifficulty(@NotNull Difficulty difficulty, boolean overrideLock) {
        if (!overrideLock && this.difficultyLocked) {
            return;
        }
        this.difficulty = difficulty;
    }

    public void setDifficulty(int difficulty, boolean overrideLock) {
        if (!overrideLock && this.difficultyLocked) {
            return;
        }
        if (difficulty < 0) {
            LOGGER.warn("Attempted to set difficulty to '{}' which is less than 0!", (Object)difficulty);
            difficulty = 0;
        }
        if (difficulty >= Difficulty.values().length) {
            LOGGER.error("Attempted to set difficulty to '{}' which is more than the '{}' difficulties!", (Object)difficulty, (Object)Difficulty.values().length);
            difficulty = Difficulty.values().length - 1;
        }
        this.setDifficulty(Difficulty.values()[difficulty], overrideLock);
    }

    @NotNull
    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficultyLocked() {
        this.difficultyLocked = true;
    }

    public boolean getDifficultyLocked() {
        return this.difficultyLocked;
    }
}

