/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.bta.worldloader;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.CompoundTag;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import net.minecraft.core.world.save.LevelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LevelDataLoader {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Nullable
    public static LevelData getLevelData(@NotNull File worldDir) {
        Objects.requireNonNull(worldDir, "WorldDir must not be null!");
        CompoundTag tag = LevelDataLoader.getLevelDataRaw(worldDir);
        if (tag == null) {
            return null;
        }
        return LevelData.fromCompoundTag(tag);
    }

    @Nullable
    public static CompoundTag getLevelDataRaw(@NotNull File worldDir) {
        Objects.requireNonNull(worldDir, "WorldDir must not be null!");
        if (!worldDir.exists()) {
            return null;
        }
        File worldLevelDat = new File(worldDir, "level.dat");
        if (worldLevelDat.exists()) {
            try {
                CompoundTag nbtRoot = NbtIo.readCompressed(Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
                return nbtRoot.getCompound("Data");
            }
            catch (Exception ex) {
                LOGGER.error("Error parsing 'level.dat' in '{}'", (Object)worldDir, (Object)ex);
            }
        }
        if ((worldLevelDat = new File(worldDir, "level.dat_old")).exists()) {
            try {
                CompoundTag oldNbtRoot = NbtIo.readCompressed(Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
                return oldNbtRoot.getCompound("Data");
            }
            catch (Exception ex) {
                LOGGER.error("Error parsing 'level.dat_old' in '{}'", (Object)worldDir, (Object)ex);
            }
        }
        return null;
    }
}

