#version 410 core
layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

in VS_OUT {
    vec2 size;
    vec4 color;
    vec2 uv;
    vec2 lightmap;
    float config;
} gs_in[];

out vec4 Color;
out vec2 UV;
out vec2 TexCoord;
out vec2 Lightmap;
out vec2 Size;
out float Config;

uniform mat4 model;
layout (std140) uniform Matrices {
    mat4 projection;
    mat4 projectionInv;
    mat4 view;
    mat4 viewInv;
} matrices;

void main() {
    UV = gs_in[0].uv;
    Size = gs_in[0].size;
    Config = gs_in[0].config;
    Color = gs_in[0].color;
    Lightmap = gs_in[0].lightmap;

    float shift = uint(gs_in[0].config) & 0x01u;

    TexCoord = gs_in[0].uv + vec2(-1, gs_in[0].size.y + 2)/128;
    gl_Position = matrices.projection * matrices.view * model * (gl_in[0].gl_Position + vec4(-shift - 1,  gs_in[0].size.y + 2, 0.0, 0.0));
    EmitVertex();

    TexCoord = gs_in[0].uv + vec2(gs_in[0].size.x + 2, gs_in[0].size.y + 2)/128;
    gl_Position = matrices.projection * matrices.view * model * (gl_in[0].gl_Position + vec4(gs_in[0].size.x - shift + 2,  gs_in[0].size.y + 2, 0.0, 0.0));
    EmitVertex();

    TexCoord = gs_in[0].uv + vec2(-1, -1)/128;
    gl_Position = matrices.projection * matrices.view * model * (gl_in[0].gl_Position + vec4(shift - 1, - 1, 0.0, 0.0));
    EmitVertex();

    TexCoord = gs_in[0].uv + vec2(gs_in[0].size.x + 2, -1)/128;
    gl_Position = matrices.projection * matrices.view * model * (gl_in[0].gl_Position + vec4(gs_in[0].size.x + shift + 2, -1, 0.0, 0.0));
    EmitVertex();

    EndPrimitive();
}