/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.ListSelectorButtonElement;
import net.minecraft.client.gui.modelviewer.elements.ListenerButtonElement;
import net.minecraft.client.gui.modelviewer.elements.TextCycleElement;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityEntryWolf
extends EntityEntry<MobWolf> {
    private static final List<ArmorMaterial> armorMaterials = new ArrayList<ArmorMaterial>(MobWolf.ARMOR_MATERIALS.keySet());

    @Override
    public void onTick(MobWolf entity) {
    }

    @Override
    public List<ButtonElement> getEntryButtons(Minecraft mc, Screen parentScreen, final MobWolf entityWolf) {
        ArrayList<ButtonElement> buttonList = new ArrayList<ButtonElement>();
        boolean isTamed = entityWolf.isWolfTamed();
        ListenerButtonElement tamed = new ListenerButtonElement(-1, -120, 0, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.tamed", isTamed));
        tamed.setActionListener(() -> {
            boolean _tamed = !entityWolf.isWolfTamed();
            entityWolf.setWolfTamed(_tamed);
            tamed.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.tamed", _tamed);
        });
        boolean isSitting = entityWolf.isWolfSitting();
        ListenerButtonElement sitting = new ListenerButtonElement(-1, -120, tamed.yPosition + 21, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.sitting", isSitting));
        sitting.setActionListener(() -> {
            boolean _sitting = !entityWolf.isWolfSitting();
            entityWolf.setWolfSitting(_sitting);
            sitting.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.sitting", _sitting);
        });
        boolean isAngry = entityWolf.isWolfAngry();
        ListenerButtonElement angry = new ListenerButtonElement(-1, -120, sitting.yPosition + 21, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.angry", isAngry));
        angry.setActionListener(() -> {
            boolean _angry = !entityWolf.isWolfAngry();
            entityWolf.setWolfAngry(_angry);
            angry.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.angry", _angry);
        });
        ListSelectorButtonElement<ArmorMaterial> armor = new ListSelectorButtonElement<ArmorMaterial>(-1, -120, angry.yPosition + 21, 120, 20, I18n.getInstance().translateKey("model.category.entity.wolf.button.armor"), armorMaterials, null){

            @Override
            public String getNameFromElement(ArmorMaterial element) {
                return element == null ? "none" : element.identifier.toString();
            }
        };
        armor.setActionListener(() -> {
            ArmorMaterial material = (ArmorMaterial)armor.getCurrentElement();
            entityWolf.getEntityData().set(19, material == null ? "" : material.identifier.toString());
        });
        entityWolf.setHeldItem(null);
        ListenerButtonElement hasItem = new ListenerButtonElement(-1, -120, armor.yPosition + 21, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.item", false));
        TextCycleElement<Integer> itemIdCycle = new TextCycleElement<Integer>(parentScreen, mc.font, -120, hasItem.yPosition + 21, 120, 20, Integer.valueOf(1)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return ScreenModelViewer.cycleItemId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    if (Item.itemsList[id] != null) {
                        return id;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (entityWolf.getHeldItem() != null) {
                    return entityWolf.getHeldItem().itemID;
                }
                return 0;
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        itemIdCycle.enabled = false;
        itemIdCycle.textField.setPrefaceText("ID: ");
        itemIdCycle.textField.setPlaceholder("Item ID");
        TextCycleElement<Integer> metaCycle = new TextCycleElement<Integer>(parentScreen, mc.font, -120, itemIdCycle.yPosition + 21, 120, 20, Integer.valueOf(0)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return current + offset & 0x3FFF;
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    return MathHelper.clamp(id, 0, 16383);
                }
                catch (Exception exception) {
                    if (entityWolf.getHeldItem() != null) {
                        return entityWolf.getHeldItem().getMetadata();
                    }
                    return 0;
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        metaCycle.enabled = false;
        metaCycle.textField.setPrefaceText("Meta: ");
        metaCycle.textField.setPlaceholder("Meta");
        itemIdCycle.setOnValueChanged(() -> entityWolf.setHeldItem(new ItemStack((Integer)itemIdCycle.getCurrentElement(), 1, (int)((Integer)metaCycle.getCurrentElement()))));
        metaCycle.setOnValueChanged(() -> entityWolf.setHeldItem(new ItemStack((Integer)itemIdCycle.getCurrentElement(), 1, (int)((Integer)metaCycle.getCurrentElement()))));
        hasItem.setActionListener(() -> {
            boolean _hasItem;
            boolean bl = _hasItem = entityWolf.getHeldItem() != null;
            if (_hasItem) {
                entityWolf.setHeldItem(null);
                itemIdCycle.enabled = false;
                metaCycle.enabled = false;
            } else {
                entityWolf.setHeldItem(new ItemStack((Integer)itemIdCycle.getCurrentElement(), 1, (int)((Integer)metaCycle.getCurrentElement())));
                itemIdCycle.enabled = true;
                metaCycle.enabled = true;
            }
            hasItem.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.wolf.button.item", !_hasItem);
        });
        buttonList.add(tamed);
        buttonList.add(sitting);
        buttonList.add(angry);
        buttonList.add(armor);
        buttonList.add(hasItem);
        buttonList.add(itemIdCycle);
        buttonList.add(metaCycle);
        return buttonList;
    }

    @Override
    public MobWolf getEntityInstance(Minecraft mc, World world) {
        MobWolf wolf = new MobWolf(world);
        wolf.setHeldItem(null);
        return wolf;
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }

    static {
        armorMaterials.add(null);
    }
}

