/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings;

import java.util.List;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.paged.Page;
import net.minecraft.client.gui.paged.PageComponent;
import net.minecraft.client.gui.paged.PageRegistry;
import net.minecraft.client.gui.paged.ScreenPaged;
import net.minecraft.client.gui.worldsettings.BooleanGameRuleComponent;
import net.minecraft.client.gui.worldsettings.CategoryMobSpawningComponent;
import net.minecraft.client.gui.worldsettings.EntryMobSpawningComponent;
import net.minecraft.client.gui.worldsettings.StartingBiomeButtonComponent;
import net.minecraft.client.gui.worldsettings.WorldTypeButtonComponent;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.data.gamerule.GameRuleBoolean;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenWorldSettings
extends ScreenPaged {
    @NotNull
    public static final PageRegistry CREATE_WORLD_PAGES = new PageRegistry();
    @NotNull
    public static final Page PAGE_GAME_RULES = CREATE_WORLD_PAGES.register(new Page("gui.world_settings.page.game_rules.title", Items.PAPER.getDefaultStack()));
    @NotNull
    public static final Page PAGE_WORLD_SETTINGS;
    @NotNull
    public static final Page PAGE_MOB_SPAWNING;
    @NotNull
    private final WorldConfiguration worldConfiguration;

    public ScreenWorldSettings(@Nullable Screen parent, @NotNull WorldConfiguration worldConfiguration) {
        super(parent, CREATE_WORLD_PAGES, PAGE_GAME_RULES, "gui.world_settings.label.title", new String[]{"gui.world_settings.button.done"});
        this.worldConfiguration = worldConfiguration;
        List<PageComponent> gameRulesPageComponents = PAGE_GAME_RULES.getComponents();
        for (PageComponent pageComponent : gameRulesPageComponents) {
            if (!(pageComponent instanceof BooleanGameRuleComponent)) continue;
            BooleanGameRuleComponent ruleComponent = (BooleanGameRuleComponent)pageComponent;
            ruleComponent.setGameRuleCollection(worldConfiguration.getGameRuleCollection());
        }
        List<PageComponent> worldSettingsPageComponents = PAGE_WORLD_SETTINGS.getComponents();
        for (PageComponent component : worldSettingsPageComponents) {
            if (component instanceof WorldTypeButtonComponent) {
                WorldTypeButtonComponent typeButtonComponent = (WorldTypeButtonComponent)component;
                typeButtonComponent.setWorldConfiguration(worldConfiguration);
                continue;
            }
            if (!(component instanceof StartingBiomeButtonComponent)) continue;
            StartingBiomeButtonComponent startingBiomeButtonComponent = (StartingBiomeButtonComponent)component;
            startingBiomeButtonComponent.setWorldConfiguration(worldConfiguration);
        }
        List<PageComponent> list = PAGE_MOB_SPAWNING.getComponents();
        for (PageComponent component : list) {
            if (component instanceof EntryMobSpawningComponent) {
                EntryMobSpawningComponent mobSpawningComponent = (EntryMobSpawningComponent)component;
                mobSpawningComponent.setSpawnConfiguration(worldConfiguration);
                continue;
            }
            if (!(component instanceof CategoryMobSpawningComponent)) continue;
            CategoryMobSpawningComponent categoryComponent = (CategoryMobSpawningComponent)component;
            categoryComponent.setSpawnConfiguration(worldConfiguration);
        }
    }

    static {
        for (GameRule<?> gameRule : Registries.GAME_RULES) {
            if (!(gameRule instanceof GameRuleBoolean)) continue;
            PAGE_GAME_RULES.withComponent(new BooleanGameRuleComponent((GameRuleBoolean)gameRule));
        }
        PAGE_WORLD_SETTINGS = CREATE_WORLD_PAGES.register(new Page("gui.world_settings.page.world_settings.title", Items.PAINTBRUSH.getDefaultStack()).withComponent(new WorldTypeButtonComponent("gui.world_settings.label.world_type", null)).withComponent(new StartingBiomeButtonComponent("gui.world_settings.label.starting_biome", null)));
        PAGE_MOB_SPAWNING = CREATE_WORLD_PAGES.register(new Page("gui.world_settings.page.mob_spawning.title", Items.EGG_CHICKEN.getDefaultStack()).withComponent(new CategoryMobSpawningComponent(CategoryMobSpawningComponent.Type.HOSTILE)).withComponent(new CategoryMobSpawningComponent(CategoryMobSpawningComponent.Type.PASSIVE)));
        for (EntityDispatcher.EntityDispatcherEntry entityDispatcherEntry : EntityDispatcher.getInstance().entries) {
            if (!Mob.class.isAssignableFrom(entityDispatcherEntry.entityClass) || entityDispatcherEntry.nameKey == null) continue;
            PAGE_MOB_SPAWNING.withComponent(new EntryMobSpawningComponent(entityDispatcherEntry));
        }
    }
}

