/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicSpikes;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericSpikes<T extends BlockLogic>
extends BlockModelGeneric<T> {
    @NotNull
    public StaticBlockModel spikes = BlockModelDispatcher.loadDataModel("minecraft:block/spikes").asModel();

    public BlockModelGenericSpikes(@NotNull Block<T> block) {
        super(block, BlockModelDispatcher.loadDataModel("minecraft:block/spikes_base"));
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        int rotX = 1;
        int rotY = 0;
        int data = worldSource.getBlockData(tilePos);
        switch (BlockLogicSpikes.getDirectionFromData(data)) {
            case UP: {
                rotX = 2;
                break;
            }
            case DOWN: {
                rotX = 0;
                break;
            }
            case NORTH: {
                rotY = 0;
                break;
            }
            case SOUTH: {
                rotY = 2;
                break;
            }
            case WEST: {
                rotY = 1;
                break;
            }
            case EAST: {
                rotY = 3;
            }
        }
        boolean didRender = this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, rotX, rotY, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
        if (BlockLogicSpikes.isSpikesUp(data)) {
            didRender |= this.spikes.renderAttached(this, tessellator, worldSource, tilePos, rotX, rotY, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
        }
        return didRender;
    }
}

