/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.entity.player.PlayerRemote;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemModelBow
extends ItemModelStandard {
    public ItemModelBow(Item item, String namespace) {
        super(item, namespace);
    }

    @Override
    protected void renderSingle(@NotNull TessellatorGeneral tessellator, @Nullable Entity holder, @NotNull ItemStack itemStack, boolean items3d, byte lightIndex, int color, float partialTick, boolean mirrorX) {
        super.renderSingle(tessellator, holder, itemStack, items3d, lightIndex, color, partialTick, mirrorX);
        Item nextArrow = null;
        if (holder instanceof Player) {
            Player player = (Player)holder;
            nextArrow = this.getNextArrow(player);
        } else if (holder instanceof MobSkeleton) {
            MobSkeleton skeleton = (MobSkeleton)holder;
            if (skeleton.attackTime < 5) {
                nextArrow = Items.AMMO_ARROW;
            }
        }
        if (nextArrow != null) {
            GLRenderer.pushFrame();
            if (mirrorX) {
                GLRenderer.modelM4f().rotateZ(-1.5707964f);
            } else {
                GLRenderer.modelM4f().rotateZ(1.5707964f);
            }
            GLRenderer.modelM4f().translate(1.0E-4f, 1.0E-4f, 0.0f);
            GLRenderer.modelM4f().scale(1.0f, 1.0f, 0.999f);
            this.renderCoordinate(tessellator, ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(nextArrow)).getIcon(holder, nextArrow.getDefaultStack()), lightIndex, color, items3d, mirrorX);
            GLRenderer.popFrame();
        }
    }

    public Item getNextArrow(Player player) {
        if (player instanceof PlayerRemote) {
            int id = player.getArrowId();
            if (id < 0 || id >= Item.itemsList.length) {
                return null;
            }
            return Item.itemsList[id];
        }
        return player.getNextArrow();
    }
}

