/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings;

import java.util.Iterator;
import net.minecraft.core.world.settings.KeyedSettingNode;
import net.minecraft.core.world.settings.SettingNodeChildrenProvider;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SettingNode {
    @Nullable
    public SettingNodeChildrenProvider getChildrenProvider();

    public boolean isVisible(@NotNull WorldConfiguration var1);

    public boolean areChildrenVisible(@NotNull WorldConfiguration var1);

    @Nullable
    default public KeyedSettingNode getChildByKey(@NotNull String key, @NotNull WorldConfiguration worldConfiguration) {
        @Nullable SettingNodeChildrenProvider childrenProvider = this.getChildrenProvider();
        if (childrenProvider != null) {
            @Nullable KeyedSettingNode myChild = childrenProvider.getChildByKey(key, worldConfiguration);
            if (myChild != null) {
                return myChild;
            }
            @NotNull Iterator<@NotNull SettingNode> it = childrenProvider.getChildren(worldConfiguration);
            while (it.hasNext()) {
                @NotNull SettingNode child = it.next();
                @Nullable KeyedSettingNode childsChild = child.getChildByKey(key, worldConfiguration);
                if (childsChild == null) continue;
                return childsChild;
            }
        }
        return null;
    }
}

