/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type.overworld;

import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderSingleBiome;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.skyblock.ChunkGeneratorSkyblock;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.overworld.WorldTypeOverworld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldTypeOverworldSkyblock
extends WorldTypeOverworld {
    public WorldTypeOverworldSkyblock(WorldType.Properties properties) {
        super(properties);
    }

    @Override
    @NotNull
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderSingleBiome(Biomes.OVERWORLD_PLAINS, 1.0, 1.0, 1.0);
    }

    @Override
    @NotNull
    public @NotNull Biome @NotNull [] allBiomes() {
        return new Biome[]{Biomes.OVERWORLD_PLAINS};
    }

    @Override
    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorSkyblock(world);
    }

    @Override
    public boolean isValidSpawn(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public void getInitialSpawnLocation(World world, @Nullable Biome startingBiome) {
        world.getLevelData().getSpawnPos().set(0, 66, 0);
    }

    @Override
    public void getRespawnLocation(World world) {
    }
}

