/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.useless.util.GsonHelper;

public final class DisplayPos {
    public static final String NONE = "none";
    public static final String THIRD_PERSON_RIGHT_HAND = "thirdperson_righthand";
    public static final String THIRD_PERSON_LEFT_HAND = "thirdperson_lefthand";
    public static final String FIRST_PERSON_RIGHT_HAND = "firstperson_righthand";
    public static final String FIRST_PERSON_LEFT_HAND = "firstperson_lefthand";
    public static final String GUI = "gui";
    public static final String HEAD = "head";
    public static final String GROUND = "ground";
    public static final String FIXED = "fixed";
    public static final String JAR = "jar";
    public static final DisplayPos DEFAULT_DISPLAY_POS = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    public final float tx;
    public final float ty;
    public final float tz;
    public final float rx;
    public final float ry;
    public final float rz;
    public final float sx;
    public final float sy;
    public final float sz;

    public DisplayPos(float tx, float ty, float tz, float rx, float ry, float rz, float sx, float sy, float sz) {
        this.tx = tx;
        this.ty = ty;
        this.tz = tz;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        this.sx = sx;
        this.sy = sy;
        this.sz = sz;
    }

    public String toString() {
        return "DisplayPos{tx=" + this.tx + ", ty=" + this.ty + ", tz=" + this.tz + ", rx=" + this.rx + ", ry=" + this.ry + ", rz=" + this.rz + ", sx=" + this.sx + ", sy=" + this.sy + ", sz=" + this.sz + "}";
    }

    public static class Serializer
    implements JsonSerializer<DisplayPos>,
    JsonDeserializer<DisplayPos> {
        @Override
        public DisplayPos deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            float[] fArray;
            float[] fArray2;
            float[] fArray3;
            JsonObject object = json.getAsJsonObject();
            if (object.has("rotation")) {
                fArray3 = GsonHelper.getAsFloatArray(object.get("rotation"), 3);
            } else {
                float[] fArray4 = new float[3];
                fArray4[0] = 0.0f;
                fArray4[1] = 0.0f;
                fArray3 = fArray4;
                fArray4[2] = 0.0f;
            }
            float[] rotation = fArray3;
            if (object.has("translation")) {
                fArray2 = GsonHelper.getAsFloatArray(object.get("translation"), 3);
            } else {
                float[] fArray5 = new float[3];
                fArray5[0] = 0.0f;
                fArray5[1] = 0.0f;
                fArray2 = fArray5;
                fArray5[2] = 0.0f;
            }
            float[] translation = fArray2;
            if (object.has("scale")) {
                fArray = GsonHelper.getAsFloatArray(object.get("scale"), 3);
            } else {
                float[] fArray6 = new float[3];
                fArray6[0] = 0.0f;
                fArray6[1] = 0.0f;
                fArray = fArray6;
                fArray6[2] = 0.0f;
            }
            float[] scale = fArray;
            return new DisplayPos(translation[0] * 0.0625f, translation[1] * 0.0625f, translation[2] * 0.0625f, rotation[0], rotation[1], rotation[2], scale[0], scale[1], scale[2]);
        }

        @Override
        public JsonElement serialize(DisplayPos src, Type typeOfSrc, JsonSerializationContext context) {
            throw new UnsupportedOperationException();
        }
    }
}

