/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.bta;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import net.minecraft.core.Global;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderOverworld;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.type.WorldTypes;
import org.slf4j.Logger;
import org.useless.seedviewer.bta.BTAComplexChunk;
import org.useless.seedviewer.bta.BTASimpleChunk;
import org.useless.seedviewer.bta.DummyMinecraft;
import org.useless.seedviewer.bta.worldloader.ChunkLoader;
import org.useless.seedviewer.data.ViewerChunk;
import org.useless.seedviewer.gui.ChunkProvider;

public class BTAChunkProvider
implements ChunkProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    ChunkLoader chunkLoader = null;
    private final BiomeProvider biomeProvider;

    public BTAChunkProvider(long seed) {
        this.biomeProvider = new BiomeProviderOverworld(seed, WorldTypes.OVERWORLD_EXTENDED);
    }

    public BTAChunkProvider(File worldFolder, LevelData data) {
        this.biomeProvider = new BiomeProviderOverworld(data.getRandomSeed(), WorldTypes.OVERWORLD_EXTENDED);
        this.chunkLoader = new ChunkLoader(worldFolder, Dimension.OVERWORLD);
    }

    @Override
    public ViewerChunk getChunk(ChunkPos location) {
        if (this.chunkLoader != null) {
            try {
                Chunk c = this.chunkLoader.loadChunk(location);
                if (c != null) {
                    return new BTAComplexChunk(c, this.biomeProvider);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load chunk data for chunk {}, {}", location.x, location.z, e);
            }
        }
        return new BTASimpleChunk(location, this.biomeProvider);
    }

    static {
        if (Global.accessor == null) {
            Global.accessor = new DummyMinecraft();
            Blocks.init();
            Items.init();
            new Registries();
            Biomes.init();
            WorldTypes.init();
            BiomeProviderOverworld.init();
            I18n.initialize("en_US");
        }
    }
}

