/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.gui.components;

import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkTilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.useless.seedviewer.TestChunkProvider;
import org.useless.seedviewer.bta.BTAChunkProvider;
import org.useless.seedviewer.bta.BTAWorld;
import org.useless.seedviewer.collections.ObjectWrapper;
import org.useless.seedviewer.data.ViewerBiome;
import org.useless.seedviewer.data.ViewerChunk;
import org.useless.seedviewer.data.ViewerWorld;
import org.useless.seedviewer.gui.ChunkProvider;
import org.useless.seedviewer.gui.ChunkView;
import org.useless.seedviewer.gui.SeedViewer;

public class Viewport
extends JLabel {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final long MS_UNTIL_CHUNK_UNLOAD = 10000L;
    public static final int VIEWPORT_CHUNKS_OVERSCAN = 4;
    public static final int VIEWPORT_UNLOAD_OVERSCAN = 10;
    public static final float ZOOM_SENSITIVITY = 0.125f;
    public static final float ZOOM_MIN = 1.0f;
    public static final float ZOOM_MAX = 16.0f;
    private final Map<ChunkPos, ChunkView> chunkViewMap = new HashMap<ChunkPos, ChunkView>();
    private final Set<ChunkView> chunksPendingPostProcess = new HashSet<ChunkView>();
    private final BufferedImage slimeVignette;
    public ChunkProvider chunkProvider = new TestChunkProvider();
    public final ObjectWrapper<@NotNull Long> seed = new ObjectWrapper<Long>(100L);
    public final ObjectWrapper<@Nullable ViewerWorld> world = new ObjectWrapper<Object>(null);
    public final ObjectWrapper<@NotNull Float> zoom = new ObjectWrapper<Float>(Float.valueOf(1.0f));
    public final ObjectWrapper<@NotNull Float> viewX = new ObjectWrapper<Float>(Float.valueOf(0.0f));
    public final ObjectWrapper<@NotNull Float> viewZ = new ObjectWrapper<Float>(Float.valueOf(0.0f));
    public final ObjectWrapper<@NotNull Boolean> showSlimeChunks = new ObjectWrapper<Boolean>(true);
    public final ObjectWrapper<@NotNull Boolean> showChunkBorders = new ObjectWrapper<Boolean>(true);
    public final ObjectWrapper<@NotNull Boolean> showBiomes = new ObjectWrapper<Boolean>(true);
    public final ObjectWrapper<@NotNull Boolean> showTerrain = new ObjectWrapper<Boolean>(true);
    public final ObjectWrapper<@NotNull Boolean> showCrosshair = new ObjectWrapper<Boolean>(true);
    private final SeedViewer seedViewer;
    private Point lastLeftClickPoint = null;
    private ChunkPos lastHoveredLocation = null;
    private ViewerChunk lastHoveredChunk = null;

    public Viewport(SeedViewer seedViewer) {
        this.seedViewer = seedViewer;
        BufferedImage _vignette = null;
        try {
            InputStream stream = Viewport.class.getResourceAsStream("/assets/seedviewer/textures/slime_vignette.png");
            if (stream != null) {
                _vignette = ImageIO.read(stream);
            } else {
                LOGGER.error("Stream for '/seedviewer/slime_vignette.png' is null!");
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load slime vignette!");
        }
        this.slimeVignette = _vignette;
        try {
            this.setSeed(Long.parseLong(seedViewer.launchProperties.getProperty("seed", "100")));
        }
        catch (NumberFormatException ignored) {
            this.setSeed(seedViewer.launchProperties.getProperty("seed", "100").hashCode());
        }
    }

    public void setup() {
        this.addMouseWheelListener(e -> {
            if (e.getScrollType() == 0) {
                this.offsetZoom((float)(-e.getUnitsToScroll()) * 0.125f);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    Viewport.this.lastLeftClickPoint = e.getPoint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Viewport.this.lastLeftClickPoint != null) {
                    int dx = e.getX() - Viewport.this.lastLeftClickPoint.x;
                    int dy = e.getY() - Viewport.this.lastLeftClickPoint.y;
                    Viewport.this.lastLeftClickPoint = e.getPoint();
                    Viewport.this.offsetView(-dx, dy);
                }
            }
        });
        this.setBorder(new LineBorder(Color.BLACK, 1, false));
        this.setFocusable(true);
    }

    public void onResize(Rectangle newShape) {
        this.setBounds(newShape.x, newShape.y, newShape.width, newShape.height);
    }

    public synchronized void tick() {
        Rectangle viewportBounds = this.getViewportBounds();
        Rectangle unloadBounds = new Rectangle(viewportBounds.x - 10, viewportBounds.y - 10, viewportBounds.width + 20, viewportBounds.height + 20);
        HashSet<ChunkPos> removalQueue = new HashSet<ChunkPos>();
        for (ChunkView view : this.chunkViewMap.values()) {
            if (unloadBounds.intersects(view.getWorldBounds())) {
                view.lastSeenTime = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - view.lastSeenTime <= 10000L) continue;
            removalQueue.add(view.getLocation());
        }
        for (ChunkPos location : removalQueue) {
            this.removeChunkView(location);
        }
        this.addMissingViewers(viewportBounds);
        if (this.showTerrain.get().booleanValue() && this.world.get() != null) {
            ArrayList<ChunkView> unpendedChunks = new ArrayList<ChunkView>();
            for (ChunkView view : this.chunksPendingPostProcess) {
                ChunkPos up;
                if (!view.hasInit() || view.hasProcessed() || !this.chunkViewMap.containsKey(up = new ChunkPos(view.getLocation().x, view.getLocation().z - 1)) || !this.chunkViewMap.get(up).hasInit()) continue;
                view.process(this.chunkViewMap.get(up));
                unpendedChunks.add(view);
            }
            unpendedChunks.forEach(this.chunksPendingPostProcess::remove);
        }
        this.repaint();
    }

    public synchronized void addMissingViewers(Rectangle viewportBounds) {
        ChunkPos topLeftLocation = new ChunkPos(viewportBounds.x / 16, viewportBounds.y / 16);
        int chunksX = viewportBounds.width / 16;
        int chunksZ = viewportBounds.height / 16;
        ArrayList<ChunkPos> pendingLocation = new ArrayList<ChunkPos>();
        for (int _x = topLeftLocation.x; _x < topLeftLocation.x + chunksX; ++_x) {
            for (int _z = topLeftLocation.z; _z < topLeftLocation.z + chunksZ; ++_z) {
                ChunkPos location = new ChunkPos(_x, _z);
                if (this.chunkViewMap.containsKey(location)) continue;
                pendingLocation.add(location);
            }
        }
        pendingLocation.sort((o1, o2) -> {
            ChunkPos viewLoc = new ChunkPos((int)Math.floor(this.viewX.get().floatValue() / 16.0f), (int)Math.floor(-this.viewZ.get().floatValue() / 16.0f));
            int dx = o1.x - viewLoc.x;
            int dz = o1.z - viewLoc.z;
            int d1 = dx * dx + dz * dz;
            int dx2 = o2.x - viewLoc.x;
            int dz2 = o2.z - viewLoc.z;
            int d2 = dx2 * dx2 + dz2 * dz2;
            return d1 - d2;
        });
        pendingLocation.forEach(this::addChunkView);
    }

    public synchronized void setSeed(long seed) {
        this.seed.set(seed);
        this.clearChunkViews();
        this.viewX.set(Float.valueOf(0.0f));
        this.viewZ.set(Float.valueOf(0.0f));
        this.chunkProvider = new BTAChunkProvider(this.seed.get());
        this.seedViewer.queueResize();
    }

    public synchronized void setWorld(@Nullable File file) {
        if (file != null) {
            try {
                this.world.set(new BTAWorld(file));
                this.chunkProvider = Objects.requireNonNull(this.world.get()).getChunkProvider();
            }
            catch (Exception e) {
                LOGGER.error("", e);
                this.world.set(null);
                this.chunkProvider = new BTAChunkProvider(this.seed.get());
            }
        } else {
            this.world.set(null);
            this.chunkProvider = new BTAChunkProvider(this.seed.get());
        }
        this.clearChunkViews();
        this.viewX.set(Float.valueOf(0.0f));
        this.viewZ.set(Float.valueOf(0.0f));
        this.seedViewer.queueResize();
    }

    public Rectangle getViewportBounds() {
        int blockX = (int)Math.floor(this.viewX.get().floatValue() - (float)this.getWidth() / (this.zoom.get().floatValue() * 2.0f));
        int blockZ = (int)Math.floor(-this.viewZ.get().floatValue() - (float)this.getHeight() / (this.zoom.get().floatValue() * 2.0f));
        int widthBlocks = (int)Math.ceil((float)this.getWidth() / this.zoom.get().floatValue());
        int heightBlocks = (int)Math.ceil((float)this.getHeight() / this.zoom.get().floatValue());
        return new Rectangle(blockX - 64, blockZ - 64, widthBlocks + 144, heightBlocks + 144);
    }

    public synchronized void offsetZoom(float delta) {
        this.setZoom(this.zoom.get().floatValue() + delta);
    }

    public synchronized void setZoom(float newZoom) {
        if (newZoom < 1.0f) {
            newZoom = 1.0f;
        }
        if (newZoom > 16.0f) {
            newZoom = 16.0f;
        }
        this.zoom.set(Float.valueOf(newZoom));
        this.repaint();
    }

    public synchronized void offsetView(float deltaX, float deltaZ) {
        this.setOffsetView(this.viewX.get().floatValue() + deltaX / this.zoom.get().floatValue(), this.viewZ.get().floatValue() + deltaZ / this.zoom.get().floatValue());
    }

    public synchronized void setOffsetView(float newX, float newZ) {
        this.viewX.set(Float.valueOf(newX));
        this.viewZ.set(Float.valueOf(newZ));
        this.repaint();
    }

    public synchronized void addChunkView(ChunkPos location) {
        ChunkView view = new ChunkView(this, location, this.chunkProvider);
        this.chunkViewMap.put(location, view);
        this.chunksPendingPostProcess.add(view);
    }

    public synchronized void removeChunkView(ChunkPos location) {
        ChunkView view = this.chunkViewMap.remove(location);
        if (view != null) {
            view.kill();
            this.chunksPendingPostProcess.remove(view);
        }
    }

    public synchronized void clearChunkViews() {
        this.chunkViewMap.forEach((l, c) -> c.kill());
        this.chunkViewMap.clear();
        this.chunksPendingPostProcess.clear();
    }

    public synchronized ViewerBiome getHoveredBiome() {
        ViewerChunk chunk;
        ChunkPos chunkLocation = new ChunkPos((int)Math.floor(this.viewX.get().floatValue() / 16.0f), (int)Math.floor(-this.viewZ.get().floatValue() / 16.0f));
        if (this.lastHoveredLocation != null && this.lastHoveredChunk != null && this.lastHoveredLocation.equals(chunkLocation)) {
            chunk = this.lastHoveredChunk;
        } else {
            this.lastHoveredChunk = chunk = this.chunkProvider.getChunk(chunkLocation);
            this.lastHoveredLocation = chunkLocation;
        }
        ChunkTilePos c2D = new ChunkTilePos((int)Math.floor(this.viewX.get().floatValue()) - chunkLocation.x * 16, 0, (int)Math.floor(-this.viewZ.get().floatValue()) - chunkLocation.z * 16);
        return chunk.getBiome(new ChunkTilePos(c2D.x, chunk.getHeight(c2D), c2D.z));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintToGraphics(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintToGraphics(Graphics g) {
        Viewport viewport = this;
        synchronized (viewport) {
            Rectangle viewportBounds = this.getViewportBounds();
            long seed = this.world.get() == null ? this.seed.get().longValue() : this.world.get().getSeed();
            for (ChunkView view : this.chunkViewMap.values()) {
                if (!viewportBounds.intersects(view.getWorldBounds())) continue;
                int blockX = view.getLocation().x * 16;
                int blockZ = view.getLocation().z * 16;
                int subImgX = (int)Math.floor((double)(((float)blockX - this.viewX.get().floatValue()) * this.zoom.get().floatValue()) + (double)this.getWidth() / 2.0);
                int subImgZ = (int)Math.floor((double)(((float)blockZ + this.viewZ.get().floatValue()) * this.zoom.get().floatValue()) + (double)this.getHeight() / 2.0);
                int subImgWidth = (int)Math.floor(16.0f * this.zoom.get().floatValue());
                int subImgHeight = (int)Math.floor(16.0f * this.zoom.get().floatValue());
                if (this.showTerrain.get().booleanValue() && this.world.get() != null) {
                    g.drawImage(view.getTerrainMapImage(), subImgX, subImgZ, subImgWidth, subImgHeight, null, null);
                }
                if (this.showBiomes.get().booleanValue()) {
                    g.drawImage(view.getBiomeMapImage(), subImgX, subImgZ, subImgWidth, subImgHeight, null, null);
                }
                if (!this.showSlimeChunks.get().booleanValue() || !SeedViewer.isSlimeChunk(seed, view.getLocation())) continue;
                Graphics gSlime = g.create();
                if (this.slimeVignette == null) {
                    gSlime.setColor(new Color(64, 255, 120, 128));
                    gSlime.fillRect(subImgX, subImgZ, subImgWidth, subImgHeight);
                } else {
                    gSlime.drawImage(this.slimeVignette, subImgX, subImgZ, subImgWidth, subImgHeight, null, null);
                }
                gSlime.dispose();
            }
            if (this.showChunkBorders.get().booleanValue()) {
                int leftChunk = viewportBounds.x / 16;
                int widthChunks = viewportBounds.width / 16;
                int topChunk = viewportBounds.y / 16;
                int heightChunks = viewportBounds.height / 16;
                Graphics gBorders = g.create();
                gBorders.setColor(new Color(0, 0, 0, 64));
                for (int _x = leftChunk; _x <= leftChunk + widthChunks; ++_x) {
                    float blockX = _x * 16;
                    int subImgX = (int)Math.floor((double)((blockX - this.viewX.get().floatValue()) * this.zoom.get().floatValue()) + (double)this.getWidth() / 2.0);
                    gBorders.drawLine(subImgX, 0, subImgX, this.getHeight());
                }
                for (int _z = topChunk; _z < topChunk + heightChunks; ++_z) {
                    float blockZ = _z * 16;
                    int subImgZ = (int)Math.floor((double)((blockZ + this.viewZ.get().floatValue()) * this.zoom.get().floatValue()) + (double)this.getHeight() / 2.0);
                    gBorders.drawLine(0, subImgZ, this.getWidth(), subImgZ);
                }
                gBorders.dispose();
            }
            if (this.showCrosshair.get().booleanValue()) {
                Graphics gCrosshair = g.create();
                int centX = this.getWidth() / 2;
                int centZ = this.getHeight() / 2;
                int lineReach = 10;
                int lineWidth = 2;
                gCrosshair.setColor(Color.BLACK);
                gCrosshair.setXORMode(Color.WHITE);
                gCrosshair.fillRect(centX - lineReach, centZ - lineWidth / 2, lineReach * 2, lineWidth);
                gCrosshair.fillRect(centX - lineWidth / 2, centZ - lineReach, lineWidth, lineReach * 2);
                gCrosshair.dispose();
            }
        }
    }
}

