/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings.settingnode;

import java.util.Objects;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.paged.ScreenPaged;
import net.minecraft.client.gui.worldsettings.settingnode.NestedNodeComponent;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.settings.ValueSettingNode;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ValueNodeComponent<T>
extends NestedNodeComponent {
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 20;
    @NotNull
    private final Text nameText;
    @NotNull
    protected final ButtonElement resetButton;

    public ValueNodeComponent(@NotNull ValueSettingNode<T> valueNode, int nestLevel) {
        super(valueNode, nestLevel);
        this.nameText = valueNode.getName();
        this.resetButton = new ButtonElement(0, 0, 0, 20, 20, "").setTextures("minecraft:gui/misc/icon_reset", "minecraft:gui/misc/icon_reset_highlighted", "minecraft:gui/misc/icon_reset");
    }

    @Override
    public void reset() {
        @Nullable WorldConfiguration worldConfiguration = this.getWorldConfiguration();
        @Nullable Dimension dimension = this.getDimension();
        assert (worldConfiguration != null);
        assert (dimension != null);
        worldConfiguration.getDimensionSettings(dimension).setNodeValue(this.getNode(), this.getNode().getDefaultValue(dimension, worldConfiguration));
        super.reset();
    }

    @Override
    public void onUpdate(@NotNull Dimension dimension, @NotNull WorldConfiguration worldConfiguration) {
        super.onUpdate(dimension, worldConfiguration);
        if (!this.getNode().validateValue(this.getValue(), dimension, worldConfiguration)) {
            worldConfiguration.getDimensionSettings(dimension).withNotificationsSuppressed(dimensionSettings -> dimensionSettings.setNodeValue(this.getNode(), this.getNode().getDefaultValue(dimension, worldConfiguration)));
        }
    }

    public boolean isDefault() {
        T currentValue;
        @Nullable WorldConfiguration worldConfiguration = this.getWorldConfiguration();
        @Nullable Dimension dimension = this.getDimension();
        assert (worldConfiguration != null);
        assert (dimension != null);
        @NotNull T defaultValue = this.getNode().getDefaultValue(dimension, worldConfiguration);
        return defaultValue == (currentValue = this.getValue()) || defaultValue.equals(currentValue) || currentValue.equals(defaultValue);
    }

    @Override
    public int getNestLevelContribution() {
        return 1;
    }

    @Override
    @NotNull
    public ValueSettingNode<T> getNode() {
        return (ValueSettingNode)super.getNode();
    }

    @NotNull
    public T getValue() {
        @Nullable WorldConfiguration worldConfiguration = this.getWorldConfiguration();
        @Nullable Dimension dimension = this.getDimension();
        assert (worldConfiguration != null);
        assert (dimension != null);
        @Nullable T value = worldConfiguration.getDimensionSettings(dimension).getNodeValue(this.getNode(), worldConfiguration);
        return (T)Objects.requireNonNullElseGet(value, () -> this.getNode().getDefaultValue(dimension, worldConfiguration));
    }

    @Override
    public int getBaseHeight() {
        return super.getBaseHeight() + 20 + 2;
    }

    @Override
    public void render(@NotNull ScreenPaged screen, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        @NotNull String translated = this.nameText.toString();
        int textColor = -1;
        if (relativeMouseX >= 0 && relativeMouseX <= width && relativeMouseY >= 2 && relativeMouseY <= this.getHeight() - 2) {
            textColor = -96;
        }
        ValueNodeComponent.MC.font.render(translated, x, y + this.getBaseHeight() / 2 - 4).setShadow().setColor(textColor).call();
        this.resetButton.enabled = !this.isDefault();
        this.renderResetButton(x, y, width - 100, 2, relativeMouseX, relativeMouseY);
        this.renderButton(x, y, width - 100, 2, 100, 20, relativeMouseX, relativeMouseY);
        int stringWidth = ValueNodeComponent.MC.font.stringWidth(translated);
        int lineMaxX = x + width - 100 - 8;
        if (this.resetButton.enabled) {
            lineMaxX -= 20;
        }
        this.drawRect(x + stringWidth + 8, y + this.getBaseHeight() / 2, lineMaxX, y + this.getBaseHeight() / 2 + 1, 0x5F7F7F7F);
        super.render(screen, x, y, width, relativeMouseX, relativeMouseY);
    }

    @Override
    public boolean onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (super.onMouseClick(mouseButton, x, y, width, relativeMouseX, relativeMouseY)) {
            return true;
        }
        if (relativeMouseX >= width - 100 && relativeMouseX <= width && relativeMouseY >= 2 && relativeMouseY <= 22) {
            ValueNodeComponent.MC.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
            this.buttonClicked(mouseButton, x, y, width, this.getHeight(), relativeMouseX - (width - 100), relativeMouseY - 2);
            return true;
        }
        if (this.resetButton.enabled && relativeMouseX >= width - 100 - 20 && relativeMouseX <= width - 100 && relativeMouseY >= 2 && relativeMouseY <= 22) {
            ValueNodeComponent.MC.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
            this.reset();
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (!super.onMouseMove(x, y, width, relativeMouseX, relativeMouseY)) {
            this.buttonDragged(x, y, width, this.getHeight(), relativeMouseX - (width - 100), relativeMouseY - 2);
        }
        return true;
    }

    @Override
    public boolean onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (!super.onMouseRelease(mouseButton, x, y, width, relativeMouseX, relativeMouseY)) {
            this.buttonReleased(mouseButton, x, y, width, this.getHeight(), relativeMouseX - (width - 100), relativeMouseY - 2);
        }
        return true;
    }

    protected abstract boolean buttonClicked(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected void buttonDragged(int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
    }

    protected void buttonReleased(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public boolean matchesSearchTerm(@NotNull String term) {
        return this.nameText.toString().toLowerCase().contains(term.toLowerCase());
    }

    private void renderResetButton(int x, int y, int relativeButtonX, int relativeButtonY, int relativeMouseX, int relativeMouseY) {
        if (this.resetButton.enabled) {
            this.resetButton.xPosition = x + relativeButtonX - 20;
            this.resetButton.yPosition = y + relativeButtonY;
            this.resetButton.drawButton(MC, x + relativeMouseX, y + relativeMouseY);
        }
    }

    private void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        this.renderButtonInner(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        if (relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            assert (ValueNodeComponent.MC.currentScreen != null);
            ValueNodeComponent.MC.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
    }

    protected abstract void renderButtonInner(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);
}

