/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader.framebuffer;

import net.minecraft.client.render.shader.framebuffer.FrameBuffer;
import net.minecraft.client.render.shader.framebuffer.FrameBufferAttachment;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2ic;
import org.lwjgl.opengl.GL41;

public abstract class RenderBuffer
implements FrameBufferAttachment {
    private final int id = GL41.glGenRenderbuffers();
    private final int attachment;
    @NotNull
    private final Vector2ic size;
    private boolean deleted = false;

    public RenderBuffer(int format, int attachment, @NotNull Vector2ic size, int samples) {
        this.attachment = attachment;
        this.size = size;
        this.whileBound(() -> this.init(format, size, samples));
    }

    @Override
    public int getId() {
        if (this.deleted) {
            throw new IllegalStateException("Render buffer deleted!");
        }
        return this.id;
    }

    @Override
    @NotNull
    public Vector2ic getSize() {
        if (this.deleted) {
            throw new IllegalStateException("Render buffer deleted!");
        }
        return this.size;
    }

    @Override
    public void delete() {
        if (this.deleted) {
            throw new IllegalStateException("Render buffer already deleted!");
        }
        GL41.glDeleteRenderbuffers(this.id);
        this.deleted = true;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void whileBound(@NotNull Runnable runnable) {
        if (this.deleted) {
            throw new IllegalStateException("Render buffer deleted!");
        }
        GL41.glBindRenderbuffer(36161, this.id);
        runnable.run();
        GL41.glBindRenderbuffer(36161, 0);
    }

    @Override
    public void attachToFramebuffer(@NotNull FrameBuffer frameBuffer) {
        frameBuffer.whileBound(() -> GL41.glFramebufferRenderbuffer(36160, this.attachment, 36161, this.id));
    }

    @Override
    public int getAttachment() {
        return this.attachment;
    }

    @Override
    public void bindForOutput() {
        throw new IllegalStateException("Render buffers cannot be bound for output!");
    }

    @Override
    public void unbindForOutput() {
        throw new IllegalStateException("Render buffers cannot be unbound for output!");
    }

    protected abstract void init(int var1, @NotNull Vector2ic var2, int var3);
}

