/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Objects;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityChest;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class BlockLogicChestLegacy
extends BlockLogic {
    public BlockLogicChestLegacy(@NotNull Block<?> block) {
        super(block, Materials.WOOD);
        block.withEntity(TileEntityChest::new);
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            return new ItemStack[]{new ItemStack(Blocks.CHEST_PLANKS_OAK)};
        }
        return null;
    }

    public static boolean isLegacyChest(@NotNull World world, @NotNull TilePosc tilePos) {
        @Nullable Block<?> block = world.getBlockType(tilePos);
        return block == Blocks.CHEST_LEGACY || block == Blocks.CHEST_LEGACY_PAINTED;
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        @Nullable TileEntity entity = world.getTileEntity(tilePos);
        if (entity != null) {
            entity.dropContents(world, tilePos.x(), tilePos.y(), tilePos.z());
        }
        super.onRemoved(world, tilePos, data);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (world.isClientSide) {
            return true;
        }
        if (BlockLogicChestLegacy.isLegacyChest(world, tilePos)) {
            this.updateLegacyChest(world, tilePos);
        }
        return Objects.requireNonNull(world.getBlockType(tilePos)).onInteracted(world, tilePos, player, side, xHit, yHit);
    }

    private void updateLegacyChest(@NotNull World world, @NotNull TilePosc tilePos) {
        @NotNull Direction facingDirection = Direction.SOUTH;
        Direction otherChestDirection = null;
        TilePos queryPos = new TilePos();
        if (BlockLogicChestLegacy.isLegacyChest(world, tilePos.east(queryPos))) {
            otherChestDirection = Direction.EAST;
        }
        if (BlockLogicChestLegacy.isLegacyChest(world, tilePos.west(queryPos))) {
            otherChestDirection = Direction.WEST;
        }
        if (BlockLogicChestLegacy.isLegacyChest(world, tilePos.south(queryPos))) {
            otherChestDirection = Direction.SOUTH;
        }
        if (BlockLogicChestLegacy.isLegacyChest(world, tilePos.north(queryPos))) {
            otherChestDirection = Direction.NORTH;
        }
        if (otherChestDirection == null) {
            int meta = world.getBlockData(tilePos);
            if (world.isBlockOpaqueCube(tilePos.east(queryPos)) && !world.isBlockOpaqueCube(tilePos.west(queryPos))) {
                facingDirection = Direction.WEST;
            }
            if (world.isBlockOpaqueCube(tilePos.west(queryPos)) && !world.isBlockOpaqueCube(tilePos.east(queryPos))) {
                facingDirection = Direction.EAST;
            }
            if (world.isBlockOpaqueCube(tilePos.south(queryPos)) && !world.isBlockOpaqueCube(tilePos.north(queryPos))) {
                facingDirection = Direction.NORTH;
            }
            if (world.isBlockOpaqueCube(tilePos.north(queryPos)) && !world.isBlockOpaqueCube(tilePos.south(queryPos))) {
                facingDirection = Direction.SOUTH;
            }
            meta = BlockLogicChest.getMetaWithDirection(meta, facingDirection);
            meta = BlockLogicChest.getMetaWithType(meta, BlockLogicChest.Type.SINGLE);
            @NotNull ItemStack @NotNull [] items = this.getAndClearChestInventory(world, tilePos);
            this.updateChestBlock(world, tilePos, meta);
            this.setChestInventory(world, tilePos, items);
        } else {
            @NotNull TilePos otherChest = new TilePos(tilePos);
            if (otherChestDirection == Direction.NORTH) {
                --otherChest.z;
            }
            if (otherChestDirection == Direction.SOUTH) {
                ++otherChest.z;
            }
            if (otherChestDirection == Direction.EAST) {
                ++otherChest.x;
            }
            if (otherChestDirection == Direction.WEST) {
                --otherChest.x;
            }
            int meta = world.getBlockData(tilePos);
            int otherMeta = world.getBlockData(otherChest);
            if (otherChestDirection == Direction.NORTH) {
                facingDirection = Direction.EAST;
                if (world.isBlockOpaqueCube(tilePos.east(queryPos)) || world.isBlockOpaqueCube(tilePos.east(queryPos).north(queryPos))) {
                    facingDirection = Direction.WEST;
                }
            }
            if (otherChestDirection == Direction.SOUTH) {
                facingDirection = Direction.EAST;
                if (world.isBlockOpaqueCube(tilePos.east(queryPos)) || world.isBlockOpaqueCube(tilePos.east(queryPos).south(queryPos))) {
                    facingDirection = Direction.WEST;
                }
            }
            if (otherChestDirection == Direction.EAST) {
                facingDirection = Direction.SOUTH;
                if (world.isBlockOpaqueCube(tilePos.south(queryPos)) || world.isBlockOpaqueCube(tilePos.east(queryPos).south(queryPos))) {
                    facingDirection = Direction.NORTH;
                }
            }
            if (otherChestDirection == Direction.WEST) {
                facingDirection = Direction.SOUTH;
                if (world.isBlockOpaqueCube(tilePos.south(queryPos)) || world.isBlockOpaqueCube(tilePos.west(queryPos).south(queryPos))) {
                    facingDirection = Direction.NORTH;
                }
            }
            @NotNull BlockLogicChest.Type type = BlockLogicChest.Type.SINGLE;
            if (facingDirection == Direction.NORTH && otherChestDirection == Direction.EAST) {
                type = BlockLogicChest.Type.RIGHT;
            }
            if (facingDirection == Direction.NORTH && otherChestDirection == Direction.WEST) {
                type = BlockLogicChest.Type.LEFT;
            }
            if (facingDirection == Direction.EAST && otherChestDirection == Direction.NORTH) {
                type = BlockLogicChest.Type.LEFT;
            }
            if (facingDirection == Direction.EAST && otherChestDirection == Direction.SOUTH) {
                type = BlockLogicChest.Type.RIGHT;
            }
            if (facingDirection == Direction.SOUTH && otherChestDirection == Direction.EAST) {
                type = BlockLogicChest.Type.LEFT;
            }
            if (facingDirection == Direction.SOUTH && otherChestDirection == Direction.WEST) {
                type = BlockLogicChest.Type.RIGHT;
            }
            if (facingDirection == Direction.WEST && otherChestDirection == Direction.NORTH) {
                type = BlockLogicChest.Type.RIGHT;
            }
            if (facingDirection == Direction.WEST && otherChestDirection == Direction.SOUTH) {
                type = BlockLogicChest.Type.LEFT;
            }
            @NotNull BlockLogicChest.Type otherType = BlockLogicChest.Type.SINGLE;
            if (type == BlockLogicChest.Type.LEFT) {
                otherType = BlockLogicChest.Type.RIGHT;
            }
            if (type == BlockLogicChest.Type.RIGHT) {
                otherType = BlockLogicChest.Type.LEFT;
            }
            meta = BlockLogicChest.getMetaWithDirection(meta, facingDirection);
            meta = BlockLogicChest.getMetaWithType(meta, type);
            otherMeta = BlockLogicChest.getMetaWithDirection(otherMeta, facingDirection);
            otherMeta = BlockLogicChest.getMetaWithType(otherMeta, otherType);
            @NotNull ItemStack @NotNull [] items1 = this.getAndClearChestInventory(world, tilePos);
            @NotNull ItemStack @NotNull [] items2 = this.getAndClearChestInventory(world, otherChest);
            this.updateChestBlock(world, tilePos, meta);
            this.updateChestBlock(world, otherChest, otherMeta);
            if (facingDirection == Direction.NORTH || facingDirection == Direction.EAST) {
                this.setChestInventory(world, tilePos, items2);
                this.setChestInventory(world, otherChest, items1);
            } else {
                this.setChestInventory(world, tilePos, items1);
                this.setChestInventory(world, otherChest, items2);
            }
        }
    }

    @NotNull
    private @NotNull ItemStack @NotNull [] getAndClearChestInventory(@NotNull World world, @NotNull TilePosc tilePos) {
        @NotNull TileEntityChest tileEntityChest = (TileEntityChest)Objects.requireNonNull(world.getTileEntity(tilePos));
        ItemStack[] items = new ItemStack[tileEntityChest.getContainerSize()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = tileEntityChest.getItem(i);
            tileEntityChest.setItem(i, null);
        }
        return items;
    }

    private void setChestInventory(@NotNull World world, @NotNull TilePosc tilePos, @NotNull @NotNull ItemStack @NotNull [] items) {
        @NotNull TileEntityChest tileEntityChest = (TileEntityChest)Objects.requireNonNull(world.getTileEntity(tilePos));
        for (int i = 0; i < items.length; ++i) {
            tileEntityChest.setItem(i, items[i]);
        }
    }

    private void updateChestBlock(@NotNull World world, @NotNull TilePosc tilePos, int newMeta) {
        if (!BlockLogicChestLegacy.isLegacyChest(world, tilePos)) {
            if (Global.BUILD_CHANNEL.isUnstableBuild()) {
                throw new RuntimeException("Not a Legacy Chest: X: " + tilePos.x() + " Y: " + tilePos.y() + " Z: " + tilePos.z());
            }
            return;
        }
        int legacyChestMeta = world.getBlockData(tilePos);
        @Nullable Block<?> oldBlock = world.getBlockType(tilePos);
        @NotNull Block<BlockLogicChest> newBlock = Blocks.CHEST_PLANKS_OAK;
        if (oldBlock == Blocks.CHEST_LEGACY_PAINTED) {
            newBlock = Blocks.CHEST_PLANKS_OAK_PAINTED;
            newMeta |= legacyChestMeta << 4;
        }
        world.setBlockTypeData(tilePos, newBlock, newMeta);
        world.markBlockNeedsUpdate(tilePos);
    }
}

