/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockLogicFullyRotatable
extends BlockLogic {
    public static final int MASK_DIRECTION = 7;

    public BlockLogicFullyRotatable(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        Direction direction = mob.getPlacementDirection(side).getOpposite();
        world.setBlockDataNotify(tilePos, BlockLogicFullyRotatable.directionToMeta(direction));
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        world.setBlockDataNotify(tilePos, BlockLogicFullyRotatable.directionToMeta(side.getDirection()));
    }

    public static int directionToMeta(Direction direction) {
        return direction.getId() & 7;
    }

    @NotNull
    public static Direction metaToDirection(int data) {
        return Direction.getDirectionById(data & 7);
    }
}

