#version 410 core
out vec4 FragColor;

in vec4 Color;
in vec2 UV;
in vec2 TexCoord;
in vec2 Lightmap;
in vec2 Size;
in float Config;

uniform float uAlphaTest;
uniform vec4 uColor;

uniform sampler2D colortex;
uniform sampler2D lighttex;

bool sampleInside(vec2 tex) {
    vec2 max = UV + (Size/128);
    return tex.x > UV.x && tex.y > UV.y && tex.x < max.x && tex.y < max.y;
}

vec4 colorAtPoint(vec2 point) {
    uint config = uint(Config + 0.01);
    vec4 tint = texture(lighttex, Lightmap) * uColor;

    vec4 color = vec4(0, 0, 0, 0);
    if (sampleInside(point)) {
        color = texture(colortex, point) * Color * tint;
    }
    vec2 left = point - vec2(1, 0)/128;
    if ((config & 0x08u) != 0 && sampleInside(left) && length(color) == 0) {
        color = texture(colortex, left) * Color * tint;
    }
    vec2 max = UV + (Size/128);
    if ((config & 0x02u) != 0 && point.y > max.y && point.y < (max.y + 1.0/128)) {
        color = Color * tint;
    }
    vec2 mid = UV + Size/256;
    if ((config & 0x04u) != 0 && point.y > (mid.y - 1.0/128) && point.y < mid.y) {
        color = Color * tint;
    }

    return color;
}


bool canReplace(vec2 tex) {
    return length(colorAtPoint(tex)) != 0;
}


void main() {
    uint config = uint(Config + 0.01);
    vec4 tint = texture(lighttex, Lightmap) * uColor;
    FragColor = colorAtPoint(TexCoord);
    if (length(FragColor) == 0) {
        if ((config & 0x20u) != 0) {
            vec2 upLeft = TexCoord + vec2(-1, -1)/128;
            vec2 up = TexCoord + vec2(0, -1)/128;
            vec2 upRight = TexCoord + vec2(1, -1)/128;
            vec2 left = TexCoord + vec2(-1, 0)/128;
            vec2 right = TexCoord + vec2(1, 0)/128;
            vec2 downLeft = TexCoord + vec2(-1, 1)/128;
            vec2 down = TexCoord + vec2(0, 1)/128;
            vec2 downRight = TexCoord + vec2(1, 1)/128;
            if (canReplace(upLeft) || canReplace(up) || canReplace(upRight) || canReplace(left) || canReplace(right) || canReplace(downLeft) || canReplace(down) || canReplace(downRight)) {
                FragColor = vec4(Color.rgb/4, Color.a) * tint;
            }
        } else if ((config & 0x80u) != 0) {
            vec2 upLeft = TexCoord - vec2(1, 1)/128;
            if (canReplace(upLeft)) {
                FragColor = vec4(Color.rgb/4, Color.a) * tint;
            }
        }
    }
    if (FragColor.a < uAlphaTest) {
        discard;
    }
}