#version 330 core
layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

#define EXPAND_POS 1.0005
#define EXPAND_UV 0.995

in VS_OUT {
    vec3 sourcePos;
    vec3 sourceColor;
    vec3 sourceNormal;

    vec2 V1UV;
    vec2 V1LightShade;

    vec3 V2PosOffset;
    vec2 V2UV;
    vec2 V2LightShade;

    vec3 V3PosOffset;
    vec2 V3UV;
    vec2 V3LightShade;

    vec3 V4PosOffset;
    vec2 V4UV;
    vec2 V4LightShade;
} gs_in[];

out vec4 Color;
out float Shade;
out vec2 TexCoord;
out vec2 LightMapCoord;
out vec3 Light;
out vec4 Norm;

uniform mat4 model;
layout (std140) uniform Matrices {
    mat4 projection;
    mat4 projectionInv;
    mat4 view;
    mat4 viewInv;
} matrices;

uniform mat4 normalTransform;
uniform vec4 lightModelAmbient;
uniform vec4 lightSourcePosition1;
uniform vec4 lightSourcePosition2;
uniform vec4 lightSourceDiffuse1;
uniform vec4 lightSourceDiffuse2;

vec2 unpackLightCoord(vec2 lightShade) {
    int asInt = int(lightShade.y);
    return vec2(((asInt & 0xF) + 0.5)/16.0, (((asInt & 0xF0) >> 4) + 0.5)/16.0);
}

float unpackShade(vec2 lightShade) {
    return lightShade.x/256;
}

vec3 expand(vec3 source, vec3 center, float expandAmount) {
    vec3 diff = source - center;
    return center + diff * expandAmount;
}

vec2 expand(vec2 source, vec2 center, float expandAmount) {
    vec2 diff = source - center;
    return center + diff * expandAmount;
}

void main() {
    Norm = normalize(normalTransform * model * vec4(gs_in[0].sourceNormal, 0));
    float dir1 = max(0.0, dot(Norm, lightSourcePosition1));
    float dir2 = max(0.0, dot(Norm, lightSourcePosition2));
    Light = (lightModelAmbient + lightSourceDiffuse1 * (dir1 + dir2)).xyz;

    vec3 posCenter = gs_in[0].sourcePos + (gs_in[0].V2PosOffset + gs_in[0].V3PosOffset + gs_in[0].V4PosOffset)/3;
    vec2 uvCenter = (gs_in[0].V1UV + gs_in[0].V2UV + gs_in[0].V3UV + gs_in[0].V4UV)/4;

    Color = vec4(gs_in[0].sourceColor, 1);
    Shade = unpackShade(gs_in[0].V1LightShade);
    TexCoord = expand(gs_in[0].V1UV, uvCenter, EXPAND_UV);
    LightMapCoord = unpackLightCoord(gs_in[0].V1LightShade);
    gl_Position = matrices.projection * matrices.view * model * vec4(expand(gs_in[0].sourcePos, posCenter, EXPAND_POS), 1);
    EmitVertex();

    Color = vec4(gs_in[0].sourceColor, 1);
    Shade = unpackShade(gs_in[0].V2LightShade);
    TexCoord = expand(gs_in[0].V2UV, uvCenter, EXPAND_UV);
    LightMapCoord = unpackLightCoord(gs_in[0].V2LightShade);
    gl_Position = matrices.projection * matrices.view * model * vec4(expand(gs_in[0].sourcePos + gs_in[0].V2PosOffset, posCenter, EXPAND_POS), 1);
    EmitVertex();

    Color = vec4(gs_in[0].sourceColor, 1);
    Shade = unpackShade(gs_in[0].V4LightShade);
    TexCoord = expand(gs_in[0].V4UV, uvCenter, EXPAND_UV);
    LightMapCoord = unpackLightCoord(gs_in[0].V4LightShade);
    gl_Position = matrices.projection * matrices.view * model * vec4(expand(gs_in[0].sourcePos + gs_in[0].V4PosOffset, posCenter, EXPAND_POS), 1);
    EmitVertex();

    Color = vec4(gs_in[0].sourceColor, 1);
    Shade = unpackShade(gs_in[0].V3LightShade);
    TexCoord = expand(gs_in[0].V3UV, uvCenter, EXPAND_UV);
    LightMapCoord = unpackLightCoord(gs_in[0].V3LightShade);
    gl_Position = matrices.projection * matrices.view * model * vec4(expand(gs_in[0].sourcePos + gs_in[0].V3PosOffset, posCenter, EXPAND_POS), 1);
    EmitVertex();

    EndPrimitive();
}