/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings.settingnode;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.paged.ScreenPaged;
import net.minecraft.client.gui.worldsettings.NodeComponent;
import net.minecraft.client.gui.worldsettings.settingnode.conversion.NodeAdapterRegistry;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.settings.SettingNode;
import net.minecraft.core.world.settings.SettingNodeChildrenProvider;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestedNodeComponent
implements NodeComponent {
    @NotNull
    protected static final Minecraft MC = Minecraft.getMinecraft();
    protected static final int COMPONENT_SPACING = 2;
    private static final int NEST_LEFT_MARGIN = 16;
    private final int nestLevel;
    @NotNull
    private final SettingNode node;
    @NotNull
    private final @NotNull List<@NotNull NodeComponent> components = new ArrayList<NodeComponent>();
    @Nullable
    private Dimension dimension = null;
    @Nullable
    private WorldConfiguration worldConfiguration = null;
    @Nullable
    private NodeComponent clickedComponent = null;
    private int clickedComponentY = 0;

    public NestedNodeComponent(@NotNull SettingNode node, int nestLevel) {
        this.node = node;
        this.nestLevel = nestLevel;
    }

    @Nullable
    protected Dimension getDimension() {
        return this.dimension;
    }

    @Nullable
    protected WorldConfiguration getWorldConfiguration() {
        return this.worldConfiguration;
    }

    @Override
    public void reset() {
        for (NodeComponent component : this.components) {
            component.reset();
        }
    }

    @Override
    public int getNestLevel() {
        return this.nestLevel;
    }

    @Override
    public void onUpdate(@NotNull Dimension dimension, @NotNull WorldConfiguration worldConfiguration) {
        this.dimension = dimension;
        this.worldConfiguration = worldConfiguration;
        this.components.clear();
        @Nullable SettingNodeChildrenProvider childrenProvider = this.node.getChildrenProvider();
        if (childrenProvider != null && this.getNode().areChildrenVisible(this.dimension, this.worldConfiguration)) {
            for (SettingNode child : childrenProvider) {
                if (!child.isVisible(dimension, worldConfiguration)) continue;
                @NotNull C childComponent = NodeAdapterRegistry.adapt(child, this.nestLevel + this.getNestLevelContribution());
                childComponent.onUpdate(dimension, worldConfiguration);
                this.components.add((NodeComponent)childComponent);
            }
        }
    }

    @Override
    @NotNull
    public SettingNode getNode() {
        return this.node;
    }

    public int getNestLevelContribution() {
        return 0;
    }

    public int getBaseHeight() {
        return 2;
    }

    @Override
    public void tick() {
        for (NodeComponent child : this.components) {
            child.tick();
        }
    }

    @Override
    public int getHeight() {
        int height = this.getBaseHeight();
        for (NodeComponent component : this.components) {
            height += component.getHeight();
        }
        return height;
    }

    @Override
    public void render(@NotNull ScreenPaged screen, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        int childrenHeight = this.getHeight() - this.getBaseHeight();
        if (childrenHeight > 0) {
            int alpha = 128 * (this.nestLevel + this.getNestLevelContribution());
            if (alpha > 255) {
                alpha = 255;
            }
            if (alpha > 0) {
                this.drawRect(x - 16 * (this.nestLevel + this.getNestLevelContribution()), y + this.getBaseHeight(), x + width + 16, y + this.getBaseHeight() + childrenHeight, alpha <<= 24);
            }
        }
        int componentY = this.getBaseHeight();
        for (NodeComponent component : this.components) {
            if (y + componentY + component.getHeight() >= screen.top() && y + componentY <= screen.bottom()) {
                component.render(screen, x + 16 * component.getNestLevel(), y + componentY, width - 16 * component.getNestLevel(), relativeMouseX - 16 * component.getNestLevel(), relativeMouseY - componentY);
            }
            componentY += component.getHeight();
        }
    }

    @Override
    public boolean onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        int componentY = this.getBaseHeight();
        for (NodeComponent component : this.components) {
            if (relativeMouseX >= 16 * component.getNestLevel() && relativeMouseX < width && relativeMouseY >= componentY && relativeMouseY < componentY + component.getHeight()) {
                component.onMouseClick(mouseButton, x + 16 * component.getNestLevel(), componentY, width - 16 * component.getNestLevel(), relativeMouseX - 16 * component.getNestLevel(), relativeMouseY - componentY);
                this.clickedComponent = component;
                this.clickedComponentY = componentY;
                return true;
            }
            componentY += component.getHeight();
        }
        this.clickedComponent = null;
        return false;
    }

    @Override
    public boolean onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (this.clickedComponent != null) {
            this.clickedComponent.onMouseMove(x + 16 * this.clickedComponent.getNestLevel(), this.clickedComponentY, width - 16 * this.clickedComponent.getNestLevel(), relativeMouseX - 16 * this.clickedComponent.getNestLevel(), relativeMouseY - this.clickedComponentY);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (this.clickedComponent != null) {
            this.clickedComponent.onMouseRelease(mouseButton, x + 16 * this.clickedComponent.getNestLevel(), this.clickedComponentY, width - 16 * this.clickedComponent.getNestLevel(), relativeMouseX - 16 * this.clickedComponent.getNestLevel(), relativeMouseY - this.clickedComponentY);
            this.clickedComponent = null;
            return true;
        }
        return false;
    }

    @Override
    public void onKeyPress(int keyCode, char character) {
        for (NodeComponent component : this.components) {
            component.onKeyPress(keyCode, character);
        }
    }

    @Override
    public void onClose() {
        for (NodeComponent component : this.components) {
            component.onClose();
        }
    }

    @Override
    public boolean matchesSearchTerm(String term) {
        return false;
    }

    protected void drawRect(int minX, int minY, int maxX, int maxY, int argb) {
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.COLOR);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        TessellatorShader tessellator = GLRenderer.getTessellator();
        tessellator.startDrawingQuads();
        tessellator.setColor2i(argb & 0xFFFFFF, argb >> 24 & 0xFF);
        tessellator.addVertex(minX, maxY, 0.0);
        tessellator.addVertex(maxX, maxY, 0.0);
        tessellator.addVertex(maxX, minY, 0.0);
        tessellator.addVertex(minX, minY, 0.0);
        tessellator.draw();
        GLRenderer.popFrame();
    }
}

