/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelCrossedSquares;
import net.minecraft.client.render.block.model.BlockModelEmpty;
import net.minecraft.client.render.block.model.BlockModelFire;
import net.minecraft.client.render.block.model.BlockModelFluid;
import net.minecraft.client.render.block.model.BlockModelGlass;
import net.minecraft.client.render.block.model.BlockModelRail;
import net.minecraft.client.render.block.model.BlockModelSignPainted;
import net.minecraft.client.render.block.model.BlockModelWireRedstone;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.block.model.generic.BlockModelGenericActivator;
import net.minecraft.client.render.block.model.generic.BlockModelGenericAxis;
import net.minecraft.client.render.block.model.generic.BlockModelGenericBasket;
import net.minecraft.client.render.block.model.generic.BlockModelGenericBed;
import net.minecraft.client.render.block.model.generic.BlockModelGenericBrazier;
import net.minecraft.client.render.block.model.generic.BlockModelGenericButton;
import net.minecraft.client.render.block.model.generic.BlockModelGenericButtonPainted;
import net.minecraft.client.render.block.model.generic.BlockModelGenericCake;
import net.minecraft.client.render.block.model.generic.BlockModelGenericChest;
import net.minecraft.client.render.block.model.generic.BlockModelGenericChestPainted;
import net.minecraft.client.render.block.model.generic.BlockModelGenericCropsPumpkin;
import net.minecraft.client.render.block.model.generic.BlockModelGenericCropsWheat;
import net.minecraft.client.render.block.model.generic.BlockModelGenericDoor;
import net.minecraft.client.render.block.model.generic.BlockModelGenericDoorPainted;
import net.minecraft.client.render.block.model.generic.BlockModelGenericFarmland;
import net.minecraft.client.render.block.model.generic.BlockModelGenericFence;
import net.minecraft.client.render.block.model.generic.BlockModelGenericFenceGate;
import net.minecraft.client.render.block.model.generic.BlockModelGenericFenceGatePainted;
import net.minecraft.client.render.block.model.generic.BlockModelGenericFencePainted;
import net.minecraft.client.render.block.model.generic.BlockModelGenericFenceThin;
import net.minecraft.client.render.block.model.generic.BlockModelGenericFlowerStackable;
import net.minecraft.client.render.block.model.generic.BlockModelGenericFullyRotatable;
import net.minecraft.client.render.block.model.generic.BlockModelGenericFurnace;
import net.minecraft.client.render.block.model.generic.BlockModelGenericGrass;
import net.minecraft.client.render.block.model.generic.BlockModelGenericJar;
import net.minecraft.client.render.block.model.generic.BlockModelGenericLamp;
import net.minecraft.client.render.block.model.generic.BlockModelGenericLantern;
import net.minecraft.client.render.block.model.generic.BlockModelGenericLayer;
import net.minecraft.client.render.block.model.generic.BlockModelGenericLeaves;
import net.minecraft.client.render.block.model.generic.BlockModelGenericLeavesCacao;
import net.minecraft.client.render.block.model.generic.BlockModelGenericLeavesCherryFlowering;
import net.minecraft.client.render.block.model.generic.BlockModelGenericLever;
import net.minecraft.client.render.block.model.generic.BlockModelGenericMatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGenericPebbles;
import net.minecraft.client.render.block.model.generic.BlockModelGenericPie;
import net.minecraft.client.render.block.model.generic.BlockModelGenericPiston;
import net.minecraft.client.render.block.model.generic.BlockModelGenericPistonHead;
import net.minecraft.client.render.block.model.generic.BlockModelGenericPlanksPainted;
import net.minecraft.client.render.block.model.generic.BlockModelGenericPortal;
import net.minecraft.client.render.block.model.generic.BlockModelGenericPressurePlate;
import net.minecraft.client.render.block.model.generic.BlockModelGenericPressurePlatePainted;
import net.minecraft.client.render.block.model.generic.BlockModelGenericRepeater;
import net.minecraft.client.render.block.model.generic.BlockModelGenericRope;
import net.minecraft.client.render.block.model.generic.BlockModelGenericRotatable;
import net.minecraft.client.render.block.model.generic.BlockModelGenericShifted;
import net.minecraft.client.render.block.model.generic.BlockModelGenericSlab;
import net.minecraft.client.render.block.model.generic.BlockModelGenericSlabPainted;
import net.minecraft.client.render.block.model.generic.BlockModelGenericSpikes;
import net.minecraft.client.render.block.model.generic.BlockModelGenericStairs;
import net.minecraft.client.render.block.model.generic.BlockModelGenericStairsPainted;
import net.minecraft.client.render.block.model.generic.BlockModelGenericTorch;
import net.minecraft.client.render.block.model.generic.BlockModelGenericTrapdoor;
import net.minecraft.client.render.block.model.generic.BlockModelGenericTrapdoorPainted;
import net.minecraft.client.render.block.model.generic.BlockModelGenericVeryRotatable;
import net.minecraft.client.render.block.model.generic.BlockModelGenericWool;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.util.dispatch.Dispatcher;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicBasket;
import net.minecraft.core.block.BlockLogicBed;
import net.minecraft.core.block.BlockLogicBrazier;
import net.minecraft.core.block.BlockLogicButtonPainted;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.block.BlockLogicChestLegacy;
import net.minecraft.core.block.BlockLogicDoor;
import net.minecraft.core.block.BlockLogicDoorPainted;
import net.minecraft.core.block.BlockLogicEdible;
import net.minecraft.core.block.BlockLogicFence;
import net.minecraft.core.block.BlockLogicFenceGate;
import net.minecraft.core.block.BlockLogicFenceGatePainted;
import net.minecraft.core.block.BlockLogicFencePainted;
import net.minecraft.core.block.BlockLogicFenceThin;
import net.minecraft.core.block.BlockLogicFire;
import net.minecraft.core.block.BlockLogicFireCold;
import net.minecraft.core.block.BlockLogicFlowerStackable;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.BlockLogicJukebox;
import net.minecraft.core.block.BlockLogicLadder;
import net.minecraft.core.block.BlockLogicLamp;
import net.minecraft.core.block.BlockLogicLayerAsh;
import net.minecraft.core.block.BlockLogicLayerBase;
import net.minecraft.core.block.BlockLogicLayerLeaves;
import net.minecraft.core.block.BlockLogicLayerSnow;
import net.minecraft.core.block.BlockLogicMotionSensor;
import net.minecraft.core.block.BlockLogicPlanksPainted;
import net.minecraft.core.block.BlockLogicPortal;
import net.minecraft.core.block.BlockLogicPressurePlatePainted;
import net.minecraft.core.block.BlockLogicRail;
import net.minecraft.core.block.BlockLogicRepeater;
import net.minecraft.core.block.BlockLogicRope;
import net.minecraft.core.block.BlockLogicSign;
import net.minecraft.core.block.BlockLogicSignPainted;
import net.minecraft.core.block.BlockLogicSlab;
import net.minecraft.core.block.BlockLogicSlabPainted;
import net.minecraft.core.block.BlockLogicStairs;
import net.minecraft.core.block.BlockLogicStairsPainted;
import net.minecraft.core.block.BlockLogicStatue;
import net.minecraft.core.block.BlockLogicTNT;
import net.minecraft.core.block.BlockLogicWireRedstone;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.piston.BlockLogicPistonBase;
import net.minecraft.core.block.piston.BlockLogicPistonHead;
import net.minecraft.core.block.piston.BlockLogicPistonMoving;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.useless.dragonfly.data.block.mojang.BlockModelMojangData;

public final class BlockModelDispatcher
extends Dispatcher<Block<?>, BlockModel<?>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static BlockModelDispatcher instance = new BlockModelDispatcher();
    public static BlockModelEmpty<?> modelEmpty = new BlockModelEmpty(null);

    public static BlockModelDispatcher getInstance() {
        return instance;
    }

    public void addDispatch(@NotNull BlockModel<?> model) {
        this.addDispatch(model.block, model);
    }

    @Override
    public void addDispatch(@NotNull Block<?> key, @NotNull BlockModel<?> value) {
        if (this.hasDispatch(key)) {
            throw new IllegalArgumentException("Block '" + String.valueOf(key) + "' already assigned a model!");
        }
        this.dispatches.put(key, value);
    }

    @Override
    protected BlockModel<?> getDefault() {
        return modelEmpty;
    }

    @NotNull
    public static BlockModelMojangData loadDataModel(@NotNull String id) {
        Minecraft mc = Minecraft.getMinecraft();
        BlockModelMojangData model = BlockModelMojangData.Cache.loadModelData(mc.texturePackList, id);
        if (model != null) {
            return model;
        }
        LOGGER.error("Could not find model for id '{}'!", (Object)id);
        return BlockModelMojangData.Cache.getMissingModel();
    }

    private BlockModelDispatcher() {
        instance = this;
        this.reload();
    }

    public void onWorldChanged(@NotNull World world) {
        for (BlockModel model : this.dispatches.values()) {
            model.onWorldChanged(world);
        }
    }

    public void reload() {
        BlockModelMojangData.Cache.resetCache();
        this.dispatches.clear();
        this.addDispatch(new BlockModelEmpty(Blocks.AIR));
        this.addDispatch(new BlockModelGeneric(Blocks.STONE, BlockModelDispatcher.loadDataModel("minecraft:block/stone")));
        this.addDispatch(new BlockModelGeneric(Blocks.BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/basalt")));
        this.addDispatch(new BlockModelGeneric(Blocks.LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/limestone")));
        this.addDispatch(new BlockModelGeneric(Blocks.GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/granite")));
        this.addDispatch(new BlockModelGeneric(Blocks.MARBLE, BlockModelDispatcher.loadDataModel("minecraft:block/marble")));
        this.addDispatch(new BlockModelGeneric(Blocks.SLATE, BlockModelDispatcher.loadDataModel("minecraft:block/slate")));
        this.addDispatch(new BlockModelGeneric(Blocks.PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/permafrost")));
        this.addDispatch(new BlockModelGeneric(Blocks.COBBLE_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/cobbled_stone")));
        this.addDispatch(new BlockModelGeneric(Blocks.COBBLE_STONE_MOSSY, BlockModelDispatcher.loadDataModel("minecraft:block/cobbled_stone_mossy")));
        this.addDispatch(new BlockModelGeneric(Blocks.COBBLE_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/cobbled_basalt")));
        this.addDispatch(new BlockModelGeneric(Blocks.COBBLE_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/cobbled_limestone")));
        this.addDispatch(new BlockModelGeneric(Blocks.COBBLE_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/cobbled_granite")));
        this.addDispatch(new BlockModelGeneric(Blocks.COBBLE_PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/cobbled_permafrost")));
        this.addDispatch(new BlockModelGeneric(Blocks.COBBLE_BASALT_MOSSY, BlockModelDispatcher.loadDataModel("minecraft:block/cobbled_basalt_mossy")));
        this.addDispatch(new BlockModelGeneric(Blocks.COBBLE_LIMESTONE_MOSSY, BlockModelDispatcher.loadDataModel("minecraft:block/cobbled_limestone_mossy")));
        this.addDispatch(new BlockModelGeneric(Blocks.COBBLE_GRANITE_MOSSY, BlockModelDispatcher.loadDataModel("minecraft:block/cobbled_granite_mossy")));
        this.addDispatch(new BlockModelGeneric(Blocks.STONE_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/polished_stone")));
        this.addDispatch(new BlockModelGeneric(Blocks.GRANITE_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/polished_granite")));
        this.addDispatch(new BlockModelGeneric(Blocks.LIMESTONE_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/polished_limestone")));
        this.addDispatch(new BlockModelGeneric(Blocks.BASALT_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/polished_basalt")));
        this.addDispatch(new BlockModelGeneric(Blocks.SLATE_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/polished_slate")));
        this.addDispatch(new BlockModelGeneric(Blocks.PERMAFROST_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/polished_permafrost")));
        this.addDispatch(new BlockModelGeneric(Blocks.NETHERRACK_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/polished_netherrack")));
        this.addDispatch(new BlockModelGenericAxis(Blocks.PILLAR_MARBLE, BlockModelDispatcher.loadDataModel("minecraft:block/pillar_marble")));
        this.addDispatch(new BlockModelGeneric(Blocks.CAPSTONE_MARBLE, BlockModelDispatcher.loadDataModel("minecraft:block/capstone_marble")));
        this.addDispatch(new BlockModelGeneric(Blocks.SANDSTONE, BlockModelDispatcher.loadDataModel("minecraft:block/sandstone")));
        this.addDispatch(new BlockModelGeneric(Blocks.STONE_CARVED, BlockModelDispatcher.loadDataModel("minecraft:block/carved_stone")));
        this.addDispatch(new BlockModelGeneric(Blocks.GRANITE_CARVED, BlockModelDispatcher.loadDataModel("minecraft:block/carved_granite")));
        this.addDispatch(new BlockModelGeneric(Blocks.LIMESTONE_CARVED, BlockModelDispatcher.loadDataModel("minecraft:block/carved_limestone")));
        this.addDispatch(new BlockModelGeneric(Blocks.BASALT_CARVED, BlockModelDispatcher.loadDataModel("minecraft:block/carved_basalt")));
        this.addDispatch(new BlockModelGeneric(Blocks.PERMAFROST_CARVED, BlockModelDispatcher.loadDataModel("minecraft:block/carved_permafrost")));
        this.addDispatch(new BlockModelGeneric(Blocks.NETHERRACK_CARVED, BlockModelDispatcher.loadDataModel("minecraft:block/carved_netherrack")));
        this.addDispatch(new BlockModelGeneric(Blocks.PLANKS_OAK, BlockModelDispatcher.loadDataModel("minecraft:block/planks/oak")));
        this.addDispatch(new BlockModelGenericPlanksPainted<BlockLogicPlanksPainted>(Blocks.PLANKS_OAK_PAINTED, BlockModelDispatcher.loadDataModel("minecraft:block/planks/white")));
        this.addDispatch(new BlockModelGenericTorch(Blocks.TORCH_COAL, "minecraft:block/torch_coal").render3D(false));
        this.addDispatch(new BlockModelGenericRotatable<BlockLogicLadder>(Blocks.LADDER_OAK, BlockModelDispatcher.loadDataModel("minecraft:block/ladder")).render3D(false));
        this.addDispatch(new BlockModelGenericFence<BlockLogicFence>(Blocks.FENCE_PLANKS_OAK, "minecraft:block/fence/oak"));
        this.addDispatch(new BlockModelGenericFencePainted<BlockLogicFencePainted>(Blocks.FENCE_PLANKS_OAK_PAINTED));
        this.addDispatch(new BlockModelGenericFenceGate<BlockLogicFenceGate>(Blocks.FENCE_GATE_PLANKS_OAK, "minecraft:block/fencegate/oak"));
        this.addDispatch(new BlockModelGenericFenceGatePainted<BlockLogicFenceGatePainted>(Blocks.FENCE_GATE_PLANKS_OAK_PAINTED));
        this.addDispatch(new BlockModelGeneric(Blocks.BOOKSHELF_PLANKS_OAK, BlockModelDispatcher.loadDataModel("minecraft:block/bookshelf")));
        this.addDispatch(new BlockModelGenericWool(Blocks.WOOL, BlockModelDispatcher.loadDataModel("minecraft:block/wool/white")));
        this.addDispatch(new BlockModelGenericRope<BlockLogicRope>(Blocks.ROPE));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_CLAY, BlockModelDispatcher.loadDataModel("minecraft:block/brick_clay")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_STONE_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/brick_stone_polished")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_STONE_POLISHED_MOSSY, BlockModelDispatcher.loadDataModel("minecraft:block/brick_stone_polished_mossy")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_SANDSTONE, BlockModelDispatcher.loadDataModel("minecraft:block/brick_sandstone")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_GOLD, BlockModelDispatcher.loadDataModel("minecraft:block/brick_gold")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_LAPIS, BlockModelDispatcher.loadDataModel("minecraft:block/brick_lapis")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/brick_basalt")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/brick_limestone")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/brick_granite")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_MARBLE, BlockModelDispatcher.loadDataModel("minecraft:block/brick_marble")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_SLATE, BlockModelDispatcher.loadDataModel("minecraft:block/brick_slate")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/brick_stone")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/brick_permafrost")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_IRON, BlockModelDispatcher.loadDataModel("minecraft:block/brick_iron")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_STEEL, BlockModelDispatcher.loadDataModel("minecraft:block/brick_steel")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_PLANKS_OAK, BlockModelDispatcher.loadDataModel("minecraft:block/slab/planks/oak/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/planks/oak/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/planks/oak/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_COBBLE_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_stone/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_stone/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_stone/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_SANDSTONE, BlockModelDispatcher.loadDataModel("minecraft:block/slab/sandstone/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/sandstone/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/sandstone/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_STONE_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_stone_polished/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_stone_polished/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_stone_polished/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_STONE_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_stone/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_stone/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_stone/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_MARBLE, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_marble/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_marble/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_marble/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_CLAY, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_clay/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_clay/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_clay/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_CAPSTONE_MARBLE, BlockModelDispatcher.loadDataModel("minecraft:block/slab/capstone_marble/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/capstone_marble/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/capstone_marble/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_COBBLE_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_basalt/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_basalt/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_basalt/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_COBBLE_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_limestone/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_limestone/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_limestone/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_COBBLE_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_granite/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_granite/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_granite/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_basalt/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_basalt/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_basalt/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_limestone/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_limestone/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_limestone/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_granite/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_granite/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_granite/full")));
        this.addDispatch(new BlockModelGenericSlabPainted<BlockLogicSlabPainted>(Blocks.SLAB_PLANKS_PAINTED));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_SLATE, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_slate/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_slate/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_slate/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_stone/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_stone/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_stone/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_GRANITE_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_granite/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_granite/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_granite/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_LIMESTONE_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_limestone/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_limestone/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_limestone/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BASALT_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_basalt/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_basalt/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_basalt/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_PERMAFROST_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_permafrost/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_permafrost/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_permafrost/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_COBBLE_PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_permafrost/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_permafrost/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_permafrost/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_SANDSTONE, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_sandstone/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_sandstone/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_sandstone/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_permafrost/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_permafrost/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_permafrost/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_IRON, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_iron/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_iron/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_iron/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_GOLD, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_gold/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_gold/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_gold/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_STEEL, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_steel/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_steel/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_steel/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_LAPIS, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_lapis/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_lapis/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_lapis/full")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_PLANKS_OAK, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/planks/oak")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_COBBLE_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/cobbled_stone")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_STONE_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_stone_polished")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_MARBLE, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_marble")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_COBBLE_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/cobbled_basalt")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_COBBLE_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/cobbled_limestone")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_COBBLE_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/cobbled_granite")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_basalt")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_limestone")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_granite")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_CLAY, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_clay")));
        this.addDispatch(new BlockModelGenericStairsPainted<BlockLogicStairsPainted>(Blocks.STAIRS_PLANKS_PAINTED));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_SLATE, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_slate")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_stone")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_SANDSTONE, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/sandstone")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_COBBLE_PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/cobbled_permafrost")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_SANDSTONE, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_sandstone")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_permafrost")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_IRON, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_iron")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_GOLD, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_gold")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_STEEL, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_steel")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_LAPIS, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_lapis")));
        this.addDispatch(new BlockModelGeneric(Blocks.OBSIDIAN, BlockModelDispatcher.loadDataModel("minecraft:block/obsidian")));
        this.addDispatch(new BlockModelGlass(Blocks.GLASS, "minecraft:block/glass/").setAllTextures("minecraft:block/glass"));
        this.addDispatch(new BlockModelGlass(Blocks.GLASS_TINTED, "minecraft:block/glass_tinted/").onRenderLayer(1).setAllTextures("minecraft:block/glass_tinted"));
        this.addDispatch(new BlockModelGeneric(Blocks.GLASS_STEEL, BlockModelDispatcher.loadDataModel("minecraft:block/glass_steel")).forceCullSelf(true));
        this.addDispatch(new BlockModelGenericGrass(Blocks.GRASS));
        this.addDispatch(new BlockModelGeneric(Blocks.GRASS_RETRO, BlockModelDispatcher.loadDataModel("minecraft:block/grass_retro")));
        this.addDispatch(new BlockModelGeneric(Blocks.GRASS_SCORCHED, BlockModelDispatcher.loadDataModel("minecraft:block/grass_scorched")));
        this.addDispatch(new BlockModelGeneric(Blocks.PATH_DIRT, BlockModelDispatcher.loadDataModel("minecraft:block/grass_path")));
        this.addDispatch(new BlockModelGeneric(Blocks.DIRT, BlockModelDispatcher.loadDataModel("minecraft:block/dirt")));
        this.addDispatch(new BlockModelGeneric(Blocks.DIRT_SCORCHED, BlockModelDispatcher.loadDataModel("minecraft:block/dirt_scorched")));
        this.addDispatch(new BlockModelGeneric(Blocks.DIRT_SCORCHED_RICH, BlockModelDispatcher.loadDataModel("minecraft:block/dirt_scorched_rich")));
        this.addDispatch(new BlockModelGeneric(Blocks.MUD, BlockModelDispatcher.loadDataModel("minecraft:block/mud")));
        this.addDispatch(new BlockModelGeneric(Blocks.MUD_BAKED, BlockModelDispatcher.loadDataModel("minecraft:block/mud_baked")));
        this.addDispatch(new BlockModelGeneric(Blocks.SPONGE_DRY, BlockModelDispatcher.loadDataModel("minecraft:block/sponge")));
        this.addDispatch(new BlockModelGeneric(Blocks.SPONGE_WET, BlockModelDispatcher.loadDataModel("minecraft:block/sponge_wet")));
        this.addDispatch(new BlockModelGeneric(Blocks.PUMICE_DRY, BlockModelDispatcher.loadDataModel("minecraft:block/pumice")));
        this.addDispatch(new BlockModelGeneric(Blocks.PUMICE_WET, BlockModelDispatcher.loadDataModel("minecraft:block/pumice_wet")));
        this.addDispatch(new BlockModelGeneric(Blocks.MOSS_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/moss/stone")));
        this.addDispatch(new BlockModelGeneric(Blocks.MOSS_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/moss/basalt")));
        this.addDispatch(new BlockModelGeneric(Blocks.MOSS_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/moss/limestone")));
        this.addDispatch(new BlockModelGeneric(Blocks.MOSS_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/moss/granite")));
        this.addDispatch(new BlockModelGeneric(Blocks.SAND, BlockModelDispatcher.loadDataModel("minecraft:block/sand")));
        this.addDispatch(new BlockModelGeneric(Blocks.GRAVEL, BlockModelDispatcher.loadDataModel("minecraft:block/gravel")));
        this.addDispatch(new BlockModelGeneric(Blocks.SULFUR, BlockModelDispatcher.loadDataModel("minecraft:block/sulfur")));
        this.addDispatch(new BlockModelGeneric(Blocks.BEDROCK, BlockModelDispatcher.loadDataModel("minecraft:block/bedrock")));
        this.addDispatch(new BlockModelGenericFullyRotatable(Blocks.BONESHALE, BlockModelDispatcher.loadDataModel("minecraft:block/bone_shale")));
        this.addDispatch(new BlockModelFluid<BlockLogicFluid>(Blocks.FLUID_WATER_FLOWING).onRenderLayer(1).setAllTextures("minecraft:block/water_flowing").setTex("minecraft:block/water_still", Side.TOP));
        this.addDispatch(new BlockModelFluid<BlockLogicFluid>(Blocks.FLUID_WATER_STILL).onRenderLayer(1).setTex("minecraft:block/water_still", Side.TOP, Side.BOTTOM).setTex("minecraft:block/water_flowing", Side.NORTH, Side.EAST, Side.SOUTH, Side.WEST));
        this.addDispatch(new BlockModelFluid<BlockLogicFluid>(Blocks.FLUID_LAVA_FLOWING).setAllTextures("minecraft:block/lava_flowing").setTex("minecraft:block/lava_still", Side.TOP));
        this.addDispatch(new BlockModelFluid<BlockLogicFluid>(Blocks.FLUID_LAVA_STILL).setTex("minecraft:block/lava_still", Side.TOP, Side.BOTTOM).setTex("minecraft:block/lava_flowing", Side.NORTH, Side.EAST, Side.SOUTH, Side.WEST));
        this.addDispatch(new BlockModelGenericAxis(Blocks.LOG_OAK, BlockModelDispatcher.loadDataModel("minecraft:block/log/oak")));
        this.addDispatch(new BlockModelGenericAxis(Blocks.LOG_PINE, BlockModelDispatcher.loadDataModel("minecraft:block/log/pine")));
        this.addDispatch(new BlockModelGenericAxis(Blocks.LOG_BIRCH, BlockModelDispatcher.loadDataModel("minecraft:block/log/birch")));
        this.addDispatch(new BlockModelGenericAxis(Blocks.LOG_CHERRY, BlockModelDispatcher.loadDataModel("minecraft:block/log/cherry")));
        this.addDispatch(new BlockModelGenericAxis(Blocks.LOG_EUCALYPTUS, BlockModelDispatcher.loadDataModel("minecraft:block/log/eucalyptus")));
        this.addDispatch(new BlockModelGenericAxis(Blocks.LOG_OAK_MOSSY, BlockModelDispatcher.loadDataModel("minecraft:block/log/oak_mossy")));
        this.addDispatch(new BlockModelGenericAxis(Blocks.LOG_THORN, BlockModelDispatcher.loadDataModel("minecraft:block/log/thorn")));
        this.addDispatch(new BlockModelGenericAxis(Blocks.LOG_PALM, BlockModelDispatcher.loadDataModel("minecraft:block/log/palm")));
        this.addDispatch(new BlockModelGenericLeaves(Blocks.LEAVES_OAK, "minecraft:block/leaves/oak"));
        this.addDispatch(new BlockModelGenericLeaves(Blocks.LEAVES_OAK_RETRO, "minecraft:block/leaves/oak_retro"));
        this.addDispatch(new BlockModelGenericLeaves(Blocks.LEAVES_PINE, "minecraft:block/leaves/pine"));
        this.addDispatch(new BlockModelGenericLeaves(Blocks.LEAVES_BIRCH, "minecraft:block/leaves/birch"));
        this.addDispatch(new BlockModelGenericLeaves(Blocks.LEAVES_CHERRY, "minecraft:block/leaves/cherry"));
        this.addDispatch(new BlockModelGenericLeaves(Blocks.LEAVES_EUCALYPTUS, "minecraft:block/leaves/eucalyptus"));
        this.addDispatch(new BlockModelGenericLeaves(Blocks.LEAVES_SHRUB, "minecraft:block/leaves/shrub"));
        this.addDispatch(new BlockModelGenericLeavesCherryFlowering(Blocks.LEAVES_CHERRY_FLOWERING));
        this.addDispatch(new BlockModelGenericLeavesCacao(Blocks.LEAVES_CACAO));
        this.addDispatch(new BlockModelGenericLeaves(Blocks.LEAVES_THORN, "minecraft:block/leaves/thorn"));
        this.addDispatch(new BlockModelGenericLeaves(Blocks.LEAVES_PALM, "minecraft:block/leaves/palm"));
        this.addDispatch(new BlockModelGeneric(Blocks.SAPLING_OAK, BlockModelDispatcher.loadDataModel("minecraft:block/sapling/oak")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.SAPLING_OAK_RETRO, BlockModelDispatcher.loadDataModel("minecraft:block/sapling/oak_retro")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.SAPLING_PINE, BlockModelDispatcher.loadDataModel("minecraft:block/sapling/pine")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.SAPLING_BIRCH, BlockModelDispatcher.loadDataModel("minecraft:block/sapling/birch")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.SAPLING_CHERRY, BlockModelDispatcher.loadDataModel("minecraft:block/sapling/cherry")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.SAPLING_EUCALYPTUS, BlockModelDispatcher.loadDataModel("minecraft:block/sapling/eucalyptus")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.SAPLING_SHRUB, BlockModelDispatcher.loadDataModel("minecraft:block/sapling/shrub")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.SAPLING_CACAO, BlockModelDispatcher.loadDataModel("minecraft:block/sapling/cacao")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.SAPLING_THORN, BlockModelDispatcher.loadDataModel("minecraft:block/sapling/thorn")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.SAPLING_PALM, BlockModelDispatcher.loadDataModel("minecraft:block/sapling/palm")).render3D(false));
        this.addDispatch(new BlockModelGenericShifted(Blocks.TALLGRASS, BlockModelDispatcher.loadDataModel("minecraft:block/tallgrass")).render3D(false));
        this.addDispatch(new BlockModelGenericShifted(Blocks.TALLGRASS_FERN, BlockModelDispatcher.loadDataModel("minecraft:block/fern")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.DEADBUSH, BlockModelDispatcher.loadDataModel("minecraft:block/deadbush")).render3D(false));
        this.addDispatch(new BlockModelGenericShifted(Blocks.SPINIFEX, BlockModelDispatcher.loadDataModel("minecraft:block/spinifex")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.ALGAE, BlockModelDispatcher.loadDataModel("minecraft:block/algae")).render3D(false));
        this.addDispatch(new BlockModelGenericFlowerStackable<BlockLogicFlowerStackable>(Blocks.FLOWER_YELLOW, "minecraft:block/flower_yellow/").render3D(false));
        this.addDispatch(new BlockModelGenericFlowerStackable<BlockLogicFlowerStackable>(Blocks.FLOWER_RED, "minecraft:block/flower_red/").render3D(false));
        this.addDispatch(new BlockModelGenericFlowerStackable<BlockLogicFlowerStackable>(Blocks.FLOWER_PINK, "minecraft:block/flower_pink/").render3D(false));
        this.addDispatch(new BlockModelGenericFlowerStackable<BlockLogicFlowerStackable>(Blocks.FLOWER_PURPLE, "minecraft:block/flower_purple/").render3D(false));
        this.addDispatch(new BlockModelGenericFlowerStackable<BlockLogicFlowerStackable>(Blocks.FLOWER_LIGHT_BLUE, "minecraft:block/flower_lightblue/").render3D(false));
        this.addDispatch(new BlockModelGenericFlowerStackable<BlockLogicFlowerStackable>(Blocks.FLOWER_ORANGE, "minecraft:block/flower_orange/").render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.MUSHROOM_BROWN, BlockModelDispatcher.loadDataModel("minecraft:block/mushroom_brown")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.MUSHROOM_RED, BlockModelDispatcher.loadDataModel("minecraft:block/mushroom_red")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_COAL_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/coal/stone")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_COAL_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/ore/coal/basalt")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_COAL_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/coal/limestone")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_COAL_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/coal/granite")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_COAL_PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/ore/coal/permafrost")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_IRON_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/iron/stone")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_IRON_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/ore/iron/basalt")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_IRON_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/iron/limestone")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_IRON_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/iron/granite")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_IRON_PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/ore/iron/permafrost")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_GOLD_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/gold/stone")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_GOLD_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/ore/gold/basalt")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_GOLD_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/gold/limestone")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_GOLD_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/gold/granite")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_GOLD_PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/ore/gold/permafrost")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_LAPIS_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/lapis/stone")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_LAPIS_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/ore/lapis/basalt")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_LAPIS_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/lapis/limestone")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_LAPIS_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/lapis/granite")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_LAPIS_PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/ore/lapis/permafrost")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_REDSTONE_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/redstone/stone")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_REDSTONE_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/ore/redstone/basalt")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_REDSTONE_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/redstone/limestone")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_REDSTONE_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/redstone/granite")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_REDSTONE_PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/ore/redstone/permafrost")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_REDSTONE_GLOWING_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/redstone/stone_active")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_REDSTONE_GLOWING_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/ore/redstone/basalt_active")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_REDSTONE_GLOWING_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/redstone/limestone_active")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_REDSTONE_GLOWING_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/redstone/granite_active")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_REDSTONE_GLOWING_PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/ore/redstone/permafrost_active")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_DIAMOND_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/diamond/stone")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_DIAMOND_BASALT, BlockModelDispatcher.loadDataModel("minecraft:block/ore/diamond/basalt")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_DIAMOND_LIMESTONE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/diamond/limestone")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_DIAMOND_GRANITE, BlockModelDispatcher.loadDataModel("minecraft:block/ore/diamond/granite")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_DIAMOND_PERMAFROST, BlockModelDispatcher.loadDataModel("minecraft:block/ore/diamond/permafrost")));
        this.addDispatch(new BlockModelGeneric(Blocks.CRYSTAL, BlockModelDispatcher.loadDataModel("minecraft:block/nether_crystal/crystal")));
        this.addDispatch(new BlockModelGeneric(Blocks.CRYSTAL_STALK, BlockModelDispatcher.loadDataModel("minecraft:block/nether_crystal/stalk")).render3D(false));
        this.addDispatch(new BlockModelGeneric(Blocks.NETHERRACK_CRYSTALLINE, BlockModelDispatcher.loadDataModel("minecraft:block/nether_crystal/crystal_netherrack")));
        this.addDispatch(new BlockModelGeneric(Blocks.ORE_NETHERCOAL_NETHERRACK, BlockModelDispatcher.loadDataModel("minecraft:block/ore/nethercoal/netherrack")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_COAL, BlockModelDispatcher.loadDataModel("minecraft:block/block_coal")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_IRON, BlockModelDispatcher.loadDataModel("minecraft:block/block_iron")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_GOLD, BlockModelDispatcher.loadDataModel("minecraft:block/block_gold")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_LAPIS, BlockModelDispatcher.loadDataModel("minecraft:block/block_lapis")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_REDSTONE, BlockModelDispatcher.loadDataModel("minecraft:block/block_redstone")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_DIAMOND, BlockModelDispatcher.loadDataModel("minecraft:block/block_diamond")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_NETHER_COAL, BlockModelDispatcher.loadDataModel("minecraft:block/block_nethercoal")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_STEEL, BlockModelDispatcher.loadDataModel("minecraft:block/block_steel")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_QUARTZ, BlockModelDispatcher.loadDataModel("minecraft:block/block_quartz")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_OLIVINE, BlockModelDispatcher.loadDataModel("minecraft:block/block_olivine")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_CHARCOAL, BlockModelDispatcher.loadDataModel("minecraft:block/block_charcoal")));
        this.addDispatch(new BlockModelWireRedstone<BlockLogicWireRedstone>(Blocks.WIRE_REDSTONE));
        this.addDispatch(new BlockModelGenericTorch(Blocks.TORCH_REDSTONE_IDLE, "minecraft:block/torch_redstone_idle").render3D(false));
        this.addDispatch(new BlockModelGenericTorch(Blocks.TORCH_REDSTONE_ACTIVE, "minecraft:block/torch_redstone_active").render3D(false));
        this.addDispatch(new BlockModelGenericButton(Blocks.BUTTON_STONE, "minecraft:block/button/stone"));
        this.addDispatch(new BlockModelGenericButton(Blocks.BUTTON_PLANKS, "minecraft:block/button/planks/oak"));
        this.addDispatch(new BlockModelGenericButtonPainted<BlockLogicButtonPainted>(Blocks.BUTTON_PLANKS_PAINTED));
        this.addDispatch(new BlockModelGenericLever(Blocks.LEVER_COBBLE_STONE).render3D(false));
        this.addDispatch(new BlockModelGenericPressurePlate(Blocks.PRESSURE_PLATE_STONE, "minecraft:block/pressure_plate/stone"));
        this.addDispatch(new BlockModelGenericPressurePlate(Blocks.PRESSURE_PLATE_PLANKS_OAK, "minecraft:block/pressure_plate/planks/oak"));
        this.addDispatch(new BlockModelGenericPressurePlate(Blocks.PRESSURE_PLATE_COBBLE_STONE, "minecraft:block/pressure_plate/cobbled_stone"));
        this.addDispatch(new BlockModelGenericPressurePlatePainted<BlockLogicPressurePlatePainted>(Blocks.PRESSURE_PLATE_PLANKS_OAK_PAINTED));
        this.addDispatch(new BlockModelGenericVeryRotatable<BlockLogicMotionSensor>(Blocks.MOTION_SENSOR_IDLE, BlockModelDispatcher.loadDataModel("minecraft:block/motion_sensor_idle")));
        this.addDispatch(new BlockModelGenericVeryRotatable<BlockLogicMotionSensor>(Blocks.MOTION_SENSOR_ACTIVE, BlockModelDispatcher.loadDataModel("minecraft:block/motion_sensor_active")));
        this.addDispatch(new BlockModelGenericRepeater<BlockLogicRepeater>(Blocks.REPEATER_IDLE));
        this.addDispatch(new BlockModelGenericRepeater<BlockLogicRepeater>(Blocks.REPEATER_ACTIVE));
        this.addDispatch(new BlockModelGenericPiston<BlockLogicPistonBase>(Blocks.PISTON_BASE, BlockModelDispatcher.loadDataModel("minecraft:block/piston/base"), BlockModelDispatcher.loadDataModel("minecraft:block/piston/extended")));
        this.addDispatch(new BlockModelGenericPiston<BlockLogicPistonBase>(Blocks.PISTON_BASE_STICKY, BlockModelDispatcher.loadDataModel("minecraft:block/piston_sticky/base"), BlockModelDispatcher.loadDataModel("minecraft:block/piston_sticky/extended")));
        this.addDispatch(new BlockModelGenericPiston<BlockLogicPistonBase>(Blocks.PISTON_BASE_STEEL, BlockModelDispatcher.loadDataModel("minecraft:block/piston_steel/base"), BlockModelDispatcher.loadDataModel("minecraft:block/piston_steel/extended")));
        this.addDispatch(new BlockModelEmpty<BlockLogicPistonMoving>(Blocks.PISTON_MOVING).setAllTextures((IconCoordinate)null));
        this.addDispatch(new BlockModelGenericPistonHead<BlockLogicPistonHead>(Blocks.PISTON_HEAD, BlockModelDispatcher.loadDataModel("minecraft:block/piston/head"), BlockModelDispatcher.loadDataModel("minecraft:block/piston_sticky/head"), BlockModelDispatcher.loadDataModel("minecraft:block/piston_steel/head"), BlockModelDispatcher.loadDataModel("minecraft:block/piston/head_half"), BlockModelDispatcher.loadDataModel("minecraft:block/piston_sticky/head_half"), BlockModelDispatcher.loadDataModel("minecraft:block/piston_steel/head_half")));
        this.addDispatch(new BlockModelGenericPistonHead<BlockLogicPistonHead>(Blocks.PISTON_HEAD_STEEL, BlockModelDispatcher.loadDataModel("minecraft:block/piston/head"), BlockModelDispatcher.loadDataModel("minecraft:block/piston_sticky/head"), BlockModelDispatcher.loadDataModel("minecraft:block/piston_steel/head"), BlockModelDispatcher.loadDataModel("minecraft:block/piston/head_half"), BlockModelDispatcher.loadDataModel("minecraft:block/piston_sticky/head_half"), BlockModelDispatcher.loadDataModel("minecraft:block/piston_steel/head_half")));
        this.addDispatch(new BlockModelGeneric(Blocks.NOTEBLOCK, BlockModelDispatcher.loadDataModel("minecraft:block/noteblock")));
        this.addDispatch(new BlockModelRail<BlockLogicRail>(Blocks.RAIL).setAllTextures("minecraft:block/rail/straight"));
        this.addDispatch(new BlockModelRail<BlockLogicRail>(Blocks.RAIL_POWERED).setAllTextures("minecraft:block/rail_powered/idle"));
        this.addDispatch(new BlockModelRail<BlockLogicRail>(Blocks.RAIL_DETECTOR).setAllTextures("minecraft:block/rail_detector/straight"));
        this.addDispatch(new BlockModelGenericSpikes(Blocks.SPIKES).render3D(false));
        this.addDispatch(new BlockModelGenericVeryRotatable(Blocks.DISPENSER_COBBLE_STONE, BlockModelDispatcher.loadDataModel("minecraft:block/dispenser")));
        this.addDispatch(new BlockModelGenericActivator(Blocks.ACTIVATOR_COBBLE_NETHERRACK));
        this.addDispatch(new BlockModelGenericTrapdoor(Blocks.TRAPDOOR_PLANKS_OAK, "minecraft:block/trapdoor/planks/oak"));
        this.addDispatch(new BlockModelGenericTrapdoor(Blocks.TRAPDOOR_IRON, "minecraft:block/trapdoor/iron"));
        this.addDispatch(new BlockModelGenericTrapdoor(Blocks.TRAPDOOR_GLASS, "minecraft:block/trapdoor/glass"));
        this.addDispatch(new BlockModelGenericTrapdoorPainted(Blocks.TRAPDOOR_PLANKS_PAINTED));
        this.addDispatch(new BlockModelGenericTrapdoor(Blocks.TRAPDOOR_STEEL, "minecraft:block/trapdoor/steel"));
        this.addDispatch(new BlockModelGeneric<BlockLogicTNT>(Blocks.TNT, BlockModelDispatcher.loadDataModel("minecraft:block/tnt")));
        this.addDispatch(new BlockModelGenericDoor<BlockLogicDoor>(Blocks.DOOR_PLANKS_OAK_BOTTOM, "minecraft:block/door/planks/oak", true));
        this.addDispatch(new BlockModelGenericDoor<BlockLogicDoor>(Blocks.DOOR_PLANKS_OAK_TOP, "minecraft:block/door/planks/oak", false));
        this.addDispatch(new BlockModelGenericDoor<BlockLogicDoor>(Blocks.DOOR_IRON_BOTTOM, "minecraft:block/door/iron", true));
        this.addDispatch(new BlockModelGenericDoor<BlockLogicDoor>(Blocks.DOOR_IRON_TOP, "minecraft:block/door/iron", false));
        this.addDispatch(new BlockModelGenericDoorPainted<BlockLogicDoorPainted>(Blocks.DOOR_PLANKS_PAINTED_BOTTOM, true));
        this.addDispatch(new BlockModelGenericDoorPainted<BlockLogicDoorPainted>(Blocks.DOOR_PLANKS_PAINTED_TOP, false));
        this.addDispatch(new BlockModelGenericDoor<BlockLogicDoor>(Blocks.DOOR_GLASS_BOTTOM, "minecraft:block/door/glass", true));
        this.addDispatch(new BlockModelGenericDoor<BlockLogicDoor>(Blocks.DOOR_GLASS_TOP, "minecraft:block/door/glass", false));
        this.addDispatch(new BlockModelGenericDoor<BlockLogicDoor>(Blocks.DOOR_STEEL_BOTTOM, "minecraft:block/door/steel", true));
        this.addDispatch(new BlockModelGenericDoor<BlockLogicDoor>(Blocks.DOOR_STEEL_TOP, "minecraft:block/door/steel", false));
        this.addDispatch(new BlockModelGeneric(Blocks.MESH, BlockModelDispatcher.loadDataModel("minecraft:block/mesh")));
        this.addDispatch(new BlockModelGeneric(Blocks.MESH_GOLD, BlockModelDispatcher.loadDataModel("minecraft:block/mesh_gold")));
        this.addDispatch(new BlockModelGenericBed<BlockLogicBed>(Blocks.BED));
        this.addDispatch(new BlockModelGeneric(Blocks.SEAT, BlockModelDispatcher.loadDataModel("minecraft:block/seat")));
        this.addDispatch(new BlockModelCrossedSquares(Blocks.COBWEB).setAllTextures("minecraft:block/cobweb"));
        this.addDispatch(new BlockModelFire<BlockLogicFire>(Blocks.FIRE).setAllTextures("minecraft:block/fire"));
        this.addDispatch(new BlockModelGeneric<BlockLogicBrazier>(Blocks.BRAZIER_INACTIVE, BlockModelDispatcher.loadDataModel("minecraft:block/brazier")));
        this.addDispatch(new BlockModelGenericBrazier<BlockLogicBrazier>(Blocks.BRAZIER_ACTIVE, BlockModelDispatcher.loadDataModel("minecraft:block/brazier")));
        this.addDispatch(new BlockModelFire<BlockLogicFireCold>(Blocks.FIRE_COLD).setAllTextures("minecraft:block/fire_cold"));
        this.addDispatch(new BlockModelGeneric(Blocks.MOBSPAWNER, BlockModelDispatcher.loadDataModel("minecraft:block/mobspawner")));
        this.addDispatch(new BlockModelGeneric(Blocks.MOBSPAWNER_DEACTIVATED, BlockModelDispatcher.loadDataModel("minecraft:block/mobspawner_deactivated")));
        this.addDispatch(new BlockModelGeneric(Blocks.WORKBENCH, BlockModelDispatcher.loadDataModel("minecraft:block/workbench")));
        this.addDispatch(new BlockModelGenericFurnace(Blocks.FURNACE_STONE_IDLE, "minecraft:block/furnace_stone/idle"));
        this.addDispatch(new BlockModelGenericFurnace(Blocks.FURNACE_STONE_ACTIVE, "minecraft:block/furnace_stone/active"));
        this.addDispatch(new BlockModelGenericFurnace(Blocks.FURNACE_BLAST_IDLE, "minecraft:block/furnace_blast/idle"));
        this.addDispatch(new BlockModelGenericFurnace(Blocks.FURNACE_BLAST_ACTIVE, "minecraft:block/furnace_blast/active"));
        this.addDispatch(new BlockModelGenericRotatable(Blocks.TROMMEL_IDLE, BlockModelDispatcher.loadDataModel("minecraft:block/trommel")));
        this.addDispatch(new BlockModelGenericRotatable(Blocks.TROMMEL_ACTIVE, BlockModelDispatcher.loadDataModel("minecraft:block/trommel_active")));
        this.addDispatch(new BlockModelGeneric<BlockLogicChestLegacy>(Blocks.CHEST_LEGACY, BlockModelDispatcher.loadDataModel("minecraft:block/chest/legacy")));
        this.addDispatch(new BlockModelGeneric<BlockLogicChestLegacy>(Blocks.CHEST_LEGACY_PAINTED, BlockModelDispatcher.loadDataModel("minecraft:block/chest/legacy")));
        this.addDispatch(new BlockModelGenericChest<BlockLogicChest>(Blocks.CHEST_PLANKS_OAK, BlockModelDispatcher.loadDataModel("minecraft:block/chest/single/planks"), BlockModelDispatcher.loadDataModel("minecraft:block/chest/left/planks"), BlockModelDispatcher.loadDataModel("minecraft:block/chest/right/planks")));
        this.addDispatch(new BlockModelGenericChestPainted<BlockLogicChest>(Blocks.CHEST_PLANKS_OAK_PAINTED));
        this.addDispatch(new BlockModelGenericCropsWheat(Blocks.CROPS_WHEAT));
        this.addDispatch(new BlockModelGenericCropsPumpkin(Blocks.CROPS_PUMPKIN));
        this.addDispatch(new BlockModelGenericFarmland(Blocks.FARMLAND_DIRT));
        this.addDispatch(new BlockModelEmpty<BlockLogicSign>(Blocks.SIGN_POST_PLANKS_OAK).setAllTextures("minecraft:block/planks/oak"));
        this.addDispatch(new BlockModelEmpty<BlockLogicSign>(Blocks.SIGN_WALL_PLANKS_OAK).setAllTextures("minecraft:block/planks/oak"));
        this.addDispatch(new BlockModelEmpty(Blocks.FLAG).setAllTextures("minecraft:block/planks/oak"));
        this.addDispatch(new BlockModelSignPainted<BlockLogicSignPainted>(Blocks.SIGN_POST_PLANKS_OAK_PAINTED).setAllTextures("minecraft:block/planks/oak"));
        this.addDispatch(new BlockModelSignPainted<BlockLogicSignPainted>(Blocks.SIGN_WALL_PLANKS_OAK_PAINTED).setAllTextures("minecraft:block/planks/oak"));
        this.addDispatch(new BlockModelGenericLayer<BlockLogicLayerSnow>(Blocks.LAYER_SNOW, "minecraft:block/layer/snow"));
        this.addDispatch(new BlockModelGenericLayer<BlockLogicLayerLeaves>(Blocks.LAYER_LEAVES_OAK, "minecraft:block/layer/leaves_oak"));
        this.addDispatch(new BlockModelGenericLayer<BlockLogicLayerBase>(Blocks.LAYER_SLATE, "minecraft:block/layer/slate"));
        this.addDispatch(new BlockModelGenericLayer<BlockLogicLayerAsh>(Blocks.LAYER_ASH, "minecraft:block/layer/ash"));
        this.addDispatch(new BlockModelGeneric(Blocks.ICE, BlockModelDispatcher.loadDataModel("minecraft:block/ice")).forceCullSelf(true));
        this.addDispatch(new BlockModelGeneric(Blocks.PERMAICE, BlockModelDispatcher.loadDataModel("minecraft:block/permaice")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_SNOW, BlockModelDispatcher.loadDataModel("minecraft:block/block_snow")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_ASH, BlockModelDispatcher.loadDataModel("minecraft:block/block_ash")));
        this.addDispatch(new BlockModelGeneric(Blocks.CACTUS, BlockModelDispatcher.loadDataModel("minecraft:block/cactus")));
        this.addDispatch(new BlockModelGeneric(Blocks.BLOCK_CLAY, BlockModelDispatcher.loadDataModel("minecraft:block/block_clay")));
        this.addDispatch(new BlockModelGeneric(Blocks.SUGARCANE, BlockModelDispatcher.loadDataModel("minecraft:block/sugarcane")));
        this.addDispatch(new BlockModelGenericAxis(Blocks.BLOCK_SUGARCANE, BlockModelDispatcher.loadDataModel("minecraft:block/block_sugarcane")));
        this.addDispatch(new BlockModelGenericAxis(Blocks.BLOCK_SUGARCANE_BAKED, BlockModelDispatcher.loadDataModel("minecraft:block/block_baked_sugarcane")));
        this.addDispatch(new BlockModelGeneric<BlockLogicJukebox>(Blocks.JUKEBOX, BlockModelDispatcher.loadDataModel("minecraft:block/jukebox")));
        this.addDispatch(new BlockModelGeneric(Blocks.PUMPKIN, BlockModelDispatcher.loadDataModel("minecraft:block/pumpkin")));
        this.addDispatch(new BlockModelGenericVeryRotatable(Blocks.PUMPKIN_CARVED_IDLE, BlockModelDispatcher.loadDataModel("minecraft:block/pumpkin_carved")));
        this.addDispatch(new BlockModelGenericVeryRotatable(Blocks.PUMPKIN_CARVED_ACTIVE, BlockModelDispatcher.loadDataModel("minecraft:block/pumpkin_carved_lit")));
        this.addDispatch(new BlockModelGenericVeryRotatable(Blocks.PUMPKIN_REDSTONE, BlockModelDispatcher.loadDataModel("minecraft:block/pumpkin_redstone")));
        this.addDispatch(new BlockModelGeneric(Blocks.COBBLE_NETHERRACK, BlockModelDispatcher.loadDataModel("minecraft:block/cobbled_netherrack/normal")));
        this.addDispatch(new BlockModelGeneric(Blocks.COBBLE_NETHERRACK_IGNEOUS, BlockModelDispatcher.loadDataModel("minecraft:block/cobbled_netherrack/igneous")));
        this.addDispatch(new BlockModelGeneric(Blocks.COBBLE_NETHERRACK_MOSSY, BlockModelDispatcher.loadDataModel("minecraft:block/cobbled_netherrack/mossy")));
        this.addDispatch(new BlockModelGeneric(Blocks.NETHERRACK, BlockModelDispatcher.loadDataModel("minecraft:block/netherrack")));
        this.addDispatch(new BlockModelGeneric(Blocks.BRICK_NETHERRACK, BlockModelDispatcher.loadDataModel("minecraft:block/brick_netherrack")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_NETHERRACK_POLISHED, BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_netherrack/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_netherrack/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/polished_netherrack/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_COBBLE_NETHERRACK, BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_netherrack/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_netherrack/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/cobbled_netherrack/full")));
        this.addDispatch(new BlockModelGenericSlab<BlockLogicSlab>(Blocks.SLAB_BRICK_NETHERRACK, BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_netherrack/lower"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_netherrack/upper"), BlockModelDispatcher.loadDataModel("minecraft:block/slab/brick_netherrack/full")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_COBBLE_NETHERRACK, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/cobbled_netherrack")));
        this.addDispatch(new BlockModelGenericStairs<BlockLogicStairs>(Blocks.STAIRS_BRICK_NETHERRACK, BlockModelDispatcher.loadDataModel("minecraft:block/stairs/brick_netherrack")));
        this.addDispatch(new BlockModelGeneric(Blocks.SOULSAND, BlockModelDispatcher.loadDataModel("minecraft:block/soulsand")));
        this.addDispatch(new BlockModelGeneric(Blocks.SOULSCHIST, BlockModelDispatcher.loadDataModel("minecraft:block/soulschist")));
        this.addDispatch(new BlockModelGeneric(Blocks.GLOWSTONE, BlockModelDispatcher.loadDataModel("minecraft:block/glowstone")));
        this.addDispatch(new BlockModelGenericPortal<BlockLogicPortal>(Blocks.PORTAL_NETHER, "minecraft:block/portal_nether/"));
        this.addDispatch(new BlockModelGenericPortal<BlockLogicPortal>(Blocks.PORTAL_DRIFT, "minecraft:block/portal_drift/"));
        this.addDispatch(new BlockModelGenericCake(Blocks.CAKE));
        this.addDispatch(new BlockModelGenericPie<BlockLogicEdible>(Blocks.PUMPKIN_PIE));
        this.addDispatch(new BlockModelGenericLamp<BlockLogicLamp>(Blocks.LAMP_IDLE, "minecraft:block/lamp/idle/%s", "minecraft:block/lamp/active/%s"));
        this.addDispatch(new BlockModelGenericLamp<BlockLogicLamp>(Blocks.LAMP_ACTIVE, "minecraft:block/lamp/active/%s", "minecraft:block/lamp/active/%s"));
        this.addDispatch(new BlockModelGenericLamp<BlockLogicLamp>(Blocks.LAMP_INVERTED_IDLE, "minecraft:block/lamp/idle_inverted/%s", "minecraft:block/lamp/active_inverted/%s"));
        this.addDispatch(new BlockModelGenericLamp<BlockLogicLamp>(Blocks.LAMP_INVERTED_ACTIVE, "minecraft:block/lamp/active_inverted/%s", "minecraft:block/lamp/active_inverted/%s"));
        this.addDispatch(new BlockModelGenericLantern(Blocks.LANTERN_FIREFLY_GREEN, BlockModelDispatcher.loadDataModel("minecraft:block/lantern_firefly/green"), BlockModelDispatcher.loadDataModel("minecraft:block/lantern_firefly/green_hanging")));
        this.addDispatch(new BlockModelGenericLantern(Blocks.LANTERN_FIREFLY_BLUE, BlockModelDispatcher.loadDataModel("minecraft:block/lantern_firefly/blue"), BlockModelDispatcher.loadDataModel("minecraft:block/lantern_firefly/blue_hanging")));
        this.addDispatch(new BlockModelGenericLantern(Blocks.LANTERN_FIREFLY_ORANGE, BlockModelDispatcher.loadDataModel("minecraft:block/lantern_firefly/orange"), BlockModelDispatcher.loadDataModel("minecraft:block/lantern_firefly/orange_hanging")));
        this.addDispatch(new BlockModelGenericLantern(Blocks.LANTERN_FIREFLY_RED, BlockModelDispatcher.loadDataModel("minecraft:block/lantern_firefly/red"), BlockModelDispatcher.loadDataModel("minecraft:block/lantern_firefly/red_hanging")));
        this.addDispatch(new BlockModelGenericJar(Blocks.JAR_GLASS));
        this.addDispatch(new BlockModelGenericLantern(Blocks.JAR_BUTTERFLY_BLUE, BlockModelDispatcher.loadDataModel("minecraft:block/jar_butterfly"), BlockModelDispatcher.loadDataModel("minecraft:block/jar_butterfly_hanging")));
        this.addDispatch(new BlockModelGenericLantern(Blocks.JAR_BUTTERFLY_ORANGE, BlockModelDispatcher.loadDataModel("minecraft:block/jar_butterfly"), BlockModelDispatcher.loadDataModel("minecraft:block/jar_butterfly_hanging")));
        this.addDispatch(new BlockModelGenericLantern(Blocks.JAR_BUTTERFLY_PINK, BlockModelDispatcher.loadDataModel("minecraft:block/jar_butterfly"), BlockModelDispatcher.loadDataModel("minecraft:block/jar_butterfly_hanging")));
        this.addDispatch(new BlockModelGenericLantern(Blocks.JAR_BUTTERFLY_SILVER, BlockModelDispatcher.loadDataModel("minecraft:block/jar_butterfly"), BlockModelDispatcher.loadDataModel("minecraft:block/jar_butterfly_hanging")));
        this.addDispatch(new BlockModelGenericPebbles(Blocks.OVERLAY_PEBBLES));
        this.addDispatch(new BlockModelGenericFenceThin<BlockLogicFenceThin>(Blocks.FENCE_CHAINLINK, "minecraft:block/fence_thin/chain"));
        this.addDispatch(new BlockModelGenericFenceThin<BlockLogicFenceThin>(Blocks.FENCE_PAPER_WALL, "minecraft:block/fence_thin/paper"));
        this.addDispatch(new BlockModelGenericFenceThin<BlockLogicFenceThin>(Blocks.FENCE_STEEL, "minecraft:block/fence_thin/steel"));
        this.addDispatch(new BlockModelGenericBasket<BlockLogicBasket>(Blocks.BASKET));
        this.addDispatch(new BlockModelGeneric(Blocks.PAPER_WALL, BlockModelDispatcher.loadDataModel("minecraft:block/paperwall")));
        this.addDispatch(new BlockModelEmpty<BlockLogicStatue>(Blocks.STATUE_STONE_LOWER).setAllTextures("minecraft:block/stone"));
        this.addDispatch(new BlockModelEmpty<BlockLogicStatue>(Blocks.STATUE_STONE_UPPER).setAllTextures("minecraft:block/stone"));
        this.addDispatch(new BlockModelEmpty<BlockLogicStatue>(Blocks.STATUE_BASALT_LOWER).setAllTextures("minecraft:block/basalt"));
        this.addDispatch(new BlockModelEmpty<BlockLogicStatue>(Blocks.STATUE_BASALT_UPPER).setAllTextures("minecraft:block/basalt"));
        this.addDispatch(new BlockModelEmpty<BlockLogicStatue>(Blocks.STATUE_LIMESTONE_LOWER).setAllTextures("minecraft:block/limestone"));
        this.addDispatch(new BlockModelEmpty<BlockLogicStatue>(Blocks.STATUE_LIMESTONE_UPPER).setAllTextures("minecraft:block/limestone"));
        this.addDispatch(new BlockModelEmpty<BlockLogicStatue>(Blocks.STATUE_GRANITE_LOWER).setAllTextures("minecraft:block/granite"));
        this.addDispatch(new BlockModelEmpty<BlockLogicStatue>(Blocks.STATUE_GRANITE_UPPER).setAllTextures("minecraft:block/granite"));
        this.addDispatch(new BlockModelEmpty<BlockLogicStatue>(Blocks.STATUE_MARBLE_LOWER).setAllTextures("minecraft:block/marble"));
        this.addDispatch(new BlockModelEmpty<BlockLogicStatue>(Blocks.STATUE_MARBLE_UPPER).setAllTextures("minecraft:block/marble"));
        this.addDispatch(new BlockModelEmpty<BlockLogicStatue>(Blocks.STATUE_PIGMAN_LOWER).setAllTextures("minecraft:block/marble"));
        this.addDispatch(new BlockModelEmpty<BlockLogicStatue>(Blocks.STATUE_PIGMAN_UPPER).setAllTextures("minecraft:block/marble"));
        this.addDispatch(new BlockModelGenericMatcher<BlockLogic>(Blocks.MATCHER, "minecraft:block/matcher/"));
        this.addDispatch(new BlockModelGenericMatcher<BlockLogic>(Blocks.MATCHER_ACTIVE, "minecraft:block/matcher/active"));
    }
}

