/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.entity.animal.MobSquid;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererSquid
extends MobRenderer<MobSquid> {
    public MobRendererSquid(float shadowSize) {
        super(shadowSize);
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull MobSquid entity, float brightness, float partialTick, int layer) {
        StaticEntityModel model = this.getModel("main");
        model.resetBones();
        float limbPitch = this.getLimbPitch(entity, partialTick);
        model.getTransform((String)"tentacle1").rotX = limbPitch;
        model.getTransform((String)"tentacle2").rotX = limbPitch;
        model.getTransform((String)"tentacle3").rotX = limbPitch;
        model.getTransform((String)"tentacle4").rotX = limbPitch;
        model.getTransform((String)"tentacle5").rotX = limbPitch;
        model.getTransform((String)"tentacle6").rotX = limbPitch;
        model.getTransform((String)"tentacle7").rotX = limbPitch;
        model.getTransform((String)"tentacle8").rotX = limbPitch;
        return model;
    }

    @Override
    protected float getLimbPitch(@NotNull MobSquid squid, float partialTick) {
        return MathHelper.lerp(squid.oldTentacleAngle, squid.tentacleAngle, partialTick);
    }

    @Override
    protected void preRenderTransform(@NotNull MobSquid entity, double x, double y, double z, float _yaw, float partialTick) {
        if (entity.isSpecial()) {
            GLRenderer.modelM4f().translate(0.0f, 1.5f, 0.0f);
            super.preRenderTransform(entity, x, y, z, _yaw, partialTick);
        } else {
            GLRenderer.modelM4f().translate((float)x, (float)(y + 0.5), (float)z);
            GLRenderer.modelM4f().scale(0.0625f, 0.0625f, 0.0625f);
            float pitch = entity.xBodyRotO + (entity.xBodyRot - entity.xBodyRotO) * partialTick;
            float yaw = entity.zBodyRotO + (entity.zBodyRot - entity.zBodyRotO) * partialTick;
            GLRenderer.modelM4f().rotateY((float)Math.PI - this.getBodyYaw(entity, partialTick));
            GLRenderer.modelM4f().rotateX(org.joml.Math.toRadians(pitch));
            GLRenderer.modelM4f().rotateY(org.joml.Math.toRadians(yaw));
        }
    }

    @Override
    public void renderPreview(@NotNull TessellatorGeneral tessellator, @NotNull MobSquid squid, double x, double y, double z, float yaw, float partialTick) {
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate(0.0f, 1.25f, 0.0f);
        super.renderPreview(tessellator, squid, x, y, z, yaw, partialTick);
        GLRenderer.popFrame();
    }
}

