/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.tessellator.RenderBuffer;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public interface Tessellator {
    public static final boolean QUAD_EMULATION = true;

    public void startDrawing(@NotNull DrawMode var1);

    default public void startDrawingQuads() {
        this.startDrawing(DrawMode.QUADS);
    }

    public void addVertex(double var1, double var3, double var5);

    default public void addVertex(@NotNull Vector3dc pos) {
        this.addVertex(pos.x(), pos.y(), pos.z());
    }

    default public void addVertex(@NotNull Vector3fc pos) {
        this.addVertex(pos.x(), pos.y(), pos.z());
    }

    public void setTranslation(double var1, double var3, double var5);

    default public void setTranslation(@NotNull Vector3dc pos) {
        this.setTranslation(pos.x(), pos.y(), pos.z());
    }

    default public void setTranslation(@NotNull Vector3fc pos) {
        this.setTranslation(pos.x(), pos.y(), pos.z());
    }

    public void offsetTranslation(double var1, double var3, double var5);

    default public void offsetTranslation(@NotNull Vector3dc pos) {
        this.offsetTranslation(pos.x(), pos.y(), pos.z());
    }

    default public void offsetTranslation(@NotNull Vector3fc pos) {
        this.offsetTranslation(pos.x(), pos.y(), pos.z());
    }

    default public void drawRectangle(int x, int y, int width, int height) {
        this.addVertex(x, y, 0.0);
        this.addVertex(x, y + height, 0.0);
        this.addVertex(x + width, y + height, 0.0);
        this.addVertex(x + width, y, 0.0);
    }

    public void draw();

    @NotNull
    public RenderBuffer record(int var1, int var2);
}

