/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import com.mojang.logging.LogUtils;
import net.minecraft.core.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class MissingBlockFixer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final short @NotNull [] BLOCKS_ARRAY = new short[Blocks.blocksList.length];

    public static void fixMissingBlocks(short @NotNull [] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = BLOCKS_ARRAY[blocks[i] & 0x3FFF];
        }
    }

    private MissingBlockFixer() {
    }

    static {
        try {
            for (int i = 0; i < Blocks.blocksList.length; ++i) {
                short id = (short)i;
                if (Blocks.blocksList[id & 0x3FFF] == null) {
                    id = (short)Blocks.AIR.id();
                }
                MissingBlockFixer.BLOCKS_ARRAY[i] = id;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Exception initializing blocksArray!", exception);
        }
    }
}

