/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.EntityFallingBlock;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockLogicSand
extends BlockLogic {
    public static boolean fallInstantly = false;

    public BlockLogicSand(@NotNull Block<?> block) {
        super(block, Materials.SAND);
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        world.scheduleBlockUpdate(tilePos, this.block, this.tickDelay());
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        world.scheduleBlockUpdate(tilePos, this.block, this.tickDelay());
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        this.tryToFall(world, tilePos);
    }

    private void tryToFall(@NotNull World world, @NotNull TilePosc tilePos) {
        TilePos queryPos = new TilePos();
        if (BlockLogicSand.canFallBelow(world, tilePos.down(queryPos)) && tilePos.y() >= 0) {
            int radius = 32;
            if (fallInstantly || !world.areBlocksLoaded((TilePosc)tilePos.add(-radius, -radius, -radius, new TilePos()), tilePos.add(radius, radius, radius, new TilePos()))) {
                world.setBlockTypeNotify(tilePos, Blocks.AIR);
                @NotNull TilePos check = tilePos.down(new TilePos());
                while (BlockLogicSand.canFallBelow(world, check) && check.y > 0) {
                    check.down();
                }
                if (check.y > 0) {
                    world.setBlockTypeNotify(check, this.block);
                }
            } else {
                EntityFallingBlock entityFallingBlock = new EntityFallingBlock(world, (double)tilePos.x() + 0.5, (double)tilePos.y() + 0.5, (double)tilePos.z() + 0.5, this.block.id(), 0, null);
                world.entityJoinedWorld(entityFallingBlock);
            }
        }
    }

    @Override
    public int tickDelay() {
        return 3;
    }

    public static boolean canFallBelow(@NotNull World world, @NotNull TilePos tilePos) {
        Block<?> block = world.getBlockType(tilePos);
        return block == null || block.hasTag(BlockTags.PLACE_OVERWRITES);
    }
}

