/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityStatue;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicStatue
extends BlockLogic {
    private final boolean isBottom;
    public final @Nullable Supplier<@NotNull Item> droppedItem;

    public BlockLogicStatue(@NotNull Block<?> block, @NotNull Material material, boolean isBottom, @Nullable Supplier<@NotNull Item> droppedItem) {
        super(block, material);
        this.isBottom = isBottom;
        this.droppedItem = droppedItem;
        if (isBottom) {
            block.withEntity(TileEntityStatue::new);
        }
        float bottom = this.isBottom ? 0.0f : -1.0f;
        float top = this.isBottom ? 2.0f : 1.0f;
        this.setBlockBounds(0.0, bottom, 0.0, 1.0, top, 1.0);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        boolean shouldInsertArmor;
        @Nullable TileEntityStatue statueEntity = this.getTileEntity(world, tilePos);
        if (statueEntity == null) {
            return false;
        }
        if (player.isSneaking()) {
            statueEntity.nextPose();
            world.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, (double)tilePos.x() + 0.5, (double)tilePos.y() + 0.5, (double)tilePos.z() + 0.5, "random.scrape", 0.7f, 0.2f + world.rand.nextFloat() * 0.4f);
            return true;
        }
        @Nullable HumanArmorShape interactSlot = side == Side.TOP || yHit >= 0.5 ? (this.isBottom ? HumanArmorShape.LEGS : HumanArmorShape.HEAD) : (side == Side.BOTTOM || yHit < 0.5 ? (this.isBottom ? HumanArmorShape.BOOTS : HumanArmorShape.CHEST) : null);
        @Nullable ItemStack statueHeldItemStack = statueEntity.getHeldItem();
        Item statueHeldItem = statueHeldItemStack != null ? statueHeldItemStack.getItem() : null;
        ItemStack statueArmorItemStack = interactSlot != null ? statueEntity.getItemInArmorSlot(interactSlot) : null;
        Item statueArmorItem = statueArmorItemStack != null ? statueArmorItemStack.getItem() : null;
        @Nullable ItemStack playerHeldItemStack = player.getHeldItem();
        Item playerHeldItem = playerHeldItemStack != null ? playerHeldItemStack.getItem() : null;
        boolean isPlayerHoldingArmor = playerHeldItem instanceof IArmorItem && ((IArmorItem)((Object)playerHeldItem)).getArmorShape() == interactSlot;
        boolean isPlayerHandEmpty = playerHeldItem == null;
        boolean isStatueHandEmpty = statueHeldItem == null;
        boolean isStatueArmorEmpty = statueArmorItem == null;
        boolean shouldTakeItem = !isStatueHandEmpty && !isPlayerHoldingArmor;
        boolean shouldInsertItem = !isPlayerHandEmpty && !isPlayerHoldingArmor;
        boolean shouldTakeArmor = interactSlot != null && !isStatueArmorEmpty && isStatueHandEmpty;
        boolean bl = shouldInsertArmor = interactSlot != null && isPlayerHoldingArmor;
        if (shouldTakeItem && shouldInsertItem) {
            if (playerHeldItemStack.consumeItem(player)) {
                @NotNull ItemStack newStack = playerHeldItemStack.copy();
                newStack.stackSize = 1;
                player.inventory.insertItem(statueHeldItemStack, true);
                statueEntity.setHeldItem(newStack);
                return true;
            }
            return false;
        }
        if (shouldTakeItem) {
            player.inventory.insertItem(statueHeldItemStack, true);
            statueEntity.setHeldItem(null);
            return true;
        }
        if (shouldInsertItem) {
            if (playerHeldItemStack.consumeItem(player)) {
                @NotNull ItemStack newStack = playerHeldItemStack.copy();
                newStack.stackSize = 1;
                statueEntity.setHeldItem(newStack);
                return true;
            }
            return false;
        }
        if (shouldTakeArmor && shouldInsertArmor) {
            if (playerHeldItemStack.consumeItem(player)) {
                @NotNull ItemStack newStack = playerHeldItemStack.copy();
                newStack.stackSize = 1;
                player.inventory.insertItem(statueArmorItemStack, true);
                statueEntity.setItemInArmorSlot(interactSlot, newStack);
                return true;
            }
            return false;
        }
        if (shouldTakeArmor) {
            player.inventory.insertItem(statueArmorItemStack, true);
            statueEntity.setItemInArmorSlot(interactSlot, (ItemStack)null);
            return true;
        }
        if (shouldInsertArmor) {
            if (playerHeldItemStack.consumeItem(player)) {
                @NotNull ItemStack newStack = playerHeldItemStack.copy();
                newStack.stackSize = 1;
                statueEntity.setItemInArmorSlot(interactSlot, newStack);
                return true;
            }
            return false;
        }
        statueEntity.nextPose();
        world.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, (double)tilePos.x() + 0.5, (double)tilePos.y() + 0.5, (double)tilePos.z() + 0.5, "random.scrape", 0.7f, 0.2f + world.rand.nextFloat() * 0.2f);
        return true;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Nullable
    public TileEntityStatue getTileEntity(@NotNull World world, @NotNull TilePosc tilePos) {
        TilePosc entPos = this.isBottom ? tilePos : tilePos.down(new TilePos());
        @Nullable Block<?> block = world.getBlockType(entPos);
        if (block == null || !(block.getLogic() instanceof BlockLogicStatue)) {
            return null;
        }
        @Nullable TileEntity tileEntity = world.getTileEntity(entPos);
        if (!(tileEntity instanceof TileEntityStatue)) {
            return null;
        }
        return (TileEntityStatue)tileEntity;
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        if (this.isBottom) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            @Nullable TileEntity tileEntity = world.getTileEntity(tilePos);
            if (tileEntity != null) {
                TileEntityStatue statueEntity = (TileEntityStatue)tileEntity;
                for (HumanArmorShape armorShape : HumanArmorShape.values()) {
                    @Nullable ItemStack armorStack = statueEntity.getItemInArmorSlot(armorShape);
                    if (armorStack == null) continue;
                    stacks.add(armorStack);
                }
                @Nullable ItemStack heldItemStack = statueEntity.getHeldItem();
                if (heldItemStack != null) {
                    stacks.add(heldItemStack);
                }
            }
            for (ItemStack stack : stacks) {
                world.dropItem(tilePos, stack);
            }
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        Block<?> otherBlock = !this.isBottom ? world.getBlockType(tilePos.down(new TilePos())) : world.getBlockType(tilePos.up(new TilePos()));
        if (!(otherBlock.getLogic() instanceof BlockLogicStatue)) {
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
        }
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, @NotNull TilePosc tilePos, int data, @Nullable TileEntity tileEntity) {
        if (this.droppedItem == null) {
            return null;
        }
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            return new ItemStack[]{new ItemStack(this.droppedItem.get())};
        }
        return null;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        if (tilePos.y() >= world.getHeightBlocks() - 1) {
            return false;
        }
        return super.canPlaceAt(world, tilePos) && super.canPlaceAt(world, tilePos.up(new TilePos()));
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePosc tilePos) {
        return 1;
    }
}

