/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.world.settings.KeyedSettingNode;
import net.minecraft.core.world.settings.SettingNode;
import net.minecraft.core.world.settings.SettingNodeChildrenProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListSettingNodeChildrenProvider
implements SettingNodeChildrenProvider {
    @NotNull
    private final @NotNull List<@NotNull SettingNode> children = new ObjectArrayList<SettingNode>();
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull KeyedSettingNode> keyedChildren = new Object2ObjectOpenHashMap<String, KeyedSettingNode>();

    @Override
    public int length() {
        return this.children.size();
    }

    @Override
    @Nullable
    public KeyedSettingNode getChildByKey(@NotNull String key) {
        return this.keyedChildren.get(key);
    }

    @NotNull
    public final ListSettingNodeChildrenProvider withChild(@NotNull SettingNode settingNode) {
        this.children.add(settingNode);
        if (settingNode instanceof KeyedSettingNode) {
            @NotNull KeyedSettingNode keyed = (KeyedSettingNode)settingNode;
            this.keyedChildren.put(keyed.getKey(), keyed);
        }
        return this;
    }

    @NotNull
    public final ListSettingNodeChildrenProvider withChildren(SettingNode ... settingNodes) {
        for (SettingNode settingNode : settingNodes) {
            this.withChild(settingNode);
        }
        return this;
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull SettingNode> iterator() {
        return this.children.iterator();
    }
}

