/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.Color;

public abstract class GuidebookPage
extends Gui {
    protected final GuidebookSection section;
    protected final int width = 158;
    protected final int height = 220;

    public GuidebookPage(GuidebookSection section) {
        this.section = section;
    }

    public GuidebookSection getSection() {
        return this.section;
    }

    protected void renderBackground(TextureManager re, int x, int y) {
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        re.bindTexture(re.loadTexture("/assets/minecraft/textures/gui/container/guidebook/guidebook.png"));
        this.drawTexturedModalRect(x, y, 0, 0, this.width, this.height);
    }

    protected abstract void renderForeground(TextureManager var1, FontRenderer var2, int var3, int var4, int var5, int var6, float var7);

    public boolean drawHeaders() {
        return true;
    }

    public void render(TextureManager re, FontRenderer sr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(re, x, y);
        this.renderForeground(re, sr, x, y, mouseX, mouseY, partialTicks);
    }

    protected void renderOverlay(TextureManager re, FontRenderer sr, int x, int y, int mouseX, int mouseY, float partialTicks) {
    }

    public void onMouseDown(int x, int y, int mouseX, int mouseY, int button) {
    }

    public boolean keyTyped(char c, int key, int x, int y, int mouseX, int mouseY) {
        return false;
    }

    public void onTick() {
    }

    public void onBecomeVisible() {
    }

    public void onStopBeingVisible() {
    }

    public void drawSlot(int x, int y, int argb) {
        float a = (float)Color.alphaFromInt(argb) / 255.0f;
        float r = (float)Color.redFromInt(argb) / 255.0f;
        float g = (float)Color.greenFromInt(argb) / 255.0f;
        float b = (float)Color.blueFromInt(argb) / 255.0f;
        GLRenderer.setColor4f(r, g, b, a);
        this.drawGuiIcon(x, y, 18, 18, TextureRegistry.getTexture("minecraft:gui/screen/guidebook/slot"));
    }
}

