/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player.controller;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocalMultiplayer;
import net.minecraft.client.net.handler.PacketHandlerClient;
import net.minecraft.client.player.controller.PlayerController;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.PacketContainerClick;
import net.minecraft.core.net.packet.PacketEntityInteract;
import net.minecraft.core.net.packet.PacketPlayerAction;
import net.minecraft.core.net.packet.PacketSetCarriedItem;
import net.minecraft.core.net.packet.PacketSetPaintingArt;
import net.minecraft.core.net.packet.PacketUseOrPlaceItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerControllerMP
extends PlayerController {
    @NotNull
    protected PacketHandlerClient packetHandler;
    protected int currentSlot;

    public PlayerControllerMP(@NotNull Minecraft minecraft, @NotNull PacketHandlerClient packetHandler) {
        super(minecraft);
        this.packetHandler = packetHandler;
    }

    @Override
    public boolean destroyBlock(@NotNull TilePosc tilePos, @NotNull Side side) {
        @NotNull World world = Objects.requireNonNull(this.mc.currentWorld);
        @NotNull Player player = Objects.requireNonNull(this.mc.thePlayer);
        @NotNull Block<?> block = world.getBlockType(tilePos);
        boolean removed = super.destroyBlock(tilePos, side);
        @Nullable ItemStack item = player.getCurrentEquippedItem();
        if (item != null) {
            item.onBlockDestroyed(world, player, block, tilePos, side);
            if (item.stackSize <= 0) {
                player.destroyCurrentEquippedItem();
            }
        }
        return removed;
    }

    @Override
    protected void hitBlock(@NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        super.hitBlock(tilePos, side, xHit, yHit);
        this.packetHandler.addToSendQueue(new PacketPlayerAction(1, tilePos.x(), tilePos.y(), tilePos.z(), side, xHit, yHit));
    }

    @Override
    public void sendStartDigPacket(@NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        this.packetHandler.addToSendQueue(new PacketPlayerAction(0, tilePos.x(), tilePos.y(), tilePos.z(), side, xHit, yHit));
    }

    @Override
    public void sendDestroyBlockPacket(@NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        this.packetHandler.addToSendQueue(new PacketPlayerAction(2, tilePos.x(), tilePos.y(), tilePos.z(), side, xHit, yHit));
    }

    @Override
    protected void syncCurrentPlayItem() {
        int slot = Objects.requireNonNull(this.mc.thePlayer).inventory.getCurrentSlot();
        if (slot != this.currentSlot) {
            this.currentSlot = slot;
            this.packetHandler.addToSendQueue(new PacketSetCarriedItem(this.currentSlot));
        }
    }

    @Override
    public boolean useOrPlaceItemStackOnTile(@NotNull Player player, @NotNull World world, @Nullable ItemStack itemStack, @NotNull TilePosc tilePos, @NotNull Side side, double xPlaced, double yPlaced) {
        this.syncCurrentPlayItem();
        this.packetHandler.addToSendQueue(new PacketUseOrPlaceItemStack(tilePos.x(), tilePos.y(), tilePos.z(), side.getDirection(), player.inventory.getCurrentItem(), xPlaced, yPlaced, 0));
        return super.useOrPlaceItemStackOnTile(player, world, itemStack, tilePos, side, xPlaced, yPlaced);
    }

    @Override
    public boolean useItemStackOnNothing(@NotNull Player player, @NotNull World world, @NotNull ItemStack itemStack) {
        this.syncCurrentPlayItem();
        this.packetHandler.addToSendQueue(new PacketUseOrPlaceItemStack(-1, -1, -1, Direction.NONE, player.inventory.getCurrentItem(), 0.0, 0.0, 1));
        return super.useItemStackOnNothing(player, world, itemStack);
    }

    @Override
    public boolean placeItemStackOnTile(@NotNull Player player, @NotNull World world, @Nullable ItemStack itemStack, @NotNull TilePosc tilePos, @NotNull Side side, double xPlaced, double yPlaced) {
        this.syncCurrentPlayItem();
        this.packetHandler.addToSendQueue(new PacketUseOrPlaceItemStack(tilePos.x(), tilePos.y(), tilePos.z(), side.getDirection(), player.inventory.getCurrentItem(), xPlaced, yPlaced, 2));
        return super.placeItemStackOnTile(player, world, itemStack, tilePos, side, xPlaced, yPlaced);
    }

    @Override
    @NotNull
    public Player createPlayer(@NotNull World world) {
        return new PlayerLocalMultiplayer(this.mc, world, Objects.requireNonNull(this.mc.session), this.packetHandler);
    }

    @Override
    public void attack(@NotNull Player player, @NotNull Entity entity) {
        this.syncCurrentPlayItem();
        this.packetHandler.addToSendQueue(new PacketEntityInteract(player.id, entity.id, 1));
        player.attackTargetEntityWithCurrentItem(entity);
    }

    @Override
    public boolean interact(@NotNull Player player, @NotNull Entity entity) {
        this.syncCurrentPlayItem();
        this.packetHandler.addToSendQueue(new PacketEntityInteract(player.id, entity.id, 0));
        return player.useCurrentItemOnEntity(entity);
    }

    @Override
    @Nullable
    public ItemStack handleInventoryMouseClick(int windowId, @NotNull InventoryAction action, int @Nullable [] args2, @NotNull Player player) {
        short actionId = player.containerMenu.backup(player.inventory);
        @Nullable ItemStack itemStack = super.handleInventoryMouseClick(windowId, action, args2, player);
        this.packetHandler.addToSendQueue(new PacketContainerClick(windowId, action, args2, itemStack, actionId));
        return itemStack;
    }

    @Override
    public void handleCloseInventory(int windowId, @NotNull Player player) {
    }

    @Override
    public void setPaintingType(@NotNull ArtType art) {
        this.packetHandler.addToSendQueue(new PacketSetPaintingArt(art));
    }
}

