/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader.framebuffer;

import java.util.function.Consumer;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.render.shader.framebuffer.FrameBuffer;
import net.minecraft.client.render.shader.framebuffer.FrameBufferAttachment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.lwjgl.opengl.GL41;

public abstract class FrameBufferTexture
implements FrameBufferAttachment {
    private final int id = GLAllocation.generateTexture();
    private final int attachment;
    @NotNull
    private final Vector2ic size;
    private boolean deleted = false;

    public FrameBufferTexture(int format, int attachment, @NotNull Vector2ic size, int samples, @Nullable Consumer<@NotNull Parameters> parametersConsumer) {
        this.attachment = attachment;
        this.size = new Vector2i(size);
        this.whileBound(() -> {
            this.init(format, size, samples);
            if (parametersConsumer != null) {
                parametersConsumer.accept(new Parameters(this.getTextureTarget()));
            }
        });
    }

    @Override
    public int getId() {
        if (this.deleted) {
            throw new IllegalStateException("Texture deleted!");
        }
        return this.id;
    }

    @Override
    @NotNull
    public Vector2ic getSize() {
        if (this.deleted) {
            throw new IllegalStateException("Texture deleted!");
        }
        return this.size;
    }

    @Override
    public void delete() {
        if (this.deleted) {
            throw new IllegalStateException("Texture already deleted!");
        }
        GLAllocation.deleteTexture(this.id);
        this.deleted = true;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void whileBound(@NotNull Runnable runnable) {
        if (this.deleted) {
            throw new IllegalStateException("Texture deleted!");
        }
        GL41.glBindTexture(this.getTextureTarget(), this.id);
        runnable.run();
        GL41.glBindTexture(this.getTextureTarget(), 0);
    }

    @Override
    public void attachToFramebuffer(@NotNull FrameBuffer frameBuffer) {
        frameBuffer.whileBound(() -> GL41.glFramebufferTexture2D(36160, this.attachment, this.getTextureTarget(), this.getId(), 0));
    }

    @Override
    public int getAttachment() {
        return this.attachment;
    }

    @Override
    public void bindForOutput() {
        GL41.glBindTexture(this.getTextureTarget(), this.id);
    }

    @Override
    public void unbindForOutput() {
        GL41.glBindTexture(this.getTextureTarget(), 0);
    }

    protected abstract void init(int var1, @NotNull Vector2ic var2, int var3);

    protected abstract int getTextureTarget();

    public static final class Parameters {
        private final int textureTarget;

        private Parameters(int textureTarget) {
            this.textureTarget = textureTarget;
        }

        @NotNull
        public Parameters set(int parameter, int value) {
            GL41.glTexParameteri(this.textureTarget, parameter, value);
            return this;
        }

        @NotNull
        public Parameters set(int parameter, float value) {
            GL41.glTexParameterf(this.textureTarget, parameter, value);
            return this;
        }

        @NotNull
        public Parameters set(int parameter, int ... values2) {
            GL41.glTexParameteriv(this.textureTarget, parameter, values2);
            return this;
        }

        @NotNull
        public Parameters set(int parameter, float ... values2) {
            GL41.glTexParameterfv(this.textureTarget, parameter, values2);
            return this;
        }
    }
}

