/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import com.mojang.logging.CategorizedLogger;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.terrain.VertexConfig;
import net.minecraft.client.render.terrain.VertexData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL41;

public class VertexBuffer {
    @NotNull
    private static final CategorizedLogger LOGGER = LogUtils.getLogger();
    @NotNull
    public final @NotNull List<@NotNull Entry<?>> entries = new ArrayList();
    private int vbo;
    private final int vao;
    private long capacity;
    private int entryHashCounter;

    public VertexBuffer(long initialCapacity) {
        this.capacity = initialCapacity;
        this.vbo = GL41.glGenBuffers();
        this.vao = GL41.glGenVertexArrays();
        GL41.glBindBuffer(34962, this.vbo);
        GL41.glBufferData(34962, this.capacity, 35044);
        GL41.glBindBuffer(34962, 0);
    }

    @Nullable
    public <V extends VertexConfig<V>> Entry<V> addVertexData(@NotNull VertexData<V> vertexData) {
        if (vertexData.vertexCount <= 0) {
            return null;
        }
        if (this.entries.isEmpty()) {
            return this.insertAtIndex(vertexData, 0);
        }
        int bytes = vertexData.getBuffer().position();
        if (this.entries.size() == 1) {
            @Nullable Entry<?> entry = this.entries.get(0);
            assert (entry != null);
            if (entry.position > (long)bytes) {
                return this.insertAtIndex(vertexData, 0);
            }
            return this.insertAtIndex(vertexData, 1);
        }
        for (int i = 0; i < this.entries.size() - 1; ++i) {
            @Nullable Entry<?> entry = this.entries.get(i);
            @Nullable Entry<?> nextEntry = this.entries.get(i + 1);
            assert (entry != null);
            assert (nextEntry != null);
            long availableSpace = nextEntry.position - (entry.position + entry.size);
            if (availableSpace <= (long)bytes) continue;
            return this.insertAtIndex(vertexData, i + 1);
        }
        return this.insertAtIndex(vertexData, this.entries.size());
    }

    @NotNull
    private <V extends VertexConfig<V>> Entry<V> insertAtIndex(@NotNull VertexData<V> vertexData, int listIndex) {
        long pos = 0L;
        long bytes = vertexData.getBuffer().position();
        if (listIndex > 0) {
            @Nullable Entry<?> prev = this.entries.get(listIndex - 1);
            assert (prev != null);
            pos = prev.position + prev.size;
        }
        if (pos + bytes >= this.capacity) {
            this.expandVBO();
        }
        @NotNull Entry entry = new Entry(this, vertexData.config, pos, bytes);
        if (listIndex > 0) {
            @Nullable Entry<?> previousEntry = this.entries.get(listIndex - 1);
            assert (previousEntry != null);
            if (previousEntry.position + previousEntry.size > pos) {
                throw new RuntimeException("Entry collision: " + String.valueOf(entry) + " and " + String.valueOf(previousEntry));
            }
        }
        if (listIndex < this.entries.size() - 1) {
            @Nullable Entry<?> nextEntry = this.entries.get(listIndex + 1);
            assert (nextEntry != null);
            if (nextEntry.position <= pos + bytes) {
                throw new RuntimeException("Entry collision: " + String.valueOf(entry) + " and " + String.valueOf(nextEntry));
            }
        }
        vertexData.getBuffer().flip();
        assert (pos >= 0L) : "Entry pos must be positive!";
        GL41.glBindBuffer(34962, this.vbo);
        GL41.glBufferSubData(34962, pos, vertexData.getBuffer());
        GL41.glBindBuffer(34962, 0);
        this.entries.add(listIndex, entry);
        return entry;
    }

    private void expandVBO() {
        long prevCapacity = this.capacity;
        long newCapacity = this.capacity * 2L;
        if (newCapacity < this.capacity) {
            throw new RuntimeException();
        }
        LOGGER.warn("Expand VBO Buffer: " + newCapacity);
        OpenGLHelper.checkError("pre expand buffer");
        int newBuffer = GL41.glGenBuffers();
        GL41.glBindBuffer(34962, newBuffer);
        GL41.glBufferData(34962, newCapacity, 35044);
        OpenGLHelper.checkError("create expand buffer");
        GL41.glBindBuffer(36662, this.vbo);
        GL41.glBindBuffer(36663, newBuffer);
        GL41.glCopyBufferSubData(36662, 36663, 0L, 0L, this.capacity);
        GL41.glBindBuffer(36662, 0);
        GL41.glBindBuffer(36663, 0);
        OpenGLHelper.checkError("copy buffer");
        this.capacity = newCapacity;
        this.vbo = newBuffer;
    }

    public void removeEntry(Entry<?> entry) {
        this.entries.remove(entry);
    }

    public int getVbo() {
        return this.vbo;
    }

    public int getVao() {
        return this.vao;
    }

    public int entryCount() {
        return this.entries.size();
    }

    public class Entry<V extends VertexConfig<V>> {
        public final long position;
        public final long size;
        @NotNull
        public final V config;
        private final int hashCode;
        final /* synthetic */ VertexBuffer this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public Entry(V size, long l, long l2) {
            void config;
            this.this$0 = (VertexBuffer)this$0;
            this.hashCode = this.this$0.entryHashCounter++;
            this.config = config;
            this.position = position;
            this.size = (long)size;
        }

        public String toString() {
            return "VertexBufferEntry[position: " + this.position + ", size: " + this.size + "]";
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

