/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world.chunk.provider;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkLoader;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.provider.ChunkProvider;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkPosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChunkProviderStatic
implements ChunkProvider {
    public static final int CHUNK_RADIUS = 32;
    public static final int CHUNK_MASK = 63;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Chunk blankChunk;
    public ChunkGenerator chunkGenerator;
    private final ChunkLoader chunkLoader;
    private final Chunk[] chunks = new Chunk[4096];
    private final World worldObj;
    int lastQueriedChunkXPos = Integer.MIN_VALUE;
    int lastQueriedChunkZPos = Integer.MIN_VALUE;
    private Chunk lastQueriedChunk;
    private int curChunkX;
    private int curChunkY;

    public ChunkProviderStatic(World world, ChunkLoader ichunkloader, ChunkGenerator chunkGenerator) {
        this.blankChunk = new EmptyChunk(world, 0, 0);
        this.worldObj = world;
        this.chunkLoader = ichunkloader;
        this.chunkGenerator = chunkGenerator;
    }

    @Override
    public void setCurrentChunkOver(@NotNull ChunkPosc chunkPos) {
        this.curChunkX = chunkPos.x();
        this.curChunkY = chunkPos.z();
    }

    public boolean canChunkExist(@NotNull ChunkPosc chunkPos) {
        int byte0 = 31;
        return chunkPos.x() >= this.curChunkX - byte0 && chunkPos.z() >= this.curChunkY - byte0 && chunkPos.x() <= this.curChunkX + byte0 && chunkPos.z() <= this.curChunkY + byte0;
    }

    @Override
    public void regenerateChunk(@NotNull ChunkPosc chunkPos) {
        int k = chunkPos.x() & 0x3F;
        int l = chunkPos.z() & 0x3F;
        int i1 = k + l * 32 * 2;
        if (this.chunkGenerator == null) {
            return;
        }
        Chunk newChunk = this.chunkGenerator.generate(chunkPos.x(), chunkPos.z());
        newChunk.fixMissingBlocks();
        this.chunks[i1] = newChunk;
        @NotNull ChunkPos queryPos = new ChunkPos(chunkPos);
        if (!newChunk.isTerrainPopulated && this.isChunkLoaded(chunkPos.add(1, 1, queryPos)) && this.isChunkLoaded(chunkPos.add(0, 1, queryPos)) && this.isChunkLoaded(chunkPos.add(1, 0, queryPos))) {
            this.populate(chunkPos);
        }
        if (this.isChunkLoaded(chunkPos.add(-1, 0, queryPos)) && !this.provideChunk((ChunkPosc)chunkPos.add((int)-1, (int)0, (ChunkPos)queryPos), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(-1, 1, queryPos)) && this.isChunkLoaded(chunkPos.add(0, 1, queryPos))) {
            this.populate(chunkPos.add(-1, 0, queryPos));
        }
        if (this.isChunkLoaded(chunkPos.add(0, -1, queryPos)) && !this.provideChunk((ChunkPosc)chunkPos.add((int)0, (int)-1, (ChunkPos)queryPos), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(1, -1, queryPos)) && this.isChunkLoaded(chunkPos.add(1, 0, queryPos))) {
            this.populate(chunkPos.add(0, -1, queryPos));
        }
        if (this.isChunkLoaded(chunkPos.add(-1, -1, queryPos)) && !this.provideChunk((ChunkPosc)chunkPos.add((int)-1, (int)-1, (ChunkPos)queryPos), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(0, -1, queryPos)) && this.isChunkLoaded(chunkPos.add(-1, 0, queryPos))) {
            this.populate(chunkPos.add(-1, -1, queryPos));
        }
    }

    @Override
    public boolean isChunkLoaded(@NotNull ChunkPosc chunkPos) {
        int l;
        if (!this.canChunkExist(chunkPos)) {
            return false;
        }
        if (chunkPos.x() == this.lastQueriedChunkXPos && chunkPos.z() == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return true;
        }
        int k = chunkPos.x() & 0x3F;
        int chunkIndex = k + (l = chunkPos.z() & 0x3F) * 32 * 2;
        return this.chunks[chunkIndex] == this.blankChunk || this.chunks[chunkIndex] != null && this.chunks[chunkIndex].isAtLocation(chunkPos);
    }

    @Override
    @NotNull
    public Chunk prepareChunk(@NotNull ChunkPosc chunkPos, boolean priority) {
        return this.provideChunk(chunkPos, priority);
    }

    @Override
    @NotNull
    public Chunk provideChunk(@NotNull ChunkPosc chunkPos, boolean priority) {
        if (chunkPos.x() == this.lastQueriedChunkXPos && chunkPos.z() == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return this.lastQueriedChunk;
        }
        if (!this.worldObj.findingSpawnPoint && !this.canChunkExist(chunkPos)) {
            return this.blankChunk;
        }
        int k = chunkPos.x() & 0x3F;
        int l = chunkPos.z() & 0x3F;
        int i1 = k + l * 32 * 2;
        if (!this.isChunkLoaded(chunkPos)) {
            Chunk chunk;
            if (this.chunks[i1] != null) {
                this.saveChunk(this.chunks[i1]);
                this.chunks[i1].onUnload();
            }
            if ((chunk = this.loadChunk(chunkPos)) == null) {
                if (this.chunkGenerator != null) {
                    chunk = this.chunkGenerator.generate(chunkPos.x(), chunkPos.z());
                    chunk.fixMissingBlocks();
                } else {
                    chunk = this.blankChunk;
                }
            }
            this.chunks[i1] = chunk;
            if (this.chunks[i1] != null) {
                this.chunks[i1].checkForLightGaps();
                this.chunks[i1].onLoad();
            }
            @NotNull ChunkPos queryPos = new ChunkPos(chunkPos);
            if (!chunk.isTerrainPopulated && this.isChunkLoaded(chunkPos.add(1, 1, queryPos)) && this.isChunkLoaded(chunkPos.add(0, 1, queryPos)) && this.isChunkLoaded(chunkPos.add(1, 0, queryPos))) {
                this.populate(chunkPos);
            }
            if (this.isChunkLoaded(chunkPos.add(-1, 0, queryPos)) && !this.provideChunk((ChunkPosc)chunkPos.add((int)-1, (int)0, (ChunkPos)queryPos), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(-1, 1, queryPos)) && this.isChunkLoaded(chunkPos.add(0, 1, queryPos))) {
                this.populate(chunkPos.add(-1, 0, queryPos));
            }
            if (this.isChunkLoaded(chunkPos.add(0, -1, queryPos)) && !this.provideChunk((ChunkPosc)chunkPos.add((int)0, (int)-1, (ChunkPos)queryPos), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(1, -1, queryPos)) && this.isChunkLoaded(chunkPos.add(1, 0, queryPos))) {
                this.populate(chunkPos.add(0, -1, queryPos));
            }
            if (this.isChunkLoaded(chunkPos.add(-1, -1, queryPos)) && !this.provideChunk((ChunkPosc)chunkPos.add((int)-1, (int)-1, (ChunkPos)queryPos), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(0, -1, queryPos)) && this.isChunkLoaded(chunkPos.add(-1, 0, queryPos))) {
                this.populate(chunkPos.add(-1, -1, queryPos));
            }
            if (this.worldObj.getCurrentWeather() != null) {
                this.worldObj.getCurrentWeather().doChunkLoadEffect(this.worldObj, chunk);
            }
        }
        this.lastQueriedChunkXPos = chunkPos.x();
        this.lastQueriedChunkZPos = chunkPos.z();
        this.lastQueriedChunk = this.chunks[i1];
        return this.chunks[i1];
    }

    private Chunk loadChunk(@NotNull ChunkPosc chunkPos) {
        if (this.chunkLoader == null) {
            return this.blankChunk;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.worldObj, chunkPos.x(), chunkPos.z());
            if (chunk != null) {
                chunk.lastSaveTime = this.worldObj.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            LOGGER.error("Error loading chunk at X:{}, Z:{}", chunkPos.x(), chunkPos.z(), exception);
            return this.blankChunk;
        }
    }

    private void saveChunk(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.worldObj.getWorldTime();
            this.chunkLoader.saveChunk(this.worldObj, chunk);
        }
        catch (IOException e) {
            LOGGER.error("Error saving chunk at X:{}, Z:{}", chunk.pos.x, chunk.pos.x, e);
        }
    }

    @Override
    public void populate(@NotNull ChunkPosc chunkPos) {
        Chunk chunk = this.provideChunk(chunkPos, true);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkGenerator != null) {
                this.chunkGenerator.decorate(chunk);
                chunk.setChunkModified();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, @Nullable ProgressListener progressListener) {
        int i = 0;
        int j = 0;
        if (progressListener != null) {
            for (int k = 0; k < this.chunks.length; ++k) {
                if (this.chunks[k] == null || !this.chunks[k].needsSaving(saveImmediately)) continue;
                ++j;
            }
        }
        int l = 0;
        for (int i1 = 0; i1 < this.chunks.length; ++i1) {
            if (this.chunks[i1] == null || !this.chunks[i1].needsSaving(saveImmediately)) continue;
            this.saveChunk(this.chunks[i1]);
            this.chunks[i1].isModified = false;
            if (++i == 2 && !saveImmediately) {
                return false;
            }
            if (progressListener == null || ++l % 10 != 0) continue;
            progressListener.progressStagePercentage(l * 100 / j);
        }
        return true;
    }

    @Override
    public boolean tick() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
        for (Chunk chunk : this.chunks) {
            if (chunk == null) continue;
            chunk.onUnload();
        }
        Arrays.fill(this.chunks, null);
        this.chunkGenerator = null;
        System.gc();
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    @NotNull
    public String getInfoString() {
        return "ChunkCache: " + this.chunks.length;
    }

    public ChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }
}

