/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import com.mojang.nbt.tags.CompoundTag;
import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicSign;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobSheep;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemDye;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;

public class ItemPaintBrush
extends Item {
    private static final int DAMAGE_PER_DYE = 8;

    public ItemPaintBrush(@NotNull String translationKey, @NotNull String namespaceId, int id) {
        super(translationKey, namespaceId, id);
        this.setMaxStackSize(1);
        this.setMaxDamage(64);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        BlockLogic blockLogic;
        TileEntity tileEntity;
        Block<?> block = world.getBlockType(blockPos);
        if (Block.hasLogicClass(block, BlockLogicSign.class) && (tileEntity = world.getTileEntity(blockPos)) instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileEntity;
            if (player != null && player.isSneaking()) {
                DyeColor dyeColor = ItemPaintBrush.getColor(selfStack);
                if (dyeColor == null || dyeColor.blockMeta == sign.getColor().id) return false;
                sign.setColor(TextFormatting.get(dyeColor.blockMeta));
                this.consumePaint(selfStack, player);
                return true;
            }
        }
        if (!((blockLogic = Block.getLogicClass(block)) instanceof IPaintable)) return false;
        IPaintable paintable = (IPaintable)((Object)blockLogic);
        if (!paintable.canBePainted()) {
            return false;
        }
        DyeColor dyeColor = ItemPaintBrush.getColor(selfStack);
        if (dyeColor == null) return false;
        if (paintable instanceof IPainted && ((IPainted)paintable).getColor(world, blockPos) == dyeColor) {
            return false;
        }
        paintable.setColor(world, blockPos, dyeColor);
        this.consumePaint(selfStack, player);
        return true;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        AABBd box;
        List<MobSheep> entities;
        if (!this.onUseOnBlock(selfStack, world, null, blockPos = blockPos.add(direction, new TilePos()), direction.getSide(), 0.5, 0.5) && !(entities = world.getEntitiesWithinAABB(MobSheep.class, box = new AABBd(blockPos.x(), blockPos.y(), blockPos.z(), blockPos.x() + 1, blockPos.y() + 1, blockPos.z() + 1))).isEmpty()) {
            MobSheep sheep = entities.get(0);
            DyeColor woolColor = ItemPaintBrush.getColor(selfStack);
            if (woolColor != null && sheep.getFleeceColor() != woolColor) {
                sheep.setFleeceColor(woolColor);
                this.consumePaint(selfStack, null);
            }
        }
    }

    public void consumePaint(@NotNull ItemStack itemstack, @Nullable Player player) {
        if (itemstack.getMetadata() >= itemstack.getMaxDamage()) {
            ItemPaintBrush.setColor(itemstack, null);
            itemstack.setMetadata(this.getMaxDamage());
        } else {
            itemstack.damageItem(1, player);
        }
    }

    @Override
    public boolean useOnEntity(@NotNull ItemStack selfStack, @NotNull Player player, @NotNull Mob mob) {
        if (mob instanceof MobSheep) {
            MobSheep mobSheep = (MobSheep)mob;
            DyeColor woolColor = ItemPaintBrush.getColor(selfStack);
            if (woolColor != null && mobSheep.getFleeceColor() != woolColor) {
                mobSheep.setFleeceColor(woolColor);
                this.consumePaint(selfStack, player);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasInventoryInteraction() {
        return true;
    }

    @Override
    @Nullable
    public ItemStack onInventoryInteract(@NotNull Player player, @NotNull Slot slot, @Nullable ItemStack stackInSlot, boolean isItemGrabbed) {
        if (isItemGrabbed || stackInSlot == null) {
            return stackInSlot;
        }
        DyeColor currentColor = ItemPaintBrush.getColor(stackInSlot);
        int dyeCount = this.getDyeCount(stackInSlot);
        ItemStack grabbedItem = player.inventory.getHeldItemStack();
        if (grabbedItem != null && grabbedItem.getItem() instanceof ItemDye) {
            DyeColor newColor = DyeColor.colorFromItemMeta(grabbedItem.getMetadata());
            if (currentColor != newColor) {
                ItemPaintBrush.setColor(stackInSlot, newColor);
                this.setDyeCount(stackInSlot, 8);
                --grabbedItem.stackSize;
                if (grabbedItem.stackSize <= 0) {
                    player.inventory.setHeldItemStack(null);
                }
            } else if (dyeCount < this.getMaxDamage()) {
                int newDyeCount = Math.min(dyeCount + 8, stackInSlot.getMaxDamage());
                this.setDyeCount(stackInSlot, newDyeCount);
                --grabbedItem.stackSize;
                if (grabbedItem.stackSize <= 0) {
                    player.inventory.setHeldItemStack(null);
                }
            }
        }
        return stackInSlot;
    }

    public int getDyeCount(@NotNull ItemStack stack) {
        return stack.getMaxDamage() - stack.getMetadata();
    }

    public void setDyeCount(@NotNull ItemStack stack, int count) {
        stack.setMetadata(stack.getMaxDamage() - count);
    }

    @Nullable
    public static DyeColor getColor(@NotNull ItemStack stack) {
        CompoundTag tag = stack.getData();
        if (tag.containsKey("Color")) {
            int color = tag.getInteger("Color");
            if (color < 0) {
                return null;
            }
            return DyeColor.colorFromItemMeta(color & 0xF);
        }
        return null;
    }

    public static void setColor(@NotNull ItemStack stack, @Nullable DyeColor color) {
        CompoundTag tag = stack.getData();
        if (color == null) {
            tag.putInt("Color", -1);
        } else {
            tag.putInt("Color", color.itemMeta);
        }
    }
}

