/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPlaceable
extends Item {
    @NotNull
    public final Block<?> blockToPlace;

    public ItemPlaceable(@NotNull String name, @NotNull String namespaceId, int id, @NotNull Block<?> blockToPlace) {
        super(name, namespaceId, id);
        this.blockToPlace = blockToPlace;
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        if (selfStack.stackSize <= 0) {
            return false;
        }
        if (!world.canPlaceInsideBlock(blockPos)) {
            blockPos = blockPos.add(side.getDirection(), new TilePos());
        }
        if (blockPos.y() < 0 || blockPos.y() >= world.getHeightBlocks()) {
            return false;
        }
        if (world.canBlockIdBePlacedAt(this.blockToPlace.id(), blockPos, false, side) && selfStack.consumeItem(player) && world.setBlockTypeNotify(blockPos, this.blockToPlace)) {
            TileEntity tileEntity;
            if (player == null) {
                this.blockToPlace.onPlacedOnSide(world, blockPos, side, xHit, yHit);
            } else {
                this.blockToPlace.onPlacedByMob(world, blockPos, side, player, xHit, yHit);
            }
            if (this.blockToPlace.isEntityTile && selfStack.getData().containsKey("tileEntityData") && (tileEntity = world.getTileEntity(blockPos)) != null) {
                tileEntity.readAdditionalData(selfStack.getData().getCompound("tileEntityData"));
            }
            world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, this.blockToPlace, EnumBlockSoundEffectType.PLACE);
            return true;
        }
        return false;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        Block<?> b = world.getBlockType(blockPos = blockPos.add(direction, new TilePos()));
        if (b == null || BlockTags.PLACE_OVERWRITES.appliesTo(b)) {
            this.onUseOnBlock(selfStack, world, null, blockPos, direction.getSide(), 0.5, 0.5);
        }
    }
}

