/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.player;

import com.mojang.nbt.tags.CompoundTag;
import java.util.UUID;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.GetSkinUrlThread;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class PlayerRemote
extends Player {
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;

    public PlayerRemote(World world, String username, UUID uuid) {
        super(world);
        this.username = username;
        this.uuid = uuid;
        this.footSize = 0.0f;
        this.noPhysics = true;
        this.sleepOffY = 0.25f;
        this.viewScale = 10.0;
        new GetSkinUrlThread(this);
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        return true;
    }

    @Override
    public void lerpTo(double x, double y, double z, float yRot, float xRot, int ticks) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = ticks;
    }

    @Override
    public void tick() {
        this.sleepOffY = 0.0f;
        super.tick();
        this.walkAnimSpeedO = this.walkAnimSpeed;
        this.xd = this.x - this.xo;
        this.yd = this.y - this.yo;
        this.zd = this.z - this.zo;
        float f = MathHelper.sqrt(this.xd * this.xd + this.zd * this.zd) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.walkAnimSpeed += (f - this.walkAnimSpeed) * 0.4f;
        this.walkAnimPos += this.walkAnimSpeed;
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }

    @Override
    public void onDeath(Entity entityKilledBy) {
    }

    @Override
    public void onLivingUpdate() {
        super.updateAI();
        if (this.lerpSteps > 0) {
            double d = this.x + (this.lerpX - this.x) / (double)this.lerpSteps;
            double d1 = this.y + (this.lerpY - this.y) / (double)this.lerpSteps;
            double d2 = this.z + (this.lerpZ - this.z) / (double)this.lerpSteps;
            double d3 = MathHelper.normalizeRotation(this.lerpYRot - (double)this.yRot);
            this.yRot = (float)((double)this.yRot + d3 / (double)this.lerpSteps);
            this.xRot = (float)((double)this.xRot + (this.lerpXRot - (double)this.xRot) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.setPos(d, d1, d2);
            this.setRot(this.yRot, this.xRot);
        }
        this.cameraVelocityOld = this.cameraVelocity;
        float horizontalSpeed = MathHelper.sqrt(this.xd * this.xd + this.zd * this.zd);
        float f1 = (float)Math.atan(-this.yd * 0.2) * 15.0f;
        if (horizontalSpeed > 0.1f) {
            horizontalSpeed = 0.1f;
        }
        if (!this.onGround || this.getHealth() <= 0) {
            horizontalSpeed = 0.0f;
        }
        if (this.onGround || this.getHealth() <= 0) {
            f1 = 0.0f;
        }
        this.cameraVelocity += (horizontalSpeed - this.cameraVelocity) * 0.4f;
        this.cameraPitch += (f1 - this.cameraPitch) * 0.8f;
    }

    @Override
    public void setEquippedSlot(int slot, int itemID, int itemMeta, CompoundTag tag) {
        ItemStack itemstack = null;
        if (itemID >= 0) {
            itemstack = new ItemStack(itemID, 1, itemMeta, tag);
        }
        if (slot == 0) {
            this.inventory.mainInventory[this.inventory.getCurrentSlot()] = itemstack;
        } else {
            this.inventory.armorInventory[slot - 1] = itemstack;
        }
    }

    @Override
    public void animate4() {
    }

    @Override
    public void sendMessage(String message) {
    }

    @Override
    public void sendStatusMessage(String message) {
    }
}

