/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings.settingnode;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.worldsettings.settingnode.ValueNodeComponent;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.settings.WorldConfiguration;
import net.minecraft.core.world.settings.impl.RangeIntegerSettingNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeIntegerNodeComponent
extends ValueNodeComponent<Integer> {
    @NotNull
    private final IntegerSliderElement slider = new IntegerSliderElement(0, 0, 0, 150, 20);
    private final boolean applyOnRelease = true;

    public RangeIntegerNodeComponent(@NotNull RangeIntegerSettingNode valueNode, int nestLevel) {
        super(valueNode, nestLevel);
    }

    @Override
    @NotNull
    public RangeIntegerSettingNode getNode() {
        return (RangeIntegerSettingNode)super.getNode();
    }

    @Override
    public void reset() {
        super.reset();
        this.onChange();
    }

    @Override
    public void onUpdate(@NotNull Dimension dimension, @NotNull WorldConfiguration worldConfiguration) {
        super.onUpdate(dimension, worldConfiguration);
        this.onChange();
    }

    @Override
    protected boolean buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        @Nullable Dimension dimension = this.getDimension();
        @Nullable WorldConfiguration worldConfiguration = this.getWorldConfiguration();
        assert (dimension != null && worldConfiguration != null);
        this.slider.mouseClicked(MC, this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        Objects.requireNonNull(this);
        this.updateText();
        return true;
    }

    @Override
    protected void buttonDragged(int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        @Nullable Dimension dimension = this.getDimension();
        @Nullable WorldConfiguration worldConfiguration = this.getWorldConfiguration();
        assert (dimension != null && worldConfiguration != null);
        Objects.requireNonNull(this);
        this.updateText();
    }

    @Override
    protected void buttonReleased(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        @Nullable Dimension dimension = this.getDimension();
        @Nullable WorldConfiguration worldConfiguration = this.getWorldConfiguration();
        assert (dimension != null && worldConfiguration != null);
        this.slider.mouseReleased(this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        worldConfiguration.getDimensionSettings(dimension).setNodeValue(this.getNode(), Integer.valueOf(this.slider.sliderValue));
        this.onChange();
    }

    @Override
    protected void renderButtonInner(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        this.slider.xPosition = x + relativeButtonX;
        this.slider.yPosition = y + relativeButtonY;
        this.slider.width = buttonWidth;
        this.slider.height = buttonHeight;
        this.slider.drawButton(MC, x + relativeMouseX, y + relativeMouseY);
    }

    private void updateText() {
        this.slider.displayString = this.getNode().getValueText(this.slider.sliderValue).toString();
    }

    private void onChange() {
        @Nullable Dimension dimension = this.getDimension();
        @Nullable WorldConfiguration worldConfiguration = this.getWorldConfiguration();
        assert (dimension != null && worldConfiguration != null);
        this.slider.sliderValue = (Integer)this.getValue();
        this.slider.min = this.getNode().getMinimumValue(dimension, worldConfiguration);
        this.slider.max = this.getNode().getMaximumValue(dimension, worldConfiguration);
        this.updateText();
    }

    private static class IntegerSliderElement
    extends ButtonElement {
        public int sliderValue;
        public boolean dragging = false;
        public boolean renderText = true;
        private int min;
        private int max;
        public IconCoordinate backgroundTexture;

        public IntegerSliderElement(int id, int xPosition, int yPosition) {
            this(id, xPosition, yPosition, 150, 20);
        }

        public IntegerSliderElement(int id, int xPosition, int yPosition, int width, int height) {
            super(id, xPosition, yPosition, width, height, "");
        }

        @Override
        protected void setDefaultTextures() {
            this.backgroundTexture = TextureRegistry.getTexture("minecraft:gui/widgets/slider/slider_background");
            this.defaultTexture = TextureRegistry.getTexture("minecraft:gui/widgets/slider/slider");
            this.hoveredTexture = TextureRegistry.getTexture("minecraft:gui/widgets/slider/slider_highlighted");
            this.disabledTexture = TextureRegistry.getTexture("minecraft:gui/widgets/slider/slider_disabled");
        }

        private int getSliderWidth() {
            return 8;
        }

        @Override
        public void mouseDragged(@NotNull Minecraft mc, int mouseX, int mouseY) {
            if (!this.visible) {
                return;
            }
            int sliderWidth = this.getSliderWidth();
            int segments = this.max - this.min;
            if (this.dragging && segments != 0) {
                float percentage = (float)(mouseX - (this.xPosition + 4) - this.width / (2 * segments)) / (float)(this.width - sliderWidth);
                if (percentage > 1.0f) {
                    percentage = 1.0f;
                }
                if (percentage < 0.0f) {
                    percentage = 0.0f;
                }
                this.sliderValue = this.min + (int)Math.ceil((float)segments * percentage);
            }
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public void drawButton(@NotNull Minecraft mc, int mouseX, int mouseY) {
            int textColor;
            if (!this.visible) {
                return;
            }
            boolean mouseOver = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
            int state = this.getButtonState(mouseOver);
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            @NotNull IconCoordinate tex = switch (state) {
                case 0 -> this.disabledTexture;
                case 2 -> this.hoveredTexture;
                default -> this.defaultTexture;
            };
            this.drawGuiIcon(this.xPosition, this.yPosition, this.width, this.height, this.backgroundTexture);
            int segments = this.max - this.min;
            if (segments != 0) {
                int sliderWidth = this.getSliderWidth();
                this.drawGuiIcon(this.xPosition + (int)((float)(this.sliderValue - this.min) / (float)segments * (float)(this.width - sliderWidth)), this.yPosition, sliderWidth, this.height, tex);
            }
            this.mouseDragged(mc, mouseX, mouseY);
            switch (state) {
                case 0: {
                    int n = 0xA0A0A0;
                    break;
                }
                case 1: {
                    int n = 0xE0E0E0;
                    break;
                }
                default: {
                    int n = textColor = 0xFFFFA0;
                }
            }
            if (this.renderText) {
                this.drawStringCenteredShadow(mc.font, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, textColor);
            }
        }

        @Override
        public boolean mouseClicked(@NotNull Minecraft mc, int mouseX, int mouseY) {
            if (super.mouseClicked(mc, mouseX, mouseY)) {
                int segments = this.max - this.min;
                if (segments != 0) {
                    float percentage = (float)(mouseX - (this.xPosition + 4) - this.width / (2 * segments)) / (float)(this.width - 8);
                    if (percentage > 1.0f) {
                        percentage = 1.0f;
                    }
                    if (percentage < 0.0f) {
                        percentage = 0.0f;
                    }
                    this.sliderValue = this.min + (int)Math.ceil((float)segments * percentage);
                    this.dragging = true;
                }
                return true;
            }
            return false;
        }

        @Override
        public void mouseReleased(int mouseX, int mouseY) {
            this.dragging = false;
        }
    }
}

