/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.helper;

import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import org.jetbrains.annotations.NotNull;

public enum Direction {
    NORTH(Axis.Z, 0, 0, -1, "north"),
    EAST(Axis.X, 1, 0, 0, "east"),
    SOUTH(Axis.Z, 0, 0, 1, "south"),
    WEST(Axis.X, -1, 0, 0, "west"),
    UP(Axis.Y, 0, 1, 0, "up"),
    DOWN(Axis.Y, 0, -1, 0, "down"),
    NONE(Axis.NONE, 0, 0, 0, "none");

    @NotNull
    public static final @NotNull Direction @NotNull [] directions;
    @NotNull
    public static final @NotNull Direction @NotNull [] horizontalDirections;
    private final Axis axis;
    private int id;
    private int horizontalIndex;
    private Direction opposite;
    private Side side;
    private final int offsetX;
    private final int offsetY;
    private final int offsetZ;
    private final String translationKey;
    @Deprecated
    public int index;
    @NotNull
    public static Direction[] rotXMap;
    @NotNull
    public static Direction[] rotYMap;
    @NotNull
    public static Direction[] rotZMap;

    private static void setId(Direction side, int id) {
        Direction.directions[id] = side;
        side.id = id;
    }

    private static void setHorizontal(Direction direction, int id) {
        Direction.horizontalDirections[id] = direction;
        direction.horizontalIndex = id;
    }

    private static void setOpposites(Direction side1, Direction side2) {
        side1.opposite = side2;
        side2.opposite = side1;
    }

    @NotNull
    public static Direction getDirectionById(int i) {
        if (i >= 0 && i < directions.length) {
            return directions[i];
        }
        return NONE;
    }

    private Direction(Axis axis, int offsetX, int offsetY, int offsetZ, String translationKey) {
        this.axis = axis;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.translationKey = "direction." + translationKey;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    @NotNull
    public Direction getOpposite() {
        return this.opposite;
    }

    public Side getSide() {
        return this.side;
    }

    @NotNull
    public Axis getAxis() {
        return this.axis;
    }

    public int getId() {
        return this.id;
    }

    public boolean isVertical() {
        return this.getAxis().isVertical();
    }

    public boolean isHorizontal() {
        return !this.isVertical();
    }

    public Direction rotate(int amount) {
        if (this == UP) {
            return UP;
        }
        if (this == DOWN) {
            return DOWN;
        }
        return horizontalDirections[this.getHorizontalIndex() + amount & 3];
    }

    public int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    public static Direction getVerticalDirection(double rotationPitch) {
        if (rotationPitch < 0.0) {
            return UP;
        }
        return DOWN;
    }

    public static Direction getVerticalDirection(Mob entity) {
        if (entity.rotationLockVertical != null && entity.rotationLockVertical != NONE) {
            return entity.rotationLockVertical;
        }
        return Direction.getVerticalDirection(entity.xRot);
    }

    @NotNull
    public static Direction getHorizontalDirection(double rotationYaw) {
        return horizontalDirections[MathHelper.floor(rotationYaw / 90.0 + 0.5) + 2 & 3];
    }

    @NotNull
    public static Direction getHorizontalDirection(@NotNull Mob mob) {
        if (mob.rotationLockHorizontal != null && mob.rotationLockHorizontal != NONE) {
            return mob.rotationLockHorizontal;
        }
        return Direction.getHorizontalDirection(mob.yRot);
    }

    @NotNull
    public static Direction getDirection(@NotNull Mob mob) {
        if (mob.rotationLock != null && mob.rotationLock != NONE) {
            return mob.rotationLock;
        }
        if (mob.xRot < -45.0f) {
            return UP;
        }
        if (mob.xRot > 45.0f) {
            return DOWN;
        }
        return Direction.getHorizontalDirection(mob.yRot);
    }

    @NotNull
    public static Direction rotateX(@NotNull Direction direction, int amount) {
        return rotXMap[direction.getId() * 4 + (amount & 3)];
    }

    @NotNull
    public static Direction rotateY(@NotNull Direction direction, int amount) {
        return rotYMap[direction.getId() * 4 + (amount & 3)];
    }

    @NotNull
    public static Direction rotateZ(@NotNull Direction direction, int amount) {
        return rotZMap[direction.getId() * 4 + (amount & 3)];
    }

    static {
        directions = new Direction[6];
        horizontalDirections = new Direction[4];
        Direction.setId(DOWN, 0);
        Direction.setId(UP, 1);
        Direction.setId(NORTH, 2);
        Direction.setId(SOUTH, 3);
        Direction.setId(WEST, 4);
        Direction.setId(EAST, 5);
        Direction.NONE.id = -1;
        Direction.setHorizontal(NORTH, 0);
        Direction.setHorizontal(EAST, 1);
        Direction.setHorizontal(SOUTH, 2);
        Direction.setHorizontal(WEST, 3);
        Direction.setOpposites(EAST, WEST);
        Direction.setOpposites(UP, DOWN);
        Direction.setOpposites(NORTH, SOUTH);
        Direction.NONE.opposite = NONE;
        Direction.UP.side = Side.TOP;
        Direction.DOWN.side = Side.BOTTOM;
        Direction.NORTH.side = Side.NORTH;
        Direction.EAST.side = Side.EAST;
        Direction.SOUTH.side = Side.SOUTH;
        Direction.WEST.side = Side.WEST;
        Direction.NONE.side = Side.NONE;
        Direction.NORTH.index = 0;
        Direction.EAST.index = 1;
        Direction.SOUTH.index = 2;
        Direction.WEST.index = 3;
        Direction.UP.index = 4;
        Direction.DOWN.index = 5;
        rotXMap = new Direction[]{DOWN, NORTH, UP, SOUTH, UP, SOUTH, DOWN, NORTH, NORTH, UP, SOUTH, DOWN, SOUTH, DOWN, NORTH, UP, WEST, WEST, WEST, WEST, EAST, EAST, EAST, EAST};
        rotYMap = new Direction[]{DOWN, DOWN, DOWN, DOWN, UP, UP, UP, UP, NORTH, WEST, SOUTH, EAST, SOUTH, EAST, NORTH, WEST, WEST, SOUTH, EAST, NORTH, EAST, NORTH, WEST, SOUTH};
        rotZMap = new Direction[]{DOWN, EAST, UP, WEST, UP, WEST, DOWN, EAST, NORTH, NORTH, NORTH, NORTH, SOUTH, SOUTH, SOUTH, SOUTH, WEST, DOWN, EAST, UP, EAST, UP, WEST, DOWN};
    }
}

