/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Objects;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.entity.TileEntityBasket;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicBasket
extends BlockLogic {
    protected BlockLogicBasket(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
        block.withEntity(TileEntityBasket::new);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        @NotNull TileEntityBasket tileEntity = (TileEntityBasket)Objects.requireNonNull(world.getTileEntity(tilePos));
        if (tileEntity.getNumUnitsInside() > 0) {
            tileEntity.givePlayerAllItems(world, player);
            return true;
        }
        return false;
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        @NotNull TileEntityBasket tileEntity = (TileEntityBasket)Objects.requireNonNull(world.getTileEntity(tilePos));
        if (tileEntity.getNumUnitsInside() > 0) {
            tileEntity.dropContents(world, tilePos.x(), tilePos.y(), tilePos.z());
        }
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        if (side == Side.TOP) {
            return PartialSupport.INSTANCE;
        }
        return FullSupport.INSTANCE;
    }

    public int getFillLevel(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        @NotNull TileEntityBasket tileEntity = (TileEntityBasket)Objects.requireNonNull(source.getTileEntity(tilePos));
        float fill = MathHelper.clamp((float)tileEntity.getNumUnitsInside() / (float)tileEntity.getMaxUnits(), 0.0f, 1.0f);
        return (int)Math.ceil(10.0f * fill);
    }

    @Deprecated
    public final int getFillLevel(@NotNull WorldSource source, int x, int y, int z) {
        return this.getFillLevel(source, new TilePos(x, y, z));
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        TilePos queryPos = new TilePos();
        for (Direction d : Direction.directions) {
            world.notifyBlocksOfNeighborChange(tilePos.add(d, queryPos), this.block);
        }
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        TilePos queryPos = new TilePos();
        for (Direction d : Direction.directions) {
            world.notifyBlocksOfNeighborChange(tilePos.add(d, queryPos), this.block);
        }
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        @NotNull TileEntityBasket tileEntity = (TileEntityBasket)Objects.requireNonNull(source.getTileEntity(tilePos));
        return tileEntity.getNumUnitsInside() >= tileEntity.getMaxUnits();
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return this.isEmittingSignal(world, tilePos, side);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.BASKET)};
    }
}

