/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import com.github.zarzelcow.legacylwjgl3.implementation.LWJGLImplementationUtils;
import com.github.zarzelcow.legacylwjgl3.implementation.input.InputImplementation;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.OpenGLPackageAccess;

public class Keyboard {
    public static final int EVENT_SIZE = 18;
    private static final int BUFFER_SIZE = 50;
    public static final int KEYBOARD_SIZE = 349;
    private static boolean created;
    private static boolean repeat_enabled;
    private static final ByteBuffer keyDownBuffer;
    private static ByteBuffer readBuffer;
    private static KeyEvent current_event;
    private static KeyEvent tmp_event;
    private static boolean initialized;
    private static InputImplementation implementation;
    private static final String[] keyNames;
    private static final Map<String, Integer> keyMap;
    public static final int CHAR_NONE = 0;
    public static final int KEY_NONE;
    public static final int KEY_SPACE;
    public static final int KEY_APOSTROPHE;
    public static final int KEY_COMMA;
    public static final int KEY_MINUS;
    public static final int KEY_PERIOD;
    public static final int KEY_SLASH;
    public static final int KEY_0;
    public static final int KEY_1;
    public static final int KEY_2;
    public static final int KEY_3;
    public static final int KEY_4;
    public static final int KEY_5;
    public static final int KEY_6;
    public static final int KEY_7;
    public static final int KEY_8;
    public static final int KEY_9;
    public static final int KEY_SEMICOLON;
    public static final int KEY_EQUALS;
    public static final int KEY_A;
    public static final int KEY_B;
    public static final int KEY_C;
    public static final int KEY_D;
    public static final int KEY_E;
    public static final int KEY_F;
    public static final int KEY_G;
    public static final int KEY_H;
    public static final int KEY_I;
    public static final int KEY_J;
    public static final int KEY_K;
    public static final int KEY_L;
    public static final int KEY_M;
    public static final int KEY_N;
    public static final int KEY_O;
    public static final int KEY_P;
    public static final int KEY_Q;
    public static final int KEY_R;
    public static final int KEY_S;
    public static final int KEY_T;
    public static final int KEY_U;
    public static final int KEY_V;
    public static final int KEY_W;
    public static final int KEY_X;
    public static final int KEY_Y;
    public static final int KEY_Z;
    public static final int KEY_LBRACKET;
    public static final int KEY_BACKSLASH;
    public static final int KEY_RBRACKET;
    public static final int KEY_GRAVE;
    public static final int KEY_WORLD_1;
    public static final int KEY_WORLD_2;
    public static final int KEY_ESCAPE;
    public static final int KEY_RETURN;
    public static final int KEY_TAB;
    public static final int KEY_BACK;
    public static final int KEY_INSERT;
    public static final int KEY_DELETE;
    public static final int KEY_RIGHT;
    public static final int KEY_LEFT;
    public static final int KEY_DOWN;
    public static final int KEY_UP;
    public static final int KEY_PRIOR;
    public static final int KEY_NEXT;
    public static final int KEY_HOME;
    public static final int KEY_END;
    public static final int KEY_CAPITAL;
    public static final int KEY_SCROLL;
    public static final int KEY_NUMLOCK;
    public static final int KEY_PRINT_SCREEN;
    public static final int KEY_PAUSE;
    public static final int KEY_F1;
    public static final int KEY_F2;
    public static final int KEY_F3;
    public static final int KEY_F4;
    public static final int KEY_F5;
    public static final int KEY_F6;
    public static final int KEY_F7;
    public static final int KEY_F8;
    public static final int KEY_F9;
    public static final int KEY_F10;
    public static final int KEY_F11;
    public static final int KEY_F12;
    public static final int KEY_F13;
    public static final int KEY_F14;
    public static final int KEY_F15;
    public static final int KEY_F16;
    public static final int KEY_F17;
    public static final int KEY_F18;
    public static final int KEY_F19;
    public static final int KEY_F20;
    public static final int KEY_F21;
    public static final int KEY_F22;
    public static final int KEY_F23;
    public static final int KEY_F24;
    public static final int KEY_F25;
    public static final int KEY_NUMPAD0;
    public static final int KEY_NUMPAD1;
    public static final int KEY_NUMPAD2;
    public static final int KEY_NUMPAD3;
    public static final int KEY_NUMPAD4;
    public static final int KEY_NUMPAD5;
    public static final int KEY_NUMPAD6;
    public static final int KEY_NUMPAD7;
    public static final int KEY_NUMPAD8;
    public static final int KEY_NUMPAD9;
    public static final int KEY_DECIMAL;
    public static final int KEY_DIVIDE;
    public static final int KEY_MULTIPLY;
    public static final int KEY_SUBTRACT;
    public static final int KEY_ADD;
    public static final int KEY_NUMPADENTER;
    public static final int KEY_NUMPADEQUALS;
    public static final int KEY_LSHIFT;
    public static final int KEY_LCONTROL;
    public static final int KEY_LMENU;
    public static final int KEY_LMETA;
    public static final int KEY_RSHIFT;
    public static final int KEY_RCONTROL;
    public static final int KEY_RMENU;
    public static final int KEY_RMETA;
    public static final int KEY_MENU;

    private Keyboard() {
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        Sys.initialize();
        initialized = true;
    }

    private static void create(InputImplementation impl) throws LWJGLException {
        if (created) {
            return;
        }
        if (!initialized) {
            Keyboard.initialize();
        }
        implementation = impl;
        implementation.createKeyboard();
        created = true;
        readBuffer = ByteBuffer.allocate(900);
        Keyboard.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create() throws LWJGLException {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            Keyboard.create(LWJGLImplementationUtils.getOrCreateInputImplementation());
        }
    }

    private static void reset() {
        readBuffer.limit(0);
        for (int i = 0; i < keyDownBuffer.remaining(); ++i) {
            keyDownBuffer.put(i, (byte)0);
        }
        Keyboard.current_event.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCreated() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            return created;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (!created) {
                return;
            }
            created = false;
            implementation.destroyKeyboard();
            Keyboard.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poll() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (!created) {
                throw new IllegalStateException("Keyboard must be created before you can poll the device");
            }
            implementation.pollKeyboard(keyDownBuffer);
            Keyboard.read();
        }
    }

    private static void read() {
        readBuffer.compact();
        implementation.readKeyboard(readBuffer);
        readBuffer.flip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isKeyDown(int key) {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (!created) {
                throw new IllegalStateException("Keyboard must be created before you can query key state");
            }
            return keyDownBuffer.get(key) != 0;
        }
    }

    public static synchronized String getKeyName(int key) {
        return keyNames[key];
    }

    public static synchronized int getKeyIndex(String keyName) {
        return keyMap.getOrDefault(keyName, KEY_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumKeyboardEvents() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (!created) {
                throw new IllegalStateException("Keyboard must be created before you can read events");
            }
            int old_position = readBuffer.position();
            int num_events = 0;
            while (Keyboard.readNext(tmp_event) && (!tmp_event.repeat || repeat_enabled)) {
                ++num_events;
            }
            readBuffer.position(old_position);
            return num_events;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean next() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            boolean result;
            if (!created) {
                throw new IllegalStateException("Keyboard must be created before you can read events");
            }
            while ((result = Keyboard.readNext(current_event)) && current_event.repeat && !repeat_enabled) {
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableRepeatEvents(boolean enable) {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            repeat_enabled = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean areRepeatEventsEnabled() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            return repeat_enabled;
        }
    }

    private static boolean readNext(KeyEvent event) {
        if (readBuffer.hasRemaining()) {
            event.key = Keyboard.readBuffer.getInt();
            event.state = Keyboard.readBuffer.get() != 0;
            event.character = Keyboard.readBuffer.getInt();
            event.nanos = Keyboard.readBuffer.getLong();
            event.repeat = Keyboard.readBuffer.get() == 1;
            return true;
        }
        return false;
    }

    public static int getKeyCount() {
        return keyMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char getEventCharacter() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            return (char)current_event.character;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getEventKey() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            return current_event.key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getEventKeyState() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            return current_event.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getEventNanoseconds() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            return current_event.nanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRepeatEvent() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            return current_event.repeat;
        }
    }

    private static int register(String name, int lwjglCode) {
        Keyboard.keyNames[lwjglCode] = name;
        keyMap.put(name, lwjglCode);
        return lwjglCode;
    }

    static {
        keyDownBuffer = BufferUtils.createByteBuffer(349);
        current_event = new KeyEvent();
        tmp_event = new KeyEvent();
        keyNames = new String[349];
        keyMap = new HashMap<String, Integer>(253);
        KEY_NONE = Keyboard.register("NONE", 0);
        KEY_SPACE = Keyboard.register("SPACE", 57);
        KEY_APOSTROPHE = Keyboard.register("APOSTROPHE", 40);
        KEY_COMMA = Keyboard.register("COMMA", 51);
        KEY_MINUS = Keyboard.register("MINUS", 12);
        KEY_PERIOD = Keyboard.register("PERIOD", 52);
        KEY_SLASH = Keyboard.register("SLASH", 53);
        KEY_0 = Keyboard.register("0", 11);
        KEY_1 = Keyboard.register("1", 2);
        KEY_2 = Keyboard.register("2", 3);
        KEY_3 = Keyboard.register("3", 4);
        KEY_4 = Keyboard.register("4", 5);
        KEY_5 = Keyboard.register("5", 6);
        KEY_6 = Keyboard.register("6", 7);
        KEY_7 = Keyboard.register("7", 8);
        KEY_8 = Keyboard.register("8", 9);
        KEY_9 = Keyboard.register("9", 10);
        KEY_SEMICOLON = Keyboard.register("SEMICOLON", 39);
        KEY_EQUALS = Keyboard.register("EQUALS", 13);
        KEY_A = Keyboard.register("A", 30);
        KEY_B = Keyboard.register("B", 48);
        KEY_C = Keyboard.register("C", 46);
        KEY_D = Keyboard.register("D", 32);
        KEY_E = Keyboard.register("E", 18);
        KEY_F = Keyboard.register("F", 33);
        KEY_G = Keyboard.register("G", 34);
        KEY_H = Keyboard.register("H", 35);
        KEY_I = Keyboard.register("I", 23);
        KEY_J = Keyboard.register("J", 36);
        KEY_K = Keyboard.register("K", 37);
        KEY_L = Keyboard.register("L", 38);
        KEY_M = Keyboard.register("M", 50);
        KEY_N = Keyboard.register("N", 49);
        KEY_O = Keyboard.register("O", 24);
        KEY_P = Keyboard.register("P", 25);
        KEY_Q = Keyboard.register("Q", 16);
        KEY_R = Keyboard.register("R", 19);
        KEY_S = Keyboard.register("S", 31);
        KEY_T = Keyboard.register("T", 20);
        KEY_U = Keyboard.register("U", 22);
        KEY_V = Keyboard.register("V", 47);
        KEY_W = Keyboard.register("W", 17);
        KEY_X = Keyboard.register("X", 45);
        KEY_Y = Keyboard.register("Y", 21);
        KEY_Z = Keyboard.register("Z", 44);
        KEY_LBRACKET = Keyboard.register("LBRACKET", 26);
        KEY_BACKSLASH = Keyboard.register("BACKSLASH", 43);
        KEY_RBRACKET = Keyboard.register("RBRACKET", 27);
        KEY_GRAVE = Keyboard.register("GRAVE", 41);
        KEY_WORLD_1 = Keyboard.register("WORLD_1", 161);
        KEY_WORLD_2 = Keyboard.register("WORLD_2", 162);
        KEY_ESCAPE = Keyboard.register("ESCAPE", 1);
        KEY_RETURN = Keyboard.register("RETURN", 28);
        KEY_TAB = Keyboard.register("TAB", 15);
        KEY_BACK = Keyboard.register("BACK", 14);
        KEY_INSERT = Keyboard.register("INSERT", 210);
        KEY_DELETE = Keyboard.register("DELETE", 211);
        KEY_RIGHT = Keyboard.register("RIGHT", 205);
        KEY_LEFT = Keyboard.register("LEFT", 203);
        KEY_DOWN = Keyboard.register("DOWN", 208);
        KEY_UP = Keyboard.register("UP", 200);
        KEY_PRIOR = Keyboard.register("PRIOR", 201);
        KEY_NEXT = Keyboard.register("NEXT", 209);
        KEY_HOME = Keyboard.register("HOME", 199);
        KEY_END = Keyboard.register("END", 207);
        KEY_CAPITAL = Keyboard.register("CAPITAL", 58);
        KEY_SCROLL = Keyboard.register("SCROLL", 70);
        KEY_NUMLOCK = Keyboard.register("NUMLOCK", 69);
        KEY_PRINT_SCREEN = Keyboard.register("PRINT_SCREEN", 28);
        KEY_PAUSE = Keyboard.register("PAUSE", 197);
        KEY_F1 = Keyboard.register("F1", 59);
        KEY_F2 = Keyboard.register("F2", 60);
        KEY_F3 = Keyboard.register("F3", 61);
        KEY_F4 = Keyboard.register("F4", 62);
        KEY_F5 = Keyboard.register("F5", 63);
        KEY_F6 = Keyboard.register("F6", 64);
        KEY_F7 = Keyboard.register("F7", 65);
        KEY_F8 = Keyboard.register("F8", 66);
        KEY_F9 = Keyboard.register("F9", 67);
        KEY_F10 = Keyboard.register("F10", 68);
        KEY_F11 = Keyboard.register("F11", 87);
        KEY_F12 = Keyboard.register("F12", 88);
        KEY_F13 = Keyboard.register("F13", 100);
        KEY_F14 = Keyboard.register("F14", 101);
        KEY_F15 = Keyboard.register("F15", 102);
        KEY_F16 = Keyboard.register("F16", 103);
        KEY_F17 = Keyboard.register("F17", 104);
        KEY_F18 = Keyboard.register("F18", 105);
        KEY_F19 = Keyboard.register("F19", 113);
        KEY_F20 = Keyboard.register("F20", 309);
        KEY_F21 = Keyboard.register("F21", 310);
        KEY_F22 = Keyboard.register("F22", 311);
        KEY_F23 = Keyboard.register("F23", 312);
        KEY_F24 = Keyboard.register("F24", 313);
        KEY_F25 = Keyboard.register("F25", 314);
        KEY_NUMPAD0 = Keyboard.register("NUMPAD0", 82);
        KEY_NUMPAD1 = Keyboard.register("NUMPAD1", 79);
        KEY_NUMPAD2 = Keyboard.register("NUMPAD2", 80);
        KEY_NUMPAD3 = Keyboard.register("NUMPAD3", 81);
        KEY_NUMPAD4 = Keyboard.register("NUMPAD4", 75);
        KEY_NUMPAD5 = Keyboard.register("NUMPAD5", 76);
        KEY_NUMPAD6 = Keyboard.register("NUMPAD6", 77);
        KEY_NUMPAD7 = Keyboard.register("NUMPAD7", 71);
        KEY_NUMPAD8 = Keyboard.register("NUMPAD8", 72);
        KEY_NUMPAD9 = Keyboard.register("NUMPAD9", 73);
        KEY_DECIMAL = Keyboard.register("DECIMAL", 83);
        KEY_DIVIDE = Keyboard.register("DIVIDE", 181);
        KEY_MULTIPLY = Keyboard.register("MULTIPLY", 55);
        KEY_SUBTRACT = Keyboard.register("SUBTRACT", 74);
        KEY_ADD = Keyboard.register("ADD", 78);
        KEY_NUMPADENTER = Keyboard.register("NUMPADENTER", 156);
        KEY_NUMPADEQUALS = Keyboard.register("NUMPADEQUALS", 141);
        KEY_LSHIFT = Keyboard.register("LSHIFT", 42);
        KEY_LCONTROL = Keyboard.register("LCONTROL", 29);
        KEY_LMENU = Keyboard.register("LMENU", 56);
        KEY_LMETA = Keyboard.register("LMETA", 219);
        KEY_RSHIFT = Keyboard.register("RSHIFT", 54);
        KEY_RCONTROL = Keyboard.register("RCONTROL", 157);
        KEY_RMENU = Keyboard.register("RMENU", 184);
        KEY_RMETA = Keyboard.register("RMETA", 220);
        KEY_MENU = Keyboard.register("MENU", 348);
    }

    private static final class KeyEvent {
        private int character;
        private int key;
        private boolean state;
        private long nanos;
        private boolean repeat;

        private KeyEvent() {
        }

        private void reset() {
            this.character = 0;
            this.key = 0;
            this.state = false;
            this.repeat = false;
        }
    }
}

