/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.nbt.UnknownTagException;
import com.mojang.nbt.tags.ByteArrayTag;
import com.mojang.nbt.tags.ByteTag;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.DoubleArrayTag;
import com.mojang.nbt.tags.DoubleTag;
import com.mojang.nbt.tags.EndTag;
import com.mojang.nbt.tags.FloatTag;
import com.mojang.nbt.tags.IntTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.LongArrayTag;
import com.mojang.nbt.tags.LongTag;
import com.mojang.nbt.tags.ShortArrayTag;
import com.mojang.nbt.tags.ShortTag;
import com.mojang.nbt.tags.StringTag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Tag<T> {
    @Nullable
    private String name = null;
    private T value;

    public Tag() {
    }

    public Tag(T value) {
        this.value = value;
    }

    abstract void read(@NotNull DataInput var1) throws IOException;

    abstract void write(@NotNull DataOutput var1) throws IOException;

    public abstract void fromJson(@NotNull JsonElement var1) throws JsonParseException;

    @NotNull
    public abstract JsonElement toJson();

    public abstract byte getId();

    @NotNull
    public String getTagName() {
        return this.name == null ? "" : this.name;
    }

    @NotNull
    public Tag<T> setName(String key) {
        this.name = key;
        return this;
    }

    public T getValue() {
        return this.value;
    }

    @NotNull
    public Tag<T> setValue(T value) {
        this.value = value;
        return this;
    }

    public static Tag<?> readNamedTag(@NotNull DataInput dis) throws IOException {
        byte typeId = dis.readByte();
        if (typeId == TagID.TAG_END.getId()) {
            return new EndTag();
        }
        try {
            Tag<?> tag = TagID.fromId(typeId).getNewTag();
            tag.name = dis.readUTF();
            tag.read(dis);
            return tag;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnknownTagException("Unknown tag type '" + typeId + "'!");
        }
    }

    public static void writeNamedTag(@NotNull Tag<?> tag, @NotNull DataOutput dos) throws IOException {
        dos.writeByte(tag.getId());
        if (tag.getId() != TagID.TAG_END.getId()) {
            dos.writeUTF(tag.getTagName());
            tag.write(dos);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)obj;
        return Objects.equals(this.getValue(), tag.getValue());
    }

    @NotNull
    public static <T> Tag<T> createTagOfType(@NotNull Class<T> type) {
        if (type.isArray()) {
            Class<?> arrayType = type.getComponentType();
            if (arrayType == Byte.class || arrayType == Byte.TYPE) {
                return new ByteArrayTag();
            }
            if (arrayType == Short.class || arrayType == Short.TYPE) {
                return new ShortArrayTag();
            }
            if (arrayType == Long.class || arrayType == Long.TYPE) {
                return new LongArrayTag();
            }
            if (arrayType == Double.class || arrayType == Double.TYPE) {
                return new DoubleArrayTag();
            }
            throw new IllegalArgumentException("No NBT Tag type for array of '" + String.valueOf(arrayType) + "'!");
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return new ByteTag();
        }
        if (type == Short.class || type == Short.TYPE) {
            return new ShortTag();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new IntTag();
        }
        if (type == Long.class || type == Long.TYPE) {
            return new LongTag();
        }
        if (type == Float.class || type == Float.TYPE) {
            return new FloatTag();
        }
        if (type == Double.class || type == Double.TYPE) {
            return new DoubleTag();
        }
        if (type == String.class) {
            return new StringTag();
        }
        if (List.class.isAssignableFrom(type)) {
            return new ListTag();
        }
        if (Map.class.isAssignableFrom(type)) {
            return new CompoundTag();
        }
        throw new IllegalArgumentException("No NBT Tag type for type '" + String.valueOf(type) + "'!");
    }

    @NotNull
    public static JsonElement serializeToJson(Tag<?> tag) {
        JsonObject tagObject = new JsonObject();
        tagObject.addProperty("type", TagID.fromId(tag.getId()).getIdString());
        tagObject.add("value", tag.toJson());
        return tagObject;
    }

    @NotNull
    public static Tag<?> deserializeFromJson(@NotNull JsonElement element) throws JsonParseException {
        if (!element.isJsonObject()) {
            throw new JsonParseException("Tag element must be a JsonObject! " + String.valueOf(element));
        }
        JsonObject object = element.getAsJsonObject();
        if (!object.has("type")) {
            throw new JsonParseException("Tag element does not have type defined!");
        }
        String type = object.get("type").getAsString();
        Tag<?> tag = TagID.fromIdString(type).getNewTag();
        if (object.has("value")) {
            tag.fromJson(object.get("value"));
        }
        return tag;
    }

    public static enum TagID {
        TAG_END(0, "TAG_End", EndTag::new),
        TAG_BYTE(1, "TAG_Byte", ByteTag::new),
        TAG_SHORT(2, "TAG_Short", ShortTag::new),
        TAG_INT(3, "TAG_Int", IntTag::new),
        TAG_LONG(4, "TAG_Long", LongTag::new),
        TAG_FLOAT(5, "TAG_Float", FloatTag::new),
        TAG_DOUBLE(6, "TAG_Double", DoubleTag::new),
        TAG_BYTE_ARRAY(7, "TAG_Byte_Array", ByteArrayTag::new),
        TAG_STRING(8, "TAG_String", StringTag::new),
        TAG_LIST(9, "TAG_List", ListTag::new),
        TAG_COMPOUND(10, "TAG_Compound", CompoundTag::new),
        TAG_SHORT_ARRAY(11, "TAG_Short_Array", ShortArrayTag::new),
        TAG_DOUBLE_ARRAY(12, "TAG_Double_Array", DoubleArrayTag::new),
        TAG_LONG_ARRAY(13, "TAG_Long_Array", LongArrayTag::new);

        private final byte id;
        @NotNull
        private final String name;
        @NotNull
        private final @NotNull Supplier<? extends @NotNull Tag<?>> tagSupplier;

        private TagID(@NotNull /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NotNull @NotNull int id, String name, Supplier<? extends Tag<?>> tagSupplier) {
            this.id = (byte)id;
            this.name = name;
            this.tagSupplier = tagSupplier;
        }

        public byte getId() {
            return this.id;
        }

        @NotNull
        public String getIdString() {
            return this.name;
        }

        @NotNull
        public Tag<?> getNewTag() {
            return this.tagSupplier.get();
        }

        @NotNull
        public static TagID fromId(byte id) {
            switch (id) {
                case 0: {
                    return TAG_END;
                }
                case 1: {
                    return TAG_BYTE;
                }
                case 2: {
                    return TAG_SHORT;
                }
                case 3: {
                    return TAG_INT;
                }
                case 4: {
                    return TAG_LONG;
                }
                case 5: {
                    return TAG_FLOAT;
                }
                case 6: {
                    return TAG_DOUBLE;
                }
                case 7: {
                    return TAG_BYTE_ARRAY;
                }
                case 8: {
                    return TAG_STRING;
                }
                case 9: {
                    return TAG_LIST;
                }
                case 10: {
                    return TAG_COMPOUND;
                }
                case 11: {
                    return TAG_SHORT_ARRAY;
                }
                case 12: {
                    return TAG_DOUBLE_ARRAY;
                }
                case 13: {
                    return TAG_LONG_ARRAY;
                }
            }
            throw new IllegalArgumentException("No NBT Tag type for id '" + id + "'!");
        }

        @NotNull
        public static TagID fromIdString(@NotNull String idString) {
            switch (idString) {
                case "TAG_End": {
                    return TAG_END;
                }
                case "TAG_Byte": {
                    return TAG_BYTE;
                }
                case "TAG_Short": {
                    return TAG_SHORT;
                }
                case "TAG_Int": {
                    return TAG_INT;
                }
                case "TAG_Long": {
                    return TAG_LONG;
                }
                case "TAG_Float": {
                    return TAG_FLOAT;
                }
                case "TAG_Double": {
                    return TAG_DOUBLE;
                }
                case "TAG_Byte_Array": {
                    return TAG_BYTE_ARRAY;
                }
                case "TAG_String": {
                    return TAG_STRING;
                }
                case "TAG_List": {
                    return TAG_LIST;
                }
                case "TAG_Compound": {
                    return TAG_COMPOUND;
                }
                case "TAG_Short_Array": {
                    return TAG_SHORT_ARRAY;
                }
                case "TAG_Double_Array": {
                    return TAG_DOUBLE_ARRAY;
                }
                case "TAG_Long_Array": {
                    return TAG_LONG_ARRAY;
                }
            }
            throw new IllegalArgumentException("No NBT Tag type for type '" + idString + "'!");
        }
    }
}

